/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerStaxUnmarshaller
implements Unmarshaller<LoadBalancer, StaxUnmarshallerContext> {
    private static LoadBalancerStaxUnmarshaller instance;

    @Override
    public LoadBalancer unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadBalancer loadBalancer = new LoadBalancer();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return loadBalancer;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Name", targetDepth)) continue;
                loadBalancer.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return loadBalancer;
    }

    public static LoadBalancerStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerStaxUnmarshaller();
        }
        return instance;
    }
}

