/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDNFencing {
    protected static final Log LOG = LogFactory.getLog(TestDNFencing.class);
    private static final String TEST_FILE = "/testStandbyIsHot";
    private static final Path TEST_FILE_PATH = new Path("/testStandbyIsHot");
    private static final int SMALL_BLOCK = 1024;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private NameNode nn1;
    private NameNode nn2;
    private FileSystem fs;

    @Before
    public void setupCluster() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("dfs.blocksize", 1024);
        this.conf.setInt("dfs.namenode.replication.interval", 600);
        this.conf.setInt("dfs.namenode.replication.max-streams", 1000);
        this.conf.setClass("dfs.block.replicator.classname", RandomDeleterPolicy.class, BlockPlacementPolicy.class);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        this.nn1 = this.cluster.getNameNode(0);
        this.nn2 = this.cluster.getNameNode(1);
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        this.cluster.triggerBlockReports();
        this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void shutdownCluster() throws Exception {
        if (this.cluster != null) {
            this.banner("Shutting down cluster. NN1 metadata:");
            this.doMetasave(this.nn1);
            this.banner("Shutting down cluster. NN2 metadata:");
            this.doMetasave(this.nn2);
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDnFencing() throws Exception {
        DFSTestUtil.createFile(this.fs, TEST_FILE_PATH, 30720L, (short)3, 1L);
        ExtendedBlock block = DFSTestUtil.getFirstBlock(this.fs, TEST_FILE_PATH);
        this.nn1.getRpcServer().setReplication(TEST_FILE, (short)1);
        BlockManagerTestUtil.computeInvalidationWork(this.nn1.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        this.banner("Failing to NN2 but let NN1 continue to think it's active");
        NameNodeAdapter.abortEditLogs(this.nn1);
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        this.cluster.transitionToActive(1);
        Assert.assertEquals((long)1L, (long)this.nn2.getRpcServer().getFileInfo(TEST_FILE).getReplication());
        this.banner("NN2 Metadata immediately after failover");
        this.doMetasave(this.nn2);
        Assert.assertEquals((long)30L, (long)this.nn2.getNamesystem().getPostponedMisreplicatedBlocks());
        this.banner("Triggering heartbeats and block reports so that fencing is completed");
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        this.banner("Metadata after nodes have all block-reported");
        this.doMetasave(this.nn2);
        BlockManager nn2BM = this.nn2.getNamesystem().getBlockManager();
        BlockManagerTestUtil.checkHeartbeat(nn2BM);
        BlockManagerTestUtil.rescanPostponedMisreplicatedBlocks(nn2BM);
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPostponedMisreplicatedBlocks());
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getUnderReplicatedBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPendingReplicationBlocks());
        this.banner("Making sure the file is still readable");
        DistributedFileSystem fs2 = this.cluster.getFileSystem(1);
        DFSTestUtil.readFile((FileSystem)fs2, TEST_FILE_PATH);
        this.banner("Waiting for the actual block files to get deleted from DNs.");
        this.waitForTrueReplication(this.cluster, block, 1);
    }

    @Test
    public void testNNClearsCommandsOnFailoverAfterStartup() throws Exception {
        DFSTestUtil.createFile(this.fs, TEST_FILE_PATH, 30720L, (short)3, 1L);
        this.banner("Shutting down NN2");
        this.cluster.shutdownNameNode(1);
        this.banner("Setting replication to 1, rolling edit log.");
        this.nn1.getRpcServer().setReplication(TEST_FILE, (short)1);
        this.nn1.getRpcServer().rollEditLog();
        this.banner("Starting NN2 again.");
        this.cluster.restartNameNode(1);
        this.nn2 = this.cluster.getNameNode(1);
        this.banner("triggering BRs");
        this.cluster.triggerBlockReports();
        this.banner("computing invalidation on nn1");
        BlockManagerTestUtil.computeInvalidationWork(this.nn1.getNamesystem().getBlockManager());
        this.banner("computing invalidation on nn2");
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        this.banner("Metadata immediately before failover");
        this.doMetasave(this.nn2);
        this.banner("Failing to NN2 but let NN1 continue to think it's active");
        NameNodeAdapter.abortEditLogs(this.nn1);
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        this.cluster.transitionToActive(1);
        Assert.assertEquals((long)1L, (long)this.nn2.getRpcServer().getFileInfo(TEST_FILE).getReplication());
        this.banner("Metadata immediately after failover");
        this.doMetasave(this.nn2);
        this.banner("Triggering heartbeats and block reports so that fencing is completed");
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        this.banner("Metadata after nodes have all block-reported");
        this.doMetasave(this.nn2);
        BlockManager nn2BM = this.nn2.getNamesystem().getBlockManager();
        BlockManagerTestUtil.checkHeartbeat(nn2BM);
        BlockManagerTestUtil.rescanPostponedMisreplicatedBlocks(nn2BM);
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPostponedMisreplicatedBlocks());
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        HATestUtil.waitForNNToIssueDeletions(this.nn2);
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getUnderReplicatedBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPendingReplicationBlocks());
        this.banner("Making sure the file is still readable");
        DistributedFileSystem fs2 = this.cluster.getFileSystem(1);
        DFSTestUtil.readFile((FileSystem)fs2, TEST_FILE_PATH);
    }

    @Test
    public void testNNClearsCommandsOnFailoverWithReplChanges() throws Exception {
        DFSTestUtil.createFile(this.fs, TEST_FILE_PATH, 30720L, (short)1, 1L);
        this.banner("rolling NN1's edit log, forcing catch-up");
        HATestUtil.waitForStandbyToCatchUp(this.nn1, this.nn2);
        this.nn1.getRpcServer().setReplication(TEST_FILE, (short)2);
        while (BlockManagerTestUtil.getComputedDatanodeWork(this.nn1.getNamesystem().getBlockManager()) > 0) {
            LOG.info((Object)"Getting more replication work computed");
        }
        BlockManager bm1 = this.nn1.getNamesystem().getBlockManager();
        while (bm1.getPendingReplicationBlocksCount() > 0L) {
            BlockManagerTestUtil.updateState(bm1);
            this.cluster.triggerHeartbeats();
            Thread.sleep(1000L);
        }
        this.banner("triggering BRs");
        this.cluster.triggerBlockReports();
        this.nn1.getRpcServer().setReplication(TEST_FILE, (short)1);
        this.banner("computing invalidation on nn1");
        BlockManagerTestUtil.computeInvalidationWork(this.nn1.getNamesystem().getBlockManager());
        this.doMetasave(this.nn1);
        this.banner("computing invalidation on nn2");
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        this.doMetasave(this.nn2);
        this.banner("Metadata immediately before failover");
        this.doMetasave(this.nn2);
        this.banner("Failing to NN2 but let NN1 continue to think it's active");
        NameNodeAdapter.abortEditLogs(this.nn1);
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        this.cluster.transitionToActive(1);
        Assert.assertEquals((long)1L, (long)this.nn2.getRpcServer().getFileInfo(TEST_FILE).getReplication());
        this.banner("Metadata immediately after failover");
        this.doMetasave(this.nn2);
        this.banner("Triggering heartbeats and block reports so that fencing is completed");
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        this.banner("Metadata after nodes have all block-reported");
        this.doMetasave(this.nn2);
        BlockManager nn2BM = this.nn2.getNamesystem().getBlockManager();
        BlockManagerTestUtil.checkHeartbeat(nn2BM);
        BlockManagerTestUtil.rescanPostponedMisreplicatedBlocks(nn2BM);
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPostponedMisreplicatedBlocks());
        BlockManagerTestUtil.computeInvalidationWork(this.nn2.getNamesystem().getBlockManager());
        HATestUtil.waitForNNToIssueDeletions(this.nn2);
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getUnderReplicatedBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getPendingReplicationBlocks());
        this.banner("Making sure the file is still readable");
        DistributedFileSystem fs2 = this.cluster.getFileSystem(1);
        DFSTestUtil.readFile((FileSystem)fs2, TEST_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReportsWhileFileBeingWritten() throws Exception {
        FSDataOutputStream out = this.fs.create(TEST_FILE_PATH);
        try {
            AppendTestUtil.write((OutputStream)out, 0, 10);
            out.hflush();
            this.cluster.triggerBlockReports();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        BlockManagerTestUtil.updateState(this.nn1.getNamesystem().getBlockManager());
        BlockManagerTestUtil.updateState(this.nn2.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getCorruptReplicaBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getCorruptReplicaBlocks());
        DFSTestUtil.readFile(this.fs, TEST_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueingWithAppend() throws Exception {
        int numQueued = 0;
        int numDN = this.cluster.getDataNodes().size();
        FSDataOutputStream out = this.fs.create(TEST_FILE_PATH);
        try {
            AppendTestUtil.write((OutputStream)out, 0, 10);
            out.hflush();
            this.cluster.triggerBlockReports();
            numQueued += numDN;
            numQueued += numDN;
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            numQueued += numDN;
        }
        this.cluster.triggerBlockReports();
        Assert.assertEquals((long)(numQueued += numDN), (long)this.cluster.getNameNode(1).getNamesystem().getPendingDataNodeMessageCount());
        try {
            out = this.fs.append(TEST_FILE_PATH);
            AppendTestUtil.write((OutputStream)out, 10, 10);
            out.hflush();
            this.cluster.triggerBlockReports();
            numQueued += numDN * 2;
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            numQueued += numDN;
        }
        Assert.assertEquals((long)numQueued, (long)this.cluster.getNameNode(1).getNamesystem().getPendingDataNodeMessageCount());
        try {
            out = this.fs.append(TEST_FILE_PATH);
            AppendTestUtil.write((OutputStream)out, 20, 10);
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            numQueued += numDN;
        }
        this.cluster.triggerBlockReports();
        LOG.info((Object)("Expect " + (numQueued += numDN) + " and got: " + this.cluster.getNameNode(1).getNamesystem().getPendingDataNodeMessageCount()));
        Assert.assertEquals((long)numQueued, (long)this.cluster.getNameNode(1).getNamesystem().getPendingDataNodeMessageCount());
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        BlockManagerTestUtil.updateState(this.nn1.getNamesystem().getBlockManager());
        BlockManagerTestUtil.updateState(this.nn2.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getCorruptReplicaBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getCorruptReplicaBlocks());
        AppendTestUtil.check(this.fs, TEST_FILE_PATH, 30L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRBWReportArrivesAfterEdits() throws Exception {
        final CountDownLatch brFinished = new CountDownLatch(1);
        GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object passThrough(InvocationOnMock invocation) throws Throwable {
                try {
                    Object object = super.passThrough(invocation);
                    return object;
                }
                finally {
                    brFinished.countDown();
                }
            }
        };
        FSDataOutputStream out = this.fs.create(TEST_FILE_PATH);
        try {
            AppendTestUtil.write((OutputStream)out, 0, 10);
            out.hflush();
            DataNode dn = this.cluster.getDataNodes().get(0);
            DatanodeProtocolClientSideTranslatorPB spy = DataNodeTestUtils.spyOnBposToNN(dn, this.nn2);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)delayer).when((Object)spy)).blockReport((DatanodeRegistration)Mockito.anyObject(), Mockito.anyString(), (StorageBlockReport[])Mockito.anyObject(), (BlockReportContext)Mockito.anyObject());
            dn.scheduleAllBlockReport(0L);
            delayer.waitForCall();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        delayer.proceed();
        brFinished.await();
        BlockManagerTestUtil.updateState(this.nn1.getNamesystem().getBlockManager());
        BlockManagerTestUtil.updateState(this.nn2.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getCorruptReplicaBlocks());
        Assert.assertEquals((long)0L, (long)this.nn2.getNamesystem().getCorruptReplicaBlocks());
        DFSTestUtil.readFile(this.fs, TEST_FILE_PATH);
    }

    private void banner(String string) {
        LOG.info((Object)("\n\n\n\n================================================\n" + string + "\n" + "==================================================\n\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMetasave(NameNode nn2) {
        nn2.getNamesystem().writeLock();
        try {
            PrintWriter pw = new PrintWriter(System.err);
            nn2.getNamesystem().getBlockManager().metaSave(pw);
            pw.flush();
        }
        finally {
            nn2.getNamesystem().writeUnlock();
        }
    }

    private void waitForTrueReplication(final MiniDFSCluster cluster, final ExtendedBlock block, final int waitFor) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    return TestDNFencing.this.getTrueReplication(cluster, block) == waitFor;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (int)500, (int)10000);
    }

    private int getTrueReplication(MiniDFSCluster cluster, ExtendedBlock block) throws IOException {
        int count = 0;
        for (DataNode dn : cluster.getDataNodes()) {
            if (DataNodeTestUtils.getFSDataset(dn).getStoredBlock(block.getBlockPoolId(), block.getBlockId()) == null) continue;
            ++count;
        }
        return count;
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
    }

    public static class RandomDeleterPolicy
    extends BlockPlacementPolicyDefault {
        public DatanodeStorageInfo chooseReplicaToDelete(BlockCollection inode, Block block, short replicationFactor, Collection<DatanodeStorageInfo> first, Collection<DatanodeStorageInfo> second, List<StorageType> excessTypes) {
            Collection<DatanodeStorageInfo> chooseFrom = !first.isEmpty() ? first : second;
            ArrayList l = Lists.newArrayList(chooseFrom);
            return (DatanodeStorageInfo)l.get(DFSUtil.getRandom().nextInt(l.size()));
        }
    }
}

