/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.TestReplicationPolicy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockStoragePolicy {
    public static final BlockStoragePolicySuite POLICY_SUITE;
    public static final BlockStoragePolicy DEFAULT_STORAGE_POLICY;
    public static final Configuration conf;
    static final EnumSet<StorageType> none;
    static final EnumSet<StorageType> archive;
    static final EnumSet<StorageType> disk;
    static final EnumSet<StorageType> both;
    static final long FILE_LEN = 1024L;
    static final short REPLICATION = 3;
    static final byte COLD = 2;
    static final byte WARM = 5;
    static final byte HOT = 7;
    static final byte ONESSD = 10;
    static final byte ALLSSD = 12;
    static final byte LAZY_PERSIST = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testConfigKeyEnabled() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.storage.policy.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            cluster.getFileSystem().setStoragePolicy(new Path("/"), "COLD");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L, expected=IOException.class)
    public void testConfigKeyDisabled() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.storage.policy.enabled", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            cluster.getFileSystem().setStoragePolicy(new Path("/"), "COLD");
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testDefaultPolicies() {
        List computed;
        short replication;
        HashMap<Byte, String> expectedPolicyStrings = new HashMap<Byte, String>();
        expectedPolicyStrings.put((byte)2, "BlockStoragePolicy{COLD:2, storageTypes=[ARCHIVE], creationFallbacks=[], replicationFallbacks=[]}");
        expectedPolicyStrings.put((byte)5, "BlockStoragePolicy{WARM:5, storageTypes=[DISK, ARCHIVE], creationFallbacks=[DISK, ARCHIVE], replicationFallbacks=[DISK, ARCHIVE]}");
        expectedPolicyStrings.put((byte)7, "BlockStoragePolicy{HOT:7, storageTypes=[DISK], creationFallbacks=[], replicationFallbacks=[ARCHIVE]}");
        expectedPolicyStrings.put((byte)10, "BlockStoragePolicy{ONE_SSD:10, storageTypes=[SSD, DISK], creationFallbacks=[SSD, DISK], replicationFallbacks=[SSD, DISK]}");
        expectedPolicyStrings.put((byte)12, "BlockStoragePolicy{ALL_SSD:12, storageTypes=[SSD], creationFallbacks=[DISK], replicationFallbacks=[DISK]}");
        expectedPolicyStrings.put((byte)15, "BlockStoragePolicy{LAZY_PERSIST:15, storageTypes=[RAM_DISK, DISK], creationFallbacks=[DISK], replicationFallbacks=[DISK]}");
        for (byte i = 1; i < 16; i = (byte)(i + 1)) {
            BlockStoragePolicy policy = POLICY_SUITE.getPolicy(i);
            if (policy == null) continue;
            String s = policy.toString();
            Assert.assertEquals(expectedPolicyStrings.get(i), (Object)s);
        }
        Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)7), (Object)POLICY_SUITE.getDefaultPolicy());
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        for (replication = 1; replication < 6; replication = (short)(replication + 1)) {
            computed = cold.chooseStorageTypes(replication);
            TestBlockStoragePolicy.assertStorageType(computed, replication, StorageType.ARCHIVE);
        }
        TestBlockStoragePolicy.assertCreationFallback(cold, null, null, null);
        TestBlockStoragePolicy.assertReplicationFallback(cold, null, null, null);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        for (replication = 1; replication < 6; replication = (short)(replication + 1)) {
            computed = warm.chooseStorageTypes(replication);
            TestBlockStoragePolicy.assertStorageType(computed, replication, StorageType.DISK, StorageType.ARCHIVE);
        }
        TestBlockStoragePolicy.assertCreationFallback(warm, StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        TestBlockStoragePolicy.assertReplicationFallback(warm, StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        for (replication = 1; replication < 6; replication = (short)(replication + 1)) {
            computed = hot.chooseStorageTypes(replication);
            TestBlockStoragePolicy.assertStorageType(computed, replication, StorageType.DISK);
        }
        TestBlockStoragePolicy.assertCreationFallback(hot, null, null, null);
        TestBlockStoragePolicy.assertReplicationFallback(hot, StorageType.ARCHIVE, null, StorageType.ARCHIVE);
    }

    static StorageType[] newStorageTypes(int nDisk, int nArchive) {
        Object[] t = new StorageType[nDisk + nArchive];
        Arrays.fill(t, 0, nDisk, StorageType.DISK);
        Arrays.fill(t, nDisk, t.length, StorageType.ARCHIVE);
        return t;
    }

    static List<StorageType> asList(int nDisk, int nArchive) {
        return Arrays.asList(TestBlockStoragePolicy.newStorageTypes(nDisk, nArchive));
    }

    static void assertStorageType(List<StorageType> computed, short replication, StorageType ... answers) {
        Assert.assertEquals((long)replication, (long)computed.size());
        StorageType last = answers[answers.length - 1];
        for (int i = 0; i < computed.size(); ++i) {
            StorageType expected = i < answers.length ? answers[i] : last;
            Assert.assertEquals((Object)expected, (Object)computed.get(i));
        }
    }

    static void assertCreationFallback(BlockStoragePolicy policy, StorageType noneExpected, StorageType archiveExpected, StorageType diskExpected) {
        Assert.assertEquals((Object)noneExpected, (Object)policy.getCreationFallback(none));
        Assert.assertEquals((Object)archiveExpected, (Object)policy.getCreationFallback(archive));
        Assert.assertEquals((Object)diskExpected, (Object)policy.getCreationFallback(disk));
        Assert.assertEquals(null, (Object)policy.getCreationFallback(both));
    }

    static void assertReplicationFallback(BlockStoragePolicy policy, StorageType noneExpected, StorageType archiveExpected, StorageType diskExpected) {
        Assert.assertEquals((Object)noneExpected, (Object)policy.getReplicationFallback(none));
        Assert.assertEquals((Object)archiveExpected, (Object)policy.getReplicationFallback(archive));
        Assert.assertEquals((Object)diskExpected, (Object)policy.getReplicationFallback(disk));
        Assert.assertEquals(null, (Object)policy.getReplicationFallback(both));
    }

    @Test
    public void testChooseStorageTypes() {
        TestBlockStoragePolicy.run(CheckChooseStorageTypes.Basic);
        TestBlockStoragePolicy.run(CheckChooseStorageTypes.EmptyUnavailablesAndNewBlock);
        TestBlockStoragePolicy.run(CheckChooseStorageTypes.EmptyUnavailablesAndNonNewBlock);
    }

    private static void run(CheckChooseStorageTypes method) {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        List<Object> chosen = Lists.newArrayList();
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(cold, (short)3, chosen, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
    }

    @Test
    public void testChooseStorageTypesWithBothUnavailable() {
        TestBlockStoragePolicy.runWithBothUnavailable(CheckChooseStorageTypes.BothUnavailableAndNewBlock);
        TestBlockStoragePolicy.runWithBothUnavailable(CheckChooseStorageTypes.BothUnavailableAndNonNewBlock);
    }

    private static void runWithBothUnavailable(CheckChooseStorageTypes method) {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        for (int n = 0; n <= 3; ++n) {
            for (int d = 0; d <= n; ++d) {
                int a = n - d;
                List<StorageType> chosen = TestBlockStoragePolicy.asList(d, a);
                method.checkChooseStorageTypes(hot, (short)3, chosen, new StorageType[0]);
                method.checkChooseStorageTypes(warm, (short)3, chosen, new StorageType[0]);
                method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
            }
        }
    }

    @Test
    public void testChooseStorageTypesWithDiskUnavailableAndNewBlock() {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        EnumSet<StorageType> unavailables = disk;
        boolean isNewBlock = true;
        List<Object> chosen = Lists.newArrayList();
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, true, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, true, new StorageType[0]);
    }

    @Test
    public void testChooseStorageTypesWithArchiveUnavailable() {
        TestBlockStoragePolicy.runWithArchiveUnavailable(CheckChooseStorageTypes.ArchivalUnavailableAndNewBlock);
        TestBlockStoragePolicy.runWithArchiveUnavailable(CheckChooseStorageTypes.ArchivalUnavailableAndNonNewBlock);
    }

    private static void runWithArchiveUnavailable(CheckChooseStorageTypes method) {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        List<Object> chosen = Lists.newArrayList();
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(hot, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(warm, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, new StorageType[0]);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        method.checkChooseStorageTypes(hot, (short)3, chosen, StorageType.DISK, StorageType.DISK, StorageType.DISK);
        method.checkChooseStorageTypes(warm, (short)3, chosen, StorageType.DISK);
        method.checkChooseStorageTypes(cold, (short)3, chosen, new StorageType[0]);
    }

    @Test
    public void testChooseStorageTypesWithDiskUnavailableAndNonNewBlock() {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        EnumSet<StorageType> unavailables = disk;
        boolean isNewBlock = false;
        List<Object> chosen = Lists.newArrayList();
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.DISK);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, StorageType.ARCHIVE);
        chosen = Arrays.asList(StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE);
        TestBlockStoragePolicy.checkChooseStorageTypes(hot, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(warm, (short)3, chosen, unavailables, false, new StorageType[0]);
        TestBlockStoragePolicy.checkChooseStorageTypes(cold, (short)3, chosen, unavailables, false, new StorageType[0]);
    }

    static void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, EnumSet<StorageType> unavailables, boolean isNewBlock, StorageType ... expected) {
        List types = p.chooseStorageTypes(replication, chosen, unavailables, isNewBlock);
        TestBlockStoragePolicy.assertStorageTypes(types, expected);
    }

    static void assertStorageTypes(List<StorageType> computed, StorageType ... expected) {
        TestBlockStoragePolicy.assertStorageTypes(computed.toArray(StorageType.EMPTY_ARRAY), expected);
    }

    static void assertStorageTypes(StorageType[] computed, StorageType ... expected) {
        Arrays.sort(expected);
        Arrays.sort(computed);
        Assert.assertArrayEquals((Object[])expected, (Object[])computed);
    }

    @Test
    public void testChooseExcess() {
        BlockStoragePolicy hot = POLICY_SUITE.getPolicy((byte)7);
        BlockStoragePolicy warm = POLICY_SUITE.getPolicy((byte)5);
        BlockStoragePolicy cold = POLICY_SUITE.getPolicy((byte)2);
        int replication = 3;
        for (int n = 0; n <= 6; ++n) {
            int d = 0;
            while (d <= n) {
                int a = n - d;
                List<StorageType> chosen = TestBlockStoragePolicy.asList(d, a);
                int nDisk = Math.max(0, d - 3);
                int nArchive = a;
                StorageType[] expected = TestBlockStoragePolicy.newStorageTypes(nDisk, nArchive);
                TestBlockStoragePolicy.checkChooseExcess(hot, (short)3, chosen, expected);
                nDisk = Math.max(0, d - 1);
                nArchive = Math.max(0, a - 3 + 1);
                expected = TestBlockStoragePolicy.newStorageTypes(nDisk, nArchive);
                TestBlockStoragePolicy.checkChooseExcess(warm, (short)3, chosen, expected);
                nDisk = d++;
                nArchive = Math.max(0, a - 3);
                expected = TestBlockStoragePolicy.newStorageTypes(nDisk, nArchive);
                TestBlockStoragePolicy.checkChooseExcess(cold, (short)3, chosen, expected);
            }
        }
    }

    static void checkChooseExcess(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
        List types = p.chooseExcess(replication, chosen);
        TestBlockStoragePolicy.assertStorageTypes(types, expected);
    }

    private void checkDirectoryListing(HdfsFileStatus[] stats, byte ... policies) {
        Assert.assertEquals((long)stats.length, (long)policies.length);
        for (int i = 0; i < stats.length; ++i) {
            Assert.assertEquals((long)stats[i].getStoragePolicy(), (long)policies[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetStoragePolicy() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path dir = new Path("/testSetStoragePolicy");
            Path fooFile = new Path(dir, "foo");
            Path barDir = new Path(dir, "bar");
            Path barFile1 = new Path(barDir, "f1");
            Path barFile2 = new Path(barDir, "f2");
            DFSTestUtil.createFile((FileSystem)fs, fooFile, 1024L, (short)3, 0L);
            DFSTestUtil.createFile((FileSystem)fs, barFile1, 1024L, (short)3, 0L);
            DFSTestUtil.createFile((FileSystem)fs, barFile2, 1024L, (short)3, 0L);
            String invalidPolicyName = "INVALID-POLICY";
            try {
                fs.setStoragePolicy(fooFile, "INVALID-POLICY");
                Assert.fail((String)"Should throw a HadoopIllegalArgumentException");
            }
            catch (RemoteException e) {
                GenericTestUtils.assertExceptionContains((String)"INVALID-POLICY", (Throwable)e);
            }
            HdfsFileStatus[] dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            HdfsFileStatus[] barList = fs.getClient().listPaths(barDir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(dirList, 0, 0);
            this.checkDirectoryListing(barList, 0, 0);
            Path invalidPath = new Path("/invalidPath");
            try {
                fs.setStoragePolicy(invalidPath, "WARM");
                Assert.fail((String)"Should throw a FileNotFoundException");
            }
            catch (FileNotFoundException e) {
                GenericTestUtils.assertExceptionContains((String)invalidPath.toString(), (Throwable)e);
            }
            fs.setStoragePolicy(fooFile, "COLD");
            fs.setStoragePolicy(barDir, "WARM");
            fs.setStoragePolicy(barFile2, "HOT");
            dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            barList = fs.getClient().listPaths(barDir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            this.checkDirectoryListing(dirList, 5, 2);
            this.checkDirectoryListing(barList, 5, 7);
            cluster.restartNameNode(true);
            dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            barList = fs.getClient().listPaths(barDir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(dirList, 5, 2);
            this.checkDirectoryListing(barList, 5, 7);
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(true);
            dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            barList = fs.getClient().listPaths(barDir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            this.checkDirectoryListing(dirList, 5, 2);
            this.checkDirectoryListing(barList, 5, 7);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetStoragePolicyWithSnapshot() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path dir = new Path("/testSetStoragePolicyWithSnapshot");
            Path fooDir = new Path(dir, "foo");
            Path fooFile1 = new Path(fooDir, "f1");
            Path fooFile2 = new Path(fooDir, "f2");
            DFSTestUtil.createFile((FileSystem)fs, fooFile1, 1024L, (short)3, 0L);
            DFSTestUtil.createFile((FileSystem)fs, fooFile2, 1024L, (short)3, 0L);
            fs.setStoragePolicy(fooDir, "WARM");
            HdfsFileStatus[] dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(dirList, 5);
            HdfsFileStatus[] fooList = fs.getClient().listPaths(fooDir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(fooList, 5, 5);
            SnapshotTestHelper.createSnapshot(fs, dir, "s1");
            fs.setStoragePolicy(fooFile1, "COLD");
            fooList = fs.getClient().listPaths(fooDir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            this.checkDirectoryListing(fooList, 2, 5);
            Path s1f1 = SnapshotTestHelper.getSnapshotPath(dir, "s1", "foo/f1");
            DirectoryListing f1Listing = fs.getClient().listPaths(s1f1.toString(), HdfsFileStatus.EMPTY_NAME);
            this.checkDirectoryListing(f1Listing.getPartialListing(), 2);
            fs.delete(fooFile1, true);
            fooList = fs.getClient().listPaths(fooDir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            this.checkDirectoryListing(fooList, 5);
            this.checkDirectoryListing(fs.getClient().listPaths(s1f1.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing(), 2);
            fs.setStoragePolicy(fooDir, "HOT");
            dirList = fs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(dirList, 7);
            fooList = fs.getClient().listPaths(fooDir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            this.checkDirectoryListing(fooList, 7);
            Path s1 = SnapshotTestHelper.getSnapshotRoot(dir, "s1");
            Path s1foo = SnapshotTestHelper.getSnapshotPath(dir, "s1", "foo");
            this.checkDirectoryListing(fs.getClient().listPaths(s1.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing(), 7);
            this.checkDirectoryListing(fs.getClient().listPaths(s1foo.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing(), 2, 7);
            fs.delete(fooDir, true);
            this.checkDirectoryListing(fs.getClient().listPaths(s1.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing(), 7);
            this.checkDirectoryListing(fs.getClient().listPaths(s1foo.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing(), 2, 7);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static StorageType[][] genStorageTypes(int numDataNodes) {
        StorageType[][] types = new StorageType[numDataNodes][];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new StorageType[]{StorageType.DISK, StorageType.ARCHIVE};
        }
        return types;
    }

    private void checkLocatedBlocks(HdfsLocatedFileStatus status, int blockNum, int replicaNum, StorageType ... types) {
        ArrayList typeList = Lists.newArrayList();
        Collections.addAll(typeList, types);
        LocatedBlocks lbs = status.getBlockLocations();
        Assert.assertEquals((long)blockNum, (long)lbs.getLocatedBlocks().size());
        for (LocatedBlock lb : lbs.getLocatedBlocks()) {
            Assert.assertEquals((long)replicaNum, (long)lb.getStorageTypes().length);
            for (StorageType type : lb.getStorageTypes()) {
                Assert.assertTrue((boolean)typeList.remove(type));
            }
        }
        Assert.assertTrue((boolean)typeList.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChangeFileRep(String policyName, byte policyId, StorageType[] before, StorageType[] after) throws Exception {
        int numDataNodes = 5;
        StorageType[][] types = TestBlockStoragePolicy.genStorageTypes(5);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).storageTypes(types).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path dir = new Path("/test");
            fs.mkdirs(dir);
            fs.setStoragePolicy(dir, policyName);
            Path foo = new Path(dir, "foo");
            DFSTestUtil.createFile((FileSystem)fs, foo, 1024L, (short)3, 0L);
            HdfsFileStatus[] status = fs.getClient().listPaths(foo.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(status, policyId);
            HdfsLocatedFileStatus fooStatus = (HdfsLocatedFileStatus)status[0];
            this.checkLocatedBlocks(fooStatus, 1, 3, before);
            fs.setReplication(foo, (short)5);
            Thread.sleep(1000L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.triggerHeartbeat(dn);
            }
            Thread.sleep(1000L);
            status = fs.getClient().listPaths(foo.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(status, policyId);
            fooStatus = (HdfsLocatedFileStatus)status[0];
            this.checkLocatedBlocks(fooStatus, 1, 5, after);
            fs.setReplication(foo, (short)3);
            Thread.sleep(1000L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.triggerHeartbeat(dn);
            }
            Thread.sleep(1000L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.triggerBlockReport(dn);
            }
            Thread.sleep(1000L);
            status = fs.getClient().listPaths(foo.toString(), HdfsFileStatus.EMPTY_NAME, true).getPartialListing();
            this.checkDirectoryListing(status, policyId);
            fooStatus = (HdfsLocatedFileStatus)status[0];
            this.checkLocatedBlocks(fooStatus, 1, 3, before);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChangeHotFileRep() throws Exception {
        this.testChangeFileRep("HOT", (byte)7, new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.DISK});
    }

    @Test
    public void testChangeWarmRep() throws Exception {
        this.testChangeFileRep("WARM", (byte)5, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE}, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE});
    }

    @Test
    public void testChangeColdRep() throws Exception {
        this.testChangeFileRep("COLD", (byte)2, new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE});
    }

    @Test
    public void testChooseTargetWithTopology() throws Exception {
        BlockStoragePolicy policy1 = new BlockStoragePolicy(9, "TEST1", new StorageType[]{StorageType.SSD, StorageType.DISK, StorageType.ARCHIVE}, new StorageType[0], new StorageType[0]);
        BlockStoragePolicy policy2 = new BlockStoragePolicy(11, "TEST2", new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.ARCHIVE}, new StorageType[0], new StorageType[0]);
        String[] racks = new String[]{"/d1/r1", "/d1/r2", "/d1/r2"};
        String[] hosts = new String[]{"host1", "host2", "host3"};
        StorageType[] types = new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.ARCHIVE};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(3, racks, hosts, types);
        DatanodeDescriptor[] dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(TestReplicationPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        DFSTestUtil.formatNameNode(conf);
        NameNode namenode = new NameNode(conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        BlockPlacementPolicy replicator = bm.getBlockPlacementPolicy();
        NetworkTopology cluster = bm.getDatanodeManager().getNetworkTopology();
        for (DatanodeDescriptor datanode : dataNodes) {
            cluster.add((Node)datanode);
        }
        DatanodeStorageInfo[] targets = replicator.chooseTarget("/foo", 3, (Node)dataNodes[0], Collections.emptyList(), false, new HashSet(), 0L, policy1);
        System.out.println(Arrays.asList(targets));
        Assert.assertEquals((long)3L, (long)targets.length);
        targets = replicator.chooseTarget("/foo", 3, (Node)dataNodes[0], Collections.emptyList(), false, new HashSet(), 0L, policy2);
        System.out.println(Arrays.asList(targets));
        Assert.assertEquals((long)3L, (long)targets.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllStoragePolicies() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            BlockStoragePolicy[] policies = fs.getStoragePolicies();
            Assert.assertEquals((long)6L, (long)policies.length);
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)2).toString(), (Object)policies[0].toString());
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)5).toString(), (Object)policies[1].toString());
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)7).toString(), (Object)policies[2].toString());
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)10).toString(), (Object)policies[3].toString());
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)12).toString(), (Object)policies[4].toString());
            Assert.assertEquals((Object)POLICY_SUITE.getPolicy((byte)15).toString(), (Object)policies[5].toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }

    static {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.replication.interval", 1);
        POLICY_SUITE = BlockStoragePolicySuite.createDefaultSuite();
        DEFAULT_STORAGE_POLICY = POLICY_SUITE.getDefaultPolicy();
        none = EnumSet.noneOf(StorageType.class);
        archive = EnumSet.of(StorageType.ARCHIVE);
        disk = EnumSet.of(StorageType.DISK);
        both = EnumSet.of(StorageType.DISK, StorageType.ARCHIVE);
    }

    private static interface CheckChooseStorageTypes {
        public static final CheckChooseStorageTypes Basic = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes EmptyUnavailablesAndNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, none, true);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes EmptyUnavailablesAndNonNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, none, false);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes BothUnavailableAndNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, both, true);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes BothUnavailableAndNonNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, both, false);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes ArchivalUnavailableAndNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, archive, true);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };
        public static final CheckChooseStorageTypes ArchivalUnavailableAndNonNewBlock = new CheckChooseStorageTypes(){

            @Override
            public void checkChooseStorageTypes(BlockStoragePolicy p, short replication, List<StorageType> chosen, StorageType ... expected) {
                List types = p.chooseStorageTypes(replication, chosen, archive, false);
                TestBlockStoragePolicy.assertStorageTypes(types, expected);
            }
        };

        public void checkChooseStorageTypes(BlockStoragePolicy var1, short var2, List<StorageType> var3, StorageType ... var4);
    }
}

