/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAuditLogger {
    private static final short TEST_PERMISSION = 428;

    @Before
    public void setup() {
        DummyAuditLogger.initialized = false;
        DummyAuditLogger.logCount = 0;
        DummyAuditLogger.remoteAddr = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DummyAuditLogger.resetLogCount();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsAuditLogger() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            URI uri = new URI("http", NetUtils.getHostPortString((InetSocketAddress)cluster.getNameNode().getHttpAddress()), "/webhdfs/v1/", op.toQueryString(), null);
            HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"127.0.0.1", (Object)DummyAuditLogger.remoteAddr);
            conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setRequestProperty("X-Forwarded-For", "1.1.1.1");
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)2L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"127.0.0.1", (Object)DummyAuditLogger.remoteAddr);
            conf.set("hadoop.proxyservers", "127.0.0.1");
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setRequestProperty("X-Forwarded-For", "1.1.1.1");
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)3L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"1.1.1.1", (Object)DummyAuditLogger.remoteAddr);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLoggerWithSetPermission() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DummyAuditLogger.resetLogCount();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            Path p = new Path("/");
            fs.setTimes(p, time, time);
            fs.setPermission(p, new FsPermission(428));
            Assert.assertEquals((long)428L, (long)DummyAuditLogger.foundPermission);
            Assert.assertEquals((long)2L, (long)DummyAuditLogger.logCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokenLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", BrokenAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.fail((String)"Expected exception due to broken audit logger.");
        }
        catch (RemoteException remoteException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    public static class BrokenAuditLogger
    implements AuditLogger {
        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            throw new RuntimeException("uh oh");
        }
    }

    public static class DummyAuditLogger
    implements AuditLogger {
        static boolean initialized;
        static int logCount;
        static short foundPermission;
        static String remoteAddr;

        public void initialize(Configuration conf) {
            initialized = true;
        }

        public static void resetLogCount() {
            logCount = 0;
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            remoteAddr = addr.getHostAddress();
            ++logCount;
            if (stat != null) {
                foundPermission = stat.getPermission().toShort();
            }
        }
    }
}

