/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestJournalNodeMXBean {
    private static final String NAMESERVICE = "ns1";
    private static final int NUM_JN = 1;
    private MiniJournalCluster jCluster;
    private JournalNode jn;

    @Before
    public void setup() throws IOException {
        this.jCluster = new MiniJournalCluster.Builder(new Configuration()).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
    }

    @After
    public void cleanup() throws IOException {
        if (this.jCluster != null) {
            this.jCluster.shutdown();
        }
    }

    @Test
    public void testJournalNodeMXBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=JournalNode,name=JournalNodeInfo");
        String journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assert.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        Assert.assertFalse((boolean)journalStatus.contains(NAMESERVICE));
        NamespaceInfo FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
        this.jn.getOrCreateJournal(NAMESERVICE).format(FAKE_NSINFO);
        journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assert.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        HashMap jMap = new HashMap();
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("Formatted", "true");
        jMap.put(NAMESERVICE, infoMap);
        Assert.assertEquals((Object)JSON.toString(jMap), (Object)journalStatus);
        this.jCluster = new MiniJournalCluster.Builder(new Configuration()).format(false).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assert.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        jMap = new HashMap();
        infoMap = new HashMap();
        infoMap.put("Formatted", "true");
        jMap.put(NAMESERVICE, infoMap);
        Assert.assertEquals((Object)JSON.toString(jMap), (Object)journalStatus);
    }
}

