/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileAsTextInputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.LazyOutputFormat;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.streaming.Environment;
import org.apache.hadoop.streaming.JarBuilder;
import org.apache.hadoop.streaming.PipeCombiner;
import org.apache.hadoop.streaming.PipeMapRunner;
import org.apache.hadoop.streaming.PipeMapper;
import org.apache.hadoop.streaming.PipeReducer;
import org.apache.hadoop.streaming.StreamInputFormat;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.io.IdentifierResolver;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;

public class StreamJob
implements Tool {
    protected static final Log LOG = LogFactory.getLog((String)StreamJob.class.getName());
    static final String REDUCE_NONE = "NONE";
    private CommandLineParser parser = new BasicParser();
    private Options allOptions;
    protected String[] argv_;
    protected boolean background_;
    protected boolean verbose_;
    protected boolean detailedUsage_;
    protected boolean printUsage = false;
    protected int debug_;
    protected Environment env_;
    protected String jar_;
    protected boolean localHadoop_;
    protected Configuration config_;
    protected JobConf jobConf_;
    protected JobClient jc_;
    protected ArrayList<String> inputSpecs_ = new ArrayList();
    protected TreeSet<String> seenPrimary_ = new TreeSet();
    protected boolean hasSimpleInputSpecs_;
    protected ArrayList<String> packageFiles_ = new ArrayList();
    protected ArrayList<String> shippedCanonFiles_ = new ArrayList();
    protected String output_;
    protected String mapCmd_;
    protected String comCmd_;
    protected String redCmd_;
    protected String cacheFiles;
    protected String cacheArchives;
    protected URI[] fileURIs;
    protected URI[] archiveURIs;
    protected String inReaderSpec_;
    protected String inputFormatSpec_;
    protected String outputFormatSpec_;
    protected String partitionerSpec_;
    protected String numReduceTasksSpec_;
    protected String additionalConfSpec_;
    protected String mapDebugSpec_;
    protected String reduceDebugSpec_;
    protected String ioSpec_;
    protected boolean lazyOutput_;
    protected String addTaskEnvironment_;
    protected boolean outputSingleNode_;
    protected long minRecWrittenToEnableSkip_;
    protected RunningJob running_;
    protected JobID jobId_;
    protected static final String LINK_URI = "You need to specify the uris as scheme://path#linkname,Please specify a different link name for all of your caching URIs";

    @Deprecated
    public StreamJob(String[] argv, boolean mayExit) {
        this();
        this.argv_ = Arrays.copyOf(argv, argv.length);
        this.config_ = new Configuration();
    }

    public StreamJob() {
        this.setupOptions();
        this.config_ = new Configuration();
    }

    public Configuration getConf() {
        return this.config_;
    }

    public void setConf(Configuration conf) {
        this.config_ = conf;
    }

    public int run(String[] args) throws Exception {
        try {
            this.argv_ = Arrays.copyOf(args, args.length);
            this.init();
            this.preProcessArgs();
            this.parseArgv();
            if (this.printUsage) {
                this.printUsage(this.detailedUsage_);
                return 0;
            }
            this.postProcessArgs();
            this.setJobConf();
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Object)"Error in streaming job", (Throwable)ex);
            return 1;
        }
        return this.submitAndMonitorJob();
    }

    public static JobConf createJob(String[] argv) throws IOException {
        StreamJob job = new StreamJob();
        job.argv_ = argv;
        job.init();
        job.preProcessArgs();
        job.parseArgv();
        job.postProcessArgs();
        job.setJobConf();
        return job.jobConf_;
    }

    @Deprecated
    public int go() throws IOException {
        try {
            return this.run(this.argv_);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void init() {
        try {
            this.env_ = new Environment();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    void preProcessArgs() {
        this.verbose_ = false;
        this.addTaskEnvironment_ = "HADOOP_ROOT_LOGGER=";
    }

    void postProcessArgs() throws IOException {
        if (this.inputSpecs_.size() == 0) {
            this.fail("Required argument: -input <name>");
        }
        if (this.output_ == null) {
            this.fail("Required argument: -output ");
        }
        this.msg("addTaskEnvironment=" + this.addTaskEnvironment_);
        for (String packageFile : this.packageFiles_) {
            File f = new File(packageFile);
            if (!f.isFile()) continue;
            this.shippedCanonFiles_.add(f.getCanonicalPath());
        }
        this.msg("shippedCanonFiles_=" + this.shippedCanonFiles_);
        this.mapCmd_ = this.unqualifyIfLocalPath(this.mapCmd_);
        this.comCmd_ = this.unqualifyIfLocalPath(this.comCmd_);
        this.redCmd_ = this.unqualifyIfLocalPath(this.redCmd_);
    }

    String unqualifyIfLocalPath(String cmd) throws IOException {
        if (cmd != null) {
            String progCanon;
            String prog = cmd;
            String args = "";
            int s = cmd.indexOf(" ");
            if (s != -1) {
                prog = cmd.substring(0, s);
                args = cmd.substring(s + 1);
            }
            try {
                progCanon = new File(prog).getCanonicalPath();
            }
            catch (IOException io) {
                progCanon = prog;
            }
            boolean shipped = this.shippedCanonFiles_.contains(progCanon);
            this.msg("shipped: " + shipped + " " + progCanon);
            if (shipped) {
                prog = new File(prog).getName();
                cmd = args.length() > 0 ? prog + " " + args : prog;
            }
        }
        this.msg("cmd=" + cmd);
        return cmd;
    }

    void parseArgv() {
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parser.parse(this.allOptions, this.argv_);
        }
        catch (Exception oe) {
            LOG.error((Object)oe.getMessage());
            this.exitUsage(this.argv_.length > 0 && "-info".equals(this.argv_[0]));
        }
        if (cmdLine != null) {
            String[] cmd;
            String[] jobconf;
            String[] caf;
            String fsName;
            List args = cmdLine.getArgList();
            if (args != null && args.size() > 0) {
                this.fail("Found " + args.size() + " unexpected arguments on the " + "command line " + args);
            }
            this.detailedUsage_ = cmdLine.hasOption("info");
            if (cmdLine.hasOption("help") || this.detailedUsage_) {
                this.printUsage = true;
                return;
            }
            this.verbose_ = cmdLine.hasOption("verbose");
            this.background_ = cmdLine.hasOption("background");
            this.debug_ = cmdLine.hasOption("debug") ? this.debug_ + 1 : this.debug_;
            String[] values = cmdLine.getOptionValues("input");
            if (values != null && values.length > 0) {
                for (String input : values) {
                    this.inputSpecs_.add(input);
                }
            }
            this.output_ = cmdLine.getOptionValue("output");
            this.mapCmd_ = cmdLine.getOptionValue("mapper");
            this.comCmd_ = cmdLine.getOptionValue("combiner");
            this.redCmd_ = cmdLine.getOptionValue("reducer");
            this.lazyOutput_ = cmdLine.hasOption("lazyOutput");
            values = cmdLine.getOptionValues("file");
            if (values != null && values.length > 0) {
                LOG.warn((Object)"-file option is deprecated, please use generic option -files instead.");
                StringBuffer fileList = new StringBuffer();
                for (String file : values) {
                    this.packageFiles_.add(file);
                    try {
                        Path path = new Path(file);
                        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.config_);
                        String finalPath = path.makeQualified((FileSystem)localFs).toString();
                        if (fileList.length() > 0) {
                            fileList.append(',');
                        }
                        fileList.append(finalPath);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                String tmpFiles = this.config_.get("tmpfiles", "");
                tmpFiles = tmpFiles.isEmpty() ? fileList.toString() : tmpFiles + "," + fileList;
                this.config_.set("tmpfiles", tmpFiles);
                this.validate(this.packageFiles_);
            }
            if (null != (fsName = cmdLine.getOptionValue("dfs"))) {
                LOG.warn((Object)"-dfs option is deprecated, please use -fs instead.");
                this.config_.set("fs.default.name", fsName);
            }
            this.additionalConfSpec_ = cmdLine.getOptionValue("additionalconfspec");
            this.inputFormatSpec_ = cmdLine.getOptionValue("inputformat");
            this.outputFormatSpec_ = cmdLine.getOptionValue("outputformat");
            this.numReduceTasksSpec_ = cmdLine.getOptionValue("numReduceTasks");
            this.partitionerSpec_ = cmdLine.getOptionValue("partitioner");
            this.inReaderSpec_ = cmdLine.getOptionValue("inputreader");
            this.mapDebugSpec_ = cmdLine.getOptionValue("mapdebug");
            this.reduceDebugSpec_ = cmdLine.getOptionValue("reducedebug");
            this.ioSpec_ = cmdLine.getOptionValue("io");
            String[] car = cmdLine.getOptionValues("cacheArchive");
            if (null != car && car.length > 0) {
                LOG.warn((Object)"-cacheArchive option is deprecated, please use -archives instead.");
                for (String s : car) {
                    this.cacheArchives = this.cacheArchives == null ? s : this.cacheArchives + "," + s;
                }
            }
            if (null != (caf = cmdLine.getOptionValues("cacheFile")) && caf.length > 0) {
                LOG.warn((Object)"-cacheFile option is deprecated, please use -files instead.");
                for (String s : caf) {
                    this.cacheFiles = this.cacheFiles == null ? s : this.cacheFiles + "," + s;
                }
            }
            if (null != (jobconf = cmdLine.getOptionValues("jobconf")) && jobconf.length > 0) {
                LOG.warn((Object)"-jobconf option is deprecated, please use -D instead.");
                for (String s : jobconf) {
                    String[] parts = s.split("=", 2);
                    this.config_.set(parts[0], parts[1]);
                }
            }
            if (null != (cmd = cmdLine.getOptionValues("cmdenv")) && cmd.length > 0) {
                for (String s : cmd) {
                    if (this.addTaskEnvironment_.length() > 0) {
                        this.addTaskEnvironment_ = this.addTaskEnvironment_ + " ";
                    }
                    this.addTaskEnvironment_ = this.addTaskEnvironment_ + s;
                }
            }
        } else {
            this.exitUsage(this.argv_.length > 0 && "-info".equals(this.argv_[0]));
        }
    }

    protected void msg(String msg) {
        if (this.verbose_) {
            System.out.println("STREAM: " + msg);
        }
    }

    private Option createOption(String name, String desc, String argName, int max, boolean required) {
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArgs((int)max);
        OptionBuilder.withDescription((String)desc);
        OptionBuilder.isRequired((boolean)required);
        return OptionBuilder.create((String)name);
    }

    private Option createBoolOption(String name, String desc) {
        OptionBuilder.withDescription((String)desc);
        return OptionBuilder.create((String)name);
    }

    private void validate(List<String> values) throws IllegalArgumentException {
        for (String file : values) {
            File f = new File(file);
            if (FileUtil.canRead((File)f)) continue;
            this.fail("File: " + f.getAbsolutePath() + " does not exist, or is not readable.");
        }
    }

    private void setupOptions() {
        Option input = this.createOption("input", "DFS input file(s) for the Map step", "path", Integer.MAX_VALUE, false);
        Option output = this.createOption("output", "DFS output directory for the Reduce step", "path", 1, false);
        Option mapper = this.createOption("mapper", "The streaming command to run", "cmd", 1, false);
        Option combiner = this.createOption("combiner", "The streaming command to run", "cmd", 1, false);
        Option reducer = this.createOption("reducer", "The streaming command to run", "cmd", 1, false);
        Option file = this.createOption("file", "File to be shipped in the Job jar file", "file", Integer.MAX_VALUE, false);
        Option dfs = this.createOption("dfs", "Optional. Override DFS configuration", "<h:p>|local", 1, false);
        Option additionalconfspec = this.createOption("additionalconfspec", "Optional.", "spec", 1, false);
        Option inputformat = this.createOption("inputformat", "Optional.", "spec", 1, false);
        Option outputformat = this.createOption("outputformat", "Optional.", "spec", 1, false);
        Option partitioner = this.createOption("partitioner", "Optional.", "spec", 1, false);
        Option numReduceTasks = this.createOption("numReduceTasks", "Optional.", "spec", 1, false);
        Option inputreader = this.createOption("inputreader", "Optional.", "spec", 1, false);
        Option mapDebug = this.createOption("mapdebug", "Optional.", "spec", 1, false);
        Option reduceDebug = this.createOption("reducedebug", "Optional", "spec", 1, false);
        Option jobconf = this.createOption("jobconf", "(n=v) Optional. Add or override a JobConf property.", "spec", 1, false);
        Option cmdenv = this.createOption("cmdenv", "(n=v) Pass env.var to streaming commands.", "spec", 1, false);
        Option cacheFile = this.createOption("cacheFile", "File name URI", "fileNameURI", Integer.MAX_VALUE, false);
        Option cacheArchive = this.createOption("cacheArchive", "File name URI", "fileNameURI", Integer.MAX_VALUE, false);
        Option io = this.createOption("io", "Optional.", "spec", 1, false);
        Option background = this.createBoolOption("background", "Submit the job and don't wait till it completes.");
        Option verbose = this.createBoolOption("verbose", "print verbose output");
        Option info = this.createBoolOption("info", "print verbose output");
        Option help = this.createBoolOption("help", "print this help message");
        Option debug = this.createBoolOption("debug", "print debug output");
        Option lazyOutput = this.createBoolOption("lazyOutput", "create outputs lazily");
        this.allOptions = new Options().addOption(input).addOption(output).addOption(mapper).addOption(combiner).addOption(reducer).addOption(file).addOption(dfs).addOption(additionalconfspec).addOption(inputformat).addOption(outputformat).addOption(partitioner).addOption(numReduceTasks).addOption(inputreader).addOption(mapDebug).addOption(reduceDebug).addOption(jobconf).addOption(cmdenv).addOption(cacheFile).addOption(cacheArchive).addOption(io).addOption(background).addOption(verbose).addOption(info).addOption(debug).addOption(help).addOption(lazyOutput);
    }

    public void exitUsage(boolean detailed) {
        this.printUsage(detailed);
        this.fail("");
    }

    private void printUsage(boolean detailed) {
        System.out.println("Usage: $HADOOP_PREFIX/bin/hadoop jar hadoop-streaming.jar [options]");
        System.out.println("Options:");
        System.out.println("  -input          <path> DFS input file(s) for the Map step.");
        System.out.println("  -output         <path> DFS output directory for the Reduce step.");
        System.out.println("  -mapper         <cmd|JavaClassName> Optional. Command to be run as mapper.");
        System.out.println("  -combiner       <cmd|JavaClassName> Optional. Command to be run as combiner.");
        System.out.println("  -reducer        <cmd|JavaClassName> Optional. Command to be run as reducer.");
        System.out.println("  -file           <file> Optional. File/dir to be shipped in the Job jar file.\n                  Deprecated. Use generic option \"-files\" instead.");
        System.out.println("  -inputformat    <TextInputFormat(default)|SequenceFileAsTextInputFormat|JavaClassName>\n                  Optional. The input format class.");
        System.out.println("  -outputformat   <TextOutputFormat(default)|JavaClassName>\n                  Optional. The output format class.");
        System.out.println("  -partitioner    <JavaClassName>  Optional. The partitioner class.");
        System.out.println("  -numReduceTasks <num> Optional. Number of reduce tasks.");
        System.out.println("  -inputreader    <spec> Optional. Input recordreader spec.");
        System.out.println("  -cmdenv         <n>=<v> Optional. Pass env.var to streaming commands.");
        System.out.println("  -mapdebug       <cmd> Optional. To run this script when a map task fails.");
        System.out.println("  -reducedebug    <cmd> Optional. To run this script when a reduce task fails.");
        System.out.println("  -io             <identifier> Optional. Format to use for input to and output");
        System.out.println("                  from mapper/reducer commands");
        System.out.println("  -lazyOutput     Optional. Lazily create Output.");
        System.out.println("  -background     Optional. Submit the job and don't wait till it completes.");
        System.out.println("  -verbose        Optional. Print verbose output.");
        System.out.println("  -info           Optional. Print detailed usage.");
        System.out.println("  -help           Optional. Print help message.");
        System.out.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.out);
        if (!detailed) {
            System.out.println();
            System.out.println("For more details about these options:");
            System.out.println("Use $HADOOP_PREFIX/bin/hadoop jar hadoop-streaming.jar -info");
            return;
        }
        System.out.println();
        System.out.println("Usage tips:");
        System.out.println("In -input: globbing on <path> is supported and can have multiple -input");
        System.out.println();
        System.out.println("Default Map input format: a line is a record in UTF-8 the key part ends at first");
        System.out.println("  TAB, the rest of the line is the value");
        System.out.println();
        System.out.println("To pass a Custom input format:");
        System.out.println("  -inputformat package.MyInputFormat");
        System.out.println();
        System.out.println("Similarly, to pass a custom output format:");
        System.out.println("  -outputformat package.MyOutputFormat");
        System.out.println();
        System.out.println("The files with extensions .class and .jar/.zip, specified for the -file");
        System.out.println("  argument[s], end up in \"classes\" and \"lib\" directories respectively inside");
        System.out.println("  the working directory when the mapper and reducer are run. All other files");
        System.out.println("  specified for the -file argument[s] end up in the working directory when the");
        System.out.println("  mapper and reducer are run. The location of this working directory is");
        System.out.println("  unspecified.");
        System.out.println();
        System.out.println("To set the number of reduce tasks (num. of output files) as, say 10:");
        System.out.println("  Use -numReduceTasks 10");
        System.out.println("To skip the sort/combine/shuffle/sort/reduce step:");
        System.out.println("  Use -numReduceTasks 0");
        System.out.println("  Map output then becomes a 'side-effect output' rather than a reduce input.");
        System.out.println("  This speeds up processing. This also feels more like \"in-place\" processing");
        System.out.println("  because the input filename and the map input order are preserved.");
        System.out.println("  This is equivalent to -reducer NONE");
        System.out.println();
        System.out.println("To speed up the last maps:");
        System.out.println("  -D mapreduce.map.speculative=true");
        System.out.println("To speed up the last reduces:");
        System.out.println("  -D mapreduce.reduce.speculative=true");
        System.out.println("To name the job (appears in the JobTracker Web UI):");
        System.out.println("  -D mapreduce.job.name='My Job'");
        System.out.println("To change the local temp directory:");
        System.out.println("  -D dfs.data.dir=/tmp/dfs");
        System.out.println("  -D stream.tmpdir=/tmp/streaming");
        System.out.println("Additional local temp directories with -jt local:");
        System.out.println("  -D mapreduce.cluster.local.dir=/tmp/local");
        System.out.println("  -D mapreduce.jobtracker.system.dir=/tmp/system");
        System.out.println("  -D mapreduce.cluster.temp.dir=/tmp/temp");
        System.out.println("To treat tasks with non-zero exit status as SUCCEDED:");
        System.out.println("  -D stream.non.zero.exit.is.failure=false");
        System.out.println("Use a custom hadoop streaming build along with standard hadoop install:");
        System.out.println("  $HADOOP_PREFIX/bin/hadoop jar /path/my-hadoop-streaming.jar [...]\\");
        System.out.println("    [...] -D stream.shipped.hadoopstreaming=/path/my-hadoop-streaming.jar");
        System.out.println("For more details about jobconf parameters see:");
        System.out.println("  http://wiki.apache.org/hadoop/JobConfFile");
        System.out.println("To set an environement variable in a streaming command:");
        System.out.println("   -cmdenv EXAMPLE_DIR=/home/example/dictionaries/");
        System.out.println();
        System.out.println("Shortcut:");
        System.out.println("   setenv HSTREAMING \"$HADOOP_PREFIX/bin/hadoop jar hadoop-streaming.jar\"");
        System.out.println();
        System.out.println("Example: $HSTREAMING -mapper \"/usr/local/bin/perl5 filter.pl\"");
        System.out.println("           -file /local/filter.pl -input \"/logs/0604*/*\" [...]");
        System.out.println("  Ships a script, invokes the non-shipped perl interpreter. Shipped files go to");
        System.out.println("  the working directory so filter.pl is found by perl. Input files are all the");
        System.out.println("  daily logs for days in month 2006-04");
    }

    public void fail(String message) {
        System.err.println(message);
        System.err.println("Try -help for more information");
        throw new IllegalArgumentException(message);
    }

    protected String getHadoopClientHome() {
        String h = this.env_.getProperty("HADOOP_PREFIX");
        if (h == null) {
            h = "UNDEF";
        }
        return h;
    }

    protected boolean isLocalHadoop() {
        return StreamUtil.isLocalJobTracker(this.jobConf_);
    }

    @Deprecated
    protected String getClusterNick() {
        return "default";
    }

    protected String packageJobJar() throws IOException {
        ArrayList<String> unjarFiles = new ArrayList<String>();
        String runtimeClasses = this.config_.get("stream.shipped.hadoopstreaming");
        if (runtimeClasses == null) {
            runtimeClasses = StreamUtil.findInClasspath(StreamJob.class.getName());
        }
        if (runtimeClasses == null) {
            throw new IOException("runtime classes not found: " + this.getClass().getPackage());
        }
        this.msg("Found runtime classes in: " + runtimeClasses);
        if (!this.isLocalHadoop()) {
            if (new File(runtimeClasses).isDirectory()) {
                this.packageFiles_.add(runtimeClasses);
            } else {
                unjarFiles.add(runtimeClasses);
            }
        }
        if (this.packageFiles_.size() + unjarFiles.size() == 0) {
            return null;
        }
        String tmp = this.jobConf_.get("stream.tmpdir");
        File tmpDir = tmp == null ? null : new File(tmp);
        File jobJar = File.createTempFile("streamjob", ".jar", tmpDir);
        System.out.println("packageJobJar: " + this.packageFiles_ + " " + unjarFiles + " " + jobJar + " tmpDir=" + tmpDir);
        if (this.debug_ == 0) {
            jobJar.deleteOnExit();
        }
        JarBuilder builder = new JarBuilder();
        if (this.verbose_) {
            builder.setVerbose(true);
        }
        String jobJarName = jobJar.getAbsolutePath();
        builder.merge(this.packageFiles_, unjarFiles, jobJarName);
        return jobJarName;
    }

    protected void getURIs(String lcacheArchives, String lcacheFiles) {
        String[] archives = StringUtils.getStrings((String)lcacheArchives);
        String[] files = StringUtils.getStrings((String)lcacheFiles);
        this.fileURIs = StringUtils.stringToURI((String[])files);
        this.archiveURIs = StringUtils.stringToURI((String[])archives);
    }

    protected void setJobConf() throws IOException {
        Class c;
        if (this.additionalConfSpec_ != null) {
            LOG.warn((Object)"-additionalconfspec option is deprecated, please use -conf instead.");
            this.config_.addResource(new Path(this.additionalConfSpec_));
        }
        this.jobConf_ = new JobConf(this.config_, StreamJob.class);
        for (int i = 0; i < this.inputSpecs_.size(); ++i) {
            FileInputFormat.addInputPaths((JobConf)this.jobConf_, (String)this.inputSpecs_.get(i));
        }
        String defaultPackage = this.getClass().getPackage().getName();
        Class fmt = null;
        if (this.inReaderSpec_ == null && this.inputFormatSpec_ == null) {
            fmt = TextInputFormat.class;
        } else if (this.inputFormatSpec_ != null) {
            if (this.inputFormatSpec_.equals(TextInputFormat.class.getName()) || this.inputFormatSpec_.equals(TextInputFormat.class.getCanonicalName()) || this.inputFormatSpec_.equals(TextInputFormat.class.getSimpleName())) {
                fmt = TextInputFormat.class;
            } else if (this.inputFormatSpec_.equals(KeyValueTextInputFormat.class.getName()) || this.inputFormatSpec_.equals(KeyValueTextInputFormat.class.getCanonicalName()) || this.inputFormatSpec_.equals(KeyValueTextInputFormat.class.getSimpleName())) {
                if (this.inReaderSpec_ == null) {
                    fmt = KeyValueTextInputFormat.class;
                }
            } else if (this.inputFormatSpec_.equals(SequenceFileInputFormat.class.getName()) || this.inputFormatSpec_.equals(SequenceFileInputFormat.class.getCanonicalName()) || this.inputFormatSpec_.equals(SequenceFileInputFormat.class.getSimpleName())) {
                if (this.inReaderSpec_ == null) {
                    fmt = SequenceFileInputFormat.class;
                }
            } else if (this.inputFormatSpec_.equals(SequenceFileAsTextInputFormat.class.getName()) || this.inputFormatSpec_.equals(SequenceFileAsTextInputFormat.class.getCanonicalName()) || this.inputFormatSpec_.equals(SequenceFileAsTextInputFormat.class.getSimpleName())) {
                fmt = SequenceFileAsTextInputFormat.class;
            } else {
                c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.inputFormatSpec_, defaultPackage);
                if (c != null) {
                    fmt = c;
                } else {
                    this.fail("-inputformat : class not found : " + this.inputFormatSpec_);
                }
            }
        }
        if (fmt == null) {
            fmt = StreamInputFormat.class;
        }
        this.jobConf_.setInputFormat(fmt);
        if (this.ioSpec_ != null) {
            this.jobConf_.set("stream.map.input", this.ioSpec_);
            this.jobConf_.set("stream.map.output", this.ioSpec_);
            this.jobConf_.set("stream.reduce.input", this.ioSpec_);
            this.jobConf_.set("stream.reduce.output", this.ioSpec_);
        }
        Class idResolverClass = this.jobConf_.getClass("stream.io.identifier.resolver.class", IdentifierResolver.class, IdentifierResolver.class);
        IdentifierResolver idResolver = (IdentifierResolver)ReflectionUtils.newInstance((Class)idResolverClass, (Configuration)this.jobConf_);
        idResolver.resolve(this.jobConf_.get("stream.map.input", "text"));
        this.jobConf_.setClass("stream.map.input.writer.class", idResolver.getInputWriterClass(), InputWriter.class);
        idResolver.resolve(this.jobConf_.get("stream.reduce.input", "text"));
        this.jobConf_.setClass("stream.reduce.input.writer.class", idResolver.getInputWriterClass(), InputWriter.class);
        this.jobConf_.set("stream.addenvironment", this.addTaskEnvironment_);
        boolean isMapperACommand = false;
        if (this.mapCmd_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.mapCmd_, defaultPackage);
            if (c != null) {
                this.jobConf_.setMapperClass(c);
            } else {
                isMapperACommand = true;
                this.jobConf_.setMapperClass(PipeMapper.class);
                this.jobConf_.setMapRunnerClass(PipeMapRunner.class);
                this.jobConf_.set("stream.map.streamprocessor", URLEncoder.encode(this.mapCmd_, "UTF-8"));
            }
        }
        if (this.comCmd_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.comCmd_, defaultPackage);
            if (c != null) {
                this.jobConf_.setCombinerClass(c);
            } else {
                this.jobConf_.setCombinerClass(PipeCombiner.class);
                this.jobConf_.set("stream.combine.streamprocessor", URLEncoder.encode(this.comCmd_, "UTF-8"));
            }
        }
        if (this.numReduceTasksSpec_ != null) {
            int numReduceTasks = Integer.parseInt(this.numReduceTasksSpec_);
            this.jobConf_.setNumReduceTasks(numReduceTasks);
        }
        boolean isReducerACommand = false;
        if (this.redCmd_ != null) {
            if (this.redCmd_.equals(REDUCE_NONE)) {
                this.jobConf_.setNumReduceTasks(0);
            }
            if (this.jobConf_.getNumReduceTasks() != 0) {
                if (this.redCmd_.compareToIgnoreCase("aggregate") == 0) {
                    this.jobConf_.setReducerClass(ValueAggregatorReducer.class);
                    this.jobConf_.setCombinerClass(ValueAggregatorCombiner.class);
                } else {
                    c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.redCmd_, defaultPackage);
                    if (c != null) {
                        this.jobConf_.setReducerClass(c);
                    } else {
                        isReducerACommand = true;
                        this.jobConf_.setReducerClass(PipeReducer.class);
                        this.jobConf_.set("stream.reduce.streamprocessor", URLEncoder.encode(this.redCmd_, "UTF-8"));
                    }
                }
            }
        }
        idResolver.resolve(this.jobConf_.get("stream.map.output", "text"));
        this.jobConf_.setClass("stream.map.output.reader.class", idResolver.getOutputReaderClass(), OutputReader.class);
        if (isMapperACommand || this.jobConf_.get("stream.map.output") != null) {
            this.jobConf_.setMapOutputKeyClass(idResolver.getOutputKeyClass());
            this.jobConf_.setMapOutputValueClass(idResolver.getOutputValueClass());
            if (this.jobConf_.getNumReduceTasks() == 0) {
                this.jobConf_.setOutputKeyClass(idResolver.getOutputKeyClass());
                this.jobConf_.setOutputValueClass(idResolver.getOutputValueClass());
            }
        }
        idResolver.resolve(this.jobConf_.get("stream.reduce.output", "text"));
        this.jobConf_.setClass("stream.reduce.output.reader.class", idResolver.getOutputReaderClass(), OutputReader.class);
        if (isReducerACommand || this.jobConf_.get("stream.reduce.output") != null) {
            this.jobConf_.setOutputKeyClass(idResolver.getOutputKeyClass());
            this.jobConf_.setOutputValueClass(idResolver.getOutputValueClass());
        }
        if (this.inReaderSpec_ != null) {
            String[] args = this.inReaderSpec_.split(",");
            String readerClass = args[0];
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, readerClass, defaultPackage);
            if (c != null) {
                this.jobConf_.set("stream.recordreader.class", c.getName());
            } else {
                this.fail("-inputreader: class not found: " + readerClass);
            }
            for (int i = 1; i < args.length; ++i) {
                String[] nv = args[i].split("=", 2);
                String k = "stream.recordreader." + nv[0];
                String v = nv.length > 1 ? nv[1] : "";
                this.jobConf_.set(k, v);
            }
        }
        FileOutputFormat.setOutputPath((JobConf)this.jobConf_, (Path)new Path(this.output_));
        fmt = null;
        if (this.outputFormatSpec_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.outputFormatSpec_, defaultPackage);
            if (c != null) {
                fmt = c;
            } else {
                this.fail("-outputformat : class not found : " + this.outputFormatSpec_);
            }
        }
        if (fmt == null) {
            fmt = TextOutputFormat.class;
        }
        if (this.lazyOutput_) {
            LazyOutputFormat.setOutputFormatClass((JobConf)this.jobConf_, (Class)fmt);
        } else {
            this.jobConf_.setOutputFormat(fmt);
        }
        if (this.partitionerSpec_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.partitionerSpec_, defaultPackage);
            if (c != null) {
                this.jobConf_.setPartitionerClass(c);
            } else {
                this.fail("-partitioner : class not found : " + this.partitionerSpec_);
            }
        }
        if (this.mapDebugSpec_ != null) {
            this.jobConf_.setMapDebugScript(this.mapDebugSpec_);
        }
        if (this.reduceDebugSpec_ != null) {
            this.jobConf_.setReduceDebugScript(this.reduceDebugSpec_);
        }
        this.jar_ = this.packageJobJar();
        if (this.jar_ != null) {
            this.jobConf_.setJar(this.jar_);
        }
        if (this.cacheArchives != null || this.cacheFiles != null) {
            this.getURIs(this.cacheArchives, this.cacheFiles);
            boolean b = DistributedCache.checkURIs((URI[])this.fileURIs, (URI[])this.archiveURIs);
            if (!b) {
                this.fail(LINK_URI);
            }
        }
        if (this.cacheArchives != null) {
            DistributedCache.setCacheArchives((URI[])this.archiveURIs, (Configuration)this.jobConf_);
        }
        if (this.cacheFiles != null) {
            DistributedCache.setCacheFiles((URI[])this.fileURIs, (Configuration)this.jobConf_);
        }
        if (this.verbose_) {
            this.listJobConfProperties();
        }
        this.msg("submitting to jobconf: " + this.getJobTrackerHostPort());
    }

    protected void listJobConfProperties() {
        this.msg("==== JobConf properties:");
        TreeMap sorted = new TreeMap();
        for (Map.Entry en : this.jobConf_) {
            sorted.put(en.getKey(), en.getValue());
        }
        for (Map.Entry en : sorted.entrySet()) {
            this.msg((String)en.getKey() + "=" + (String)en.getValue());
        }
        this.msg("====");
    }

    protected String getJobTrackerHostPort() {
        return this.jobConf_.get("mapreduce.jobtracker.address");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitAndMonitorJob() throws IOException {
        if (this.jar_ != null && this.isLocalHadoop()) {
            File wd = new File(".").getAbsoluteFile();
            RunJar.unJar((File)new File(this.jar_), (File)wd);
        }
        this.jc_ = new JobClient(this.jobConf_);
        this.running_ = null;
        try {
            this.running_ = this.jc_.submitJob(this.jobConf_);
            this.jobId_ = this.running_.getID();
            if (this.background_) {
                LOG.info((Object)"Job is running in background.");
            } else if (!this.jc_.monitorAndPrintJob(this.jobConf_, this.running_)) {
                LOG.error((Object)"Job not Successful!");
                int wd = 1;
                return wd;
            }
            LOG.info((Object)("Output directory: " + this.output_));
        }
        catch (FileNotFoundException fe) {
            LOG.error((Object)("Error launching job , bad input path : " + fe.getMessage()));
            int n = 2;
            return n;
        }
        catch (InvalidJobConfException je) {
            LOG.error((Object)("Error launching job , Invalid job conf : " + je.getMessage()));
            int n = 3;
            return n;
        }
        catch (FileAlreadyExistsException fae) {
            LOG.error((Object)("Error launching job , Output path already exists : " + fae.getMessage()));
            int n = 4;
            return n;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error Launching job : " + ioe.getMessage()));
            int n = 5;
            return n;
        }
        catch (InterruptedException ie) {
            LOG.error((Object)("Error monitoring job : " + ie.getMessage()));
            int n = 6;
            return n;
        }
        finally {
            this.jc_.close();
        }
        return 0;
    }
}

