/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MetricsSourceAdapter;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricsSourceBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsSourceAdapter {
    @Test
    public void testGetMetricsAndJmx() throws Exception {
        TestSource source = new TestSource("test");
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)source);
        MetricsSource s = sb.build();
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sa = new MetricsSourceAdapter("test", "test", "test desc", s, injectedTags, null, null, 1, false);
        MetricsCollectorImpl builder = new MetricsCollectorImpl();
        Iterable metricsRecords = sa.getMetrics(builder, true);
        MetricsRecordImpl metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertEquals((long)0L, (long)((AbstractMetric)metricsRecord.metrics().iterator().next()).value().longValue());
        Thread.sleep(100L);
        Assert.assertEquals((Object)0L, (Object)((Number)sa.getAttribute("C1")));
        source.incrementCnt();
        builder = new MetricsCollectorImpl();
        metricsRecords = sa.getMetrics(builder, true);
        metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertTrue((boolean)metricsRecord.metrics().iterator().hasNext());
        Thread.sleep(100L);
        Assert.assertEquals((Object)1L, (Object)((Number)sa.getAttribute("C1")));
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }

        public void incrementCnt() {
            this.c1.incr();
        }
    }
}

