/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.recovery;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class NMLeveldbStateStoreService
extends NMStateStoreService {
    public static final Log LOG = LogFactory.getLog(NMLeveldbStateStoreService.class);
    private static final String DB_NAME = "yarn-nm-state";
    private static final String DB_SCHEMA_VERSION_KEY = "schema-version";
    private static final String DB_SCHEMA_VERSION = "1.0";
    private static final String DELETION_TASK_KEY_PREFIX = "DeletionService/deltask_";
    private static final String LOCALIZATION_KEY_PREFIX = "Localization/";
    private static final String LOCALIZATION_PUBLIC_KEY_PREFIX = "Localization/public/";
    private static final String LOCALIZATION_PRIVATE_KEY_PREFIX = "Localization/private/";
    private static final String LOCALIZATION_STARTED_SUFFIX = "started/";
    private static final String LOCALIZATION_COMPLETED_SUFFIX = "completed/";
    private static final String LOCALIZATION_FILECACHE_SUFFIX = "filecache/";
    private static final String LOCALIZATION_APPCACHE_SUFFIX = "appcache/";
    private DB db;

    public NMLeveldbStateStoreService() {
        super(NMLeveldbStateStoreService.class.getName());
    }

    @Override
    protected void startStorage() throws IOException {
    }

    @Override
    protected void closeStorage() throws IOException {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public NMStateStoreService.RecoveredLocalizationState loadLocalizationState() throws IOException {
        NMStateStoreService.RecoveredLocalizationState state = new NMStateStoreService.RecoveredLocalizationState();
        LeveldbIterator iter = null;
        try {
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)LOCALIZATION_PUBLIC_KEY_PREFIX));
            state.publicTrackerState = this.loadResourceTrackerState(iter, LOCALIZATION_PUBLIC_KEY_PREFIX);
            iter.seek(JniDBFactory.bytes((String)LOCALIZATION_PRIVATE_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.peekNext();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(LOCALIZATION_PRIVATE_KEY_PREFIX)) {
                    break;
                }
                int userEndPos = key.indexOf(47, LOCALIZATION_PRIVATE_KEY_PREFIX.length());
                if (userEndPos < 0) {
                    throw new IOException("Unable to determine user in resource key: " + key);
                }
                String user = key.substring(LOCALIZATION_PRIVATE_KEY_PREFIX.length(), userEndPos);
                state.userResources.put(user, this.loadUserLocalizedResources(iter, key.substring(0, userEndPos + 1)));
            }
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return state;
    }

    private NMStateStoreService.LocalResourceTrackerState loadResourceTrackerState(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        String completedPrefix = keyPrefix + LOCALIZATION_COMPLETED_SUFFIX;
        String startedPrefix = keyPrefix + LOCALIZATION_STARTED_SUFFIX;
        NMStateStoreService.LocalResourceTrackerState state = new NMStateStoreService.LocalResourceTrackerState();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (key.startsWith(completedPrefix)) {
                state.localizedResources = this.loadCompletedResources(iter, completedPrefix);
                continue;
            }
            if (key.startsWith(startedPrefix)) {
                state.inProgressResources = this.loadStartedResources(iter, startedPrefix);
                continue;
            }
            throw new IOException("Unexpected key in resource tracker state: " + key);
        }
        return state;
    }

    private List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> loadCompletedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> rsrcs = new ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto>();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading completed resource from " + key));
            }
            rsrcs.add(YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto.parseFrom((byte[])entry.getValue()));
            iter.next();
        }
        return rsrcs;
    }

    private Map<YarnProtos.LocalResourceProto, Path> loadStartedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        HashMap<YarnProtos.LocalResourceProto, Path> rsrcs = new HashMap<YarnProtos.LocalResourceProto, Path>();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            Path localPath = new Path(key.substring(keyPrefix.length()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading in-progress resource at " + localPath));
            }
            rsrcs.put(YarnProtos.LocalResourceProto.parseFrom((byte[])((byte[])entry.getValue())), localPath);
            iter.next();
        }
        return rsrcs;
    }

    private NMStateStoreService.RecoveredUserResources loadUserLocalizedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        NMStateStoreService.RecoveredUserResources userResources = new NMStateStoreService.RecoveredUserResources();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (key.startsWith(LOCALIZATION_FILECACHE_SUFFIX, keyPrefix.length())) {
                userResources.privateTrackerState = this.loadResourceTrackerState(iter, keyPrefix + LOCALIZATION_FILECACHE_SUFFIX);
                continue;
            }
            if (key.startsWith(LOCALIZATION_APPCACHE_SUFFIX, keyPrefix.length())) {
                int appIdStartPos = keyPrefix.length() + LOCALIZATION_APPCACHE_SUFFIX.length();
                int appIdEndPos = key.indexOf(47, appIdStartPos);
                if (appIdEndPos < 0) {
                    throw new IOException("Unable to determine appID in resource key: " + key);
                }
                ApplicationId appId = ConverterUtils.toApplicationId((String)key.substring(appIdStartPos, appIdEndPos));
                userResources.appTrackerStates.put(appId, this.loadResourceTrackerState(iter, key.substring(0, appIdEndPos + 1)));
                continue;
            }
            throw new IOException("Unexpected user resource key " + key);
        }
        return userResources;
    }

    @Override
    public void startResourceLocalization(String user, ApplicationId appId, YarnProtos.LocalResourceProto proto, Path localPath) throws IOException {
        String key = this.getResourceStartedKey(user, appId, localPath.toString());
        try {
            this.db.put(JniDBFactory.bytes((String)key), proto.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishResourceLocalization(String user, ApplicationId appId, YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto proto) throws IOException {
        String localPath = proto.getLocalPath();
        String startedKey = this.getResourceStartedKey(user, appId, localPath);
        String completedKey = this.getResourceCompletedKey(user, appId, localPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing localized resource to " + completedKey));
        }
        try {
            WriteBatch batch = this.db.createWriteBatch();
            try {
                batch.delete(JniDBFactory.bytes((String)startedKey));
                batch.put(JniDBFactory.bytes((String)completedKey), proto.toByteArray());
                this.db.write(batch);
            }
            finally {
                batch.close();
            }
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocalizedResource(String user, ApplicationId appId, Path localPath) throws IOException {
        String localPathStr = localPath.toString();
        String startedKey = this.getResourceStartedKey(user, appId, localPathStr);
        String completedKey = this.getResourceCompletedKey(user, appId, localPathStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing local resource at " + localPathStr));
        }
        try {
            WriteBatch batch = this.db.createWriteBatch();
            try {
                batch.delete(JniDBFactory.bytes((String)startedKey));
                batch.delete(JniDBFactory.bytes((String)completedKey));
                this.db.write(batch);
            }
            finally {
                batch.close();
            }
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private String getResourceStartedKey(String user, ApplicationId appId, String localPath) {
        return this.getResourceTrackerKeyPrefix(user, appId) + LOCALIZATION_STARTED_SUFFIX + localPath;
    }

    private String getResourceCompletedKey(String user, ApplicationId appId, String localPath) {
        return this.getResourceTrackerKeyPrefix(user, appId) + LOCALIZATION_COMPLETED_SUFFIX + localPath;
    }

    private String getResourceTrackerKeyPrefix(String user, ApplicationId appId) {
        if (user == null) {
            return LOCALIZATION_PUBLIC_KEY_PREFIX;
        }
        if (appId == null) {
            return LOCALIZATION_PRIVATE_KEY_PREFIX + user + "/" + LOCALIZATION_FILECACHE_SUFFIX;
        }
        return LOCALIZATION_PRIVATE_KEY_PREFIX + user + "/" + LOCALIZATION_APPCACHE_SUFFIX + appId + "/";
    }

    @Override
    public NMStateStoreService.RecoveredDeletionServiceState loadDeletionServiceState() throws IOException {
        NMStateStoreService.RecoveredDeletionServiceState state = new NMStateStoreService.RecoveredDeletionServiceState();
        state.tasks = new ArrayList<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto>();
        LeveldbIterator iter = null;
        try {
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)DELETION_TASK_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(DELETION_TASK_KEY_PREFIX)) {
                    break;
                }
                state.tasks.add(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.parseFrom((byte[])entry.getValue()));
            }
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return state;
    }

    @Override
    public void storeDeletionTask(int taskId, YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto taskProto) throws IOException {
        String key = DELETION_TASK_KEY_PREFIX + taskId;
        try {
            this.db.put(JniDBFactory.bytes((String)key), taskProto.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void removeDeletionTask(int taskId) throws IOException {
        String key = DELETION_TASK_KEY_PREFIX + taskId;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    protected void initStorage(Configuration conf) throws IOException {
        Path storeRoot = this.createStorageDir(conf);
        Options options = new Options();
        options.createIfMissing(false);
        options.logger((Logger)new LeveldbLogger());
        LOG.info((Object)("Using state database at " + storeRoot + " for recovery"));
        File dbfile = new File(storeRoot.toString());
        byte[] schemaVersionData = null;
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
            try {
                schemaVersionData = this.db.get(JniDBFactory.bytes((String)DB_SCHEMA_VERSION_KEY));
            }
            catch (DBException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info((Object)("Creating state database at " + dbfile));
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    schemaVersionData = JniDBFactory.bytes((String)DB_SCHEMA_VERSION);
                    this.db.put(JniDBFactory.bytes((String)DB_SCHEMA_VERSION_KEY), schemaVersionData);
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
        if (schemaVersionData != null) {
            String schemaVersion = JniDBFactory.asString((byte[])schemaVersionData);
            if (!DB_SCHEMA_VERSION.equals(schemaVersion)) {
                throw new IOException("Incompatible state database schema, found " + schemaVersion + " expected " + DB_SCHEMA_VERSION);
            }
        } else {
            throw new IOException("State database schema version not found");
        }
    }

    private Path createStorageDir(Configuration conf) throws IOException {
        String storeUri = conf.get("yarn.nodemanager.recovery.dir");
        if (storeUri == null) {
            throw new IOException("No store location directory configured in yarn.nodemanager.recovery.dir");
        }
        Path root = new Path(storeUri, DB_NAME);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    private static class LeveldbLogger
    implements Logger {
        private static final Log LOG = LogFactory.getLog(LeveldbLogger.class);

        private LeveldbLogger() {
        }

        public void log(String message) {
            LOG.info((Object)message);
        }
    }
}

