/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraValidateRecords
extends Configured
implements Tool {
    static Log LOG = LogFactory.getLog(TeraValidateRecords.class);

    public int run(String[] args) throws Exception {
        JobConf conf = (JobConf)this.getConf();
        int num_records = 0;
        int num_reducers = 1;
        String inputPath = null;
        String outputPath = null;
        if (args.length >= 4) {
            num_records = Integer.parseInt(args[0]);
            num_reducers = Integer.parseInt(args[1]);
            inputPath = args[2];
            outputPath = args[3];
        } else {
            LOG.error((Object)"Usage: teravalidaterecords <number of records> <number of reducers><input> <output>");
            System.exit(1);
        }
        conf.setLong("map.num.records", (long)num_records);
        TeraInputFormatWithCRC.setInputPaths((JobConf)conf, inputPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setJobName("TeraValidateRecords");
        conf.setJarByClass(TeraValidateRecords.class);
        conf.setMapperClass(TeraValidateMapper.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(LongWritable.class);
        conf.setReducerClass(TeraValidateReducer.class);
        conf.setNumReduceTasks(num_reducers);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setInputFormat(TeraInputFormatWithCRC.class);
        conf.setOutputFormat(TextOutputFormat.class);
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraValidateRecords(), (String[])args);
        System.exit(res);
    }

    static class TeraValidateReducer
    extends MapReduceBase
    implements Reducer<IntWritable, LongWritable, LongWritable, Text> {
        private int numPartitions;
        private long num_records;
        private long num_records_per_partitioner;
        private TreeSet<Long> records_hash = null;

        TeraValidateReducer() {
        }

        public void configure(JobConf conf) {
            this.numPartitions = conf.getNumReduceTasks();
            this.num_records = conf.getLong("map.num.records", 1L);
            this.num_records_per_partitioner = this.num_records / (long)this.numPartitions;
        }

        public void reduce(IntWritable key, Iterator<LongWritable> values, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            long startRowId;
            long rowid = 0L;
            this.records_hash = new TreeSet();
            while (values.hasNext()) {
                rowid = values.next().get();
                if (this.records_hash.contains(rowid)) {
                    output.collect((Object)new LongWritable(rowid), (Object)new Text("Duplicate"));
                    continue;
                }
                this.records_hash.add(rowid);
            }
            for (rowid = startRowId = (long)key.get() * this.num_records_per_partitioner; rowid < startRowId + this.num_records_per_partitioner; ++rowid) {
                if (this.records_hash.contains(rowid)) continue;
                output.collect((Object)new LongWritable(rowid), (Object)new Text("Missing"));
            }
        }
    }

    static class TeraValidateMapper
    extends MapReduceBase
    implements Mapper<Text, Text, IntWritable, LongWritable> {
        private static int ROW_LENGTH = 10;
        private int numPartitions;
        private long num_records;
        private long num_records_per_partitioner;

        TeraValidateMapper() {
        }

        public void configure(JobConf conf) {
            this.numPartitions = conf.getNumReduceTasks();
            this.num_records = conf.getLong("map.num.records", 1L);
            this.num_records_per_partitioner = this.num_records / (long)this.numPartitions;
        }

        public void map(Text key, Text value, OutputCollector<IntWritable, LongWritable> output, Reporter reporter) throws IOException {
            String rowid_str = new String(value.getBytes(), 0, ROW_LENGTH).trim();
            long rowid = Long.parseLong(rowid_str);
            int partition_num = (int)(rowid / this.num_records_per_partitioner);
            LOG.info((Object)("Partition number for rowid " + rowid + " " + partition_num));
            output.collect((Object)new IntWritable(partition_num), (Object)new LongWritable(rowid));
        }
    }
}

