/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraOutputFormatWithCRC;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraSortWithCRC
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TeraSortWithCRC.class);

    public int run(String[] args) throws Exception {
        LOG.info((Object)"starting");
        JobConf job = (JobConf)this.getConf();
        Path inputDir = new Path(args[0]);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem((Configuration)job));
        Path partitionFile = new Path(inputDir, "_partition.lst");
        URI partitionUri = new URI(partitionFile.toString() + "#" + "_partition.lst");
        TeraInputFormatWithCRC.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        job.setJobName("TeraSortWithCRC");
        job.setJarByClass(TeraSortWithCRC.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormat(TeraInputFormatWithCRC.class);
        job.setOutputFormat(TeraOutputFormatWithCRC.class);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TeraInputFormatWithCRC.writePartitionFile(job, partitionFile);
        DistributedCache.addCacheFile((URI)partitionUri, (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        job.setInt("dfs.replication", 1);
        TeraOutputFormatWithCRC.setFinalSync(job, true);
        JobClient.runJob((JobConf)job);
        LOG.info((Object)"done");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraSortWithCRC(), (String[])args);
        System.exit(res);
    }

    static class TotalOrderPartitioner
    implements Partitioner<Text, Text> {
        private TrieNode trie;
        private Text[] splitPoints;

        private static Text[] readPartitions(FileSystem fs, Path p, JobConf job) throws IOException {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, p, (Configuration)job);
            ArrayList<Text> parts = new ArrayList<Text>();
            Text key = new Text();
            NullWritable value = NullWritable.get();
            while (reader.next((Writable)key, (Writable)value)) {
                parts.add(key);
                key = new Text();
            }
            reader.close();
            return parts.toArray(new Text[parts.size()]);
        }

        private static TrieNode buildTrie(Text[] splits, int lower, int upper, Text prefix, int maxDepth) {
            int depth = prefix.getLength();
            if (depth >= maxDepth || lower == upper) {
                return new LeafTrieNode(depth, splits, lower, upper);
            }
            InnerTrieNode result = new InnerTrieNode(depth);
            Text trial = new Text(prefix);
            trial.append(new byte[1], 0, 1);
            int currentBound = lower;
            for (int ch = 0; ch < 255; ++ch) {
                trial.getBytes()[depth] = (byte)(ch + 1);
                lower = currentBound;
                while (currentBound < upper && splits[currentBound].compareTo((BinaryComparable)trial) < 0) {
                    ++currentBound;
                }
                trial.getBytes()[depth] = (byte)ch;
                ((InnerTrieNode)result).child[ch] = TotalOrderPartitioner.buildTrie(splits, lower, currentBound, trial, maxDepth);
            }
            trial.getBytes()[depth] = 127;
            ((InnerTrieNode)result).child[255] = TotalOrderPartitioner.buildTrie(splits, currentBound, upper, trial, maxDepth);
            return result;
        }

        public void configure(JobConf job) {
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
                Path partFile = new Path("_partition.lst");
                this.splitPoints = TotalOrderPartitioner.readPartitions((FileSystem)fs, partFile, job);
                this.trie = TotalOrderPartitioner.buildTrie(this.splitPoints, 0, this.splitPoints.length, new Text(), 2);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read paritions file", ie);
            }
        }

        public int getPartition(Text key, Text value, int numPartitions) {
            return this.trie.findPartition(key);
        }

        static class LeafTrieNode
        extends TrieNode {
            int lower;
            int upper;
            Text[] splitPoints;

            LeafTrieNode(int level, Text[] splitPoints, int lower, int upper) {
                super(level);
                this.splitPoints = splitPoints;
                this.lower = lower;
                this.upper = upper;
            }

            @Override
            int findPartition(Text key) {
                for (int i = this.lower; i < this.upper; ++i) {
                    if (this.splitPoints[i].compareTo((BinaryComparable)key) < 0) continue;
                    return i;
                }
                return this.upper;
            }

            @Override
            void print(PrintStream strm) throws IOException {
                for (int i = 0; i < 2 * this.getLevel(); ++i) {
                    strm.print(' ');
                }
                strm.print(this.lower);
                strm.print(", ");
                strm.println(this.upper);
            }
        }

        static class InnerTrieNode
        extends TrieNode {
            private TrieNode[] child = new TrieNode[256];

            InnerTrieNode(int level) {
                super(level);
            }

            @Override
            int findPartition(Text key) {
                int level = this.getLevel();
                if (key.getLength() <= level) {
                    return this.child[0].findPartition(key);
                }
                return this.child[key.getBytes()[level]].findPartition(key);
            }

            void setChild(int idx, TrieNode child) {
                this.child[idx] = child;
            }

            @Override
            void print(PrintStream strm) throws IOException {
                for (int ch = 0; ch < 255; ++ch) {
                    for (int i = 0; i < 2 * this.getLevel(); ++i) {
                        strm.print(' ');
                    }
                    strm.print(ch);
                    strm.println(" ->");
                    if (this.child[ch] == null) continue;
                    this.child[ch].print(strm);
                }
            }
        }

        static abstract class TrieNode {
            private int level;

            TrieNode(int level) {
                this.level = level;
            }

            abstract int findPartition(Text var1);

            abstract void print(PrintStream var1) throws IOException;

            int getLevel() {
                return this.level;
            }
        }
    }
}

