/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.DataInput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapOutputLocation;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;
import org.apache.hadoop.util.Progress;

public class DirectShuffleSchedulerImpl<K, V>
implements ShuffleScheduler<K, V> {
    private static final Log LOG = LogFactory.getLog(DirectShuffleSchedulerImpl.class);
    private static final long INITIAL_PENALTY = 10000L;
    private static final float PENALTY_GROWTH_RATE = 1.3f;
    private static final int REPORT_FAILURE_LIMIT = 10;
    private final LinkedList<MapOutputLocation> newMapOutputs = new LinkedList();
    private Set<TaskAttemptID> obsoleteMaps = new HashSet<TaskAttemptID>();
    private final boolean[] finishedMaps;
    private final int totalMaps;
    private int remainingMaps;
    private final TaskAttemptID reduceId;
    private final TaskStatus status;
    private final ExceptionReporter reporter;
    private Configuration conf;
    private final int abortFailureLimit;
    private final Progress progress;
    private final Map<TaskAttemptID, IntWritable> failureCounts = new HashMap<TaskAttemptID, IntWritable>();
    private final Counters.Counter shuffledMapsCounter;
    private final Counters.Counter reduceShuffleBytes;
    private final Counters.Counter failedShuffleCounter;
    private final long startTime;
    private long lastProgressTime;
    private volatile int maxMapRuntime = 0;
    private final int maxFailedUniqueFetches;
    private final int maxFetchFailuresBeforeReporting;
    private final Random random = new Random();
    private long totalBytesShuffledTillNow = 0L;
    private final DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private final boolean reportReadErrorImmediately;
    private long maxDelay = 60000L;
    private final Map<String, IntWritable> hostFailures = new HashMap<String, IntWritable>();

    public DirectShuffleSchedulerImpl(JobConf job, TaskStatus status, TaskAttemptID reduceId, ExceptionReporter reporter, Progress progress, Counters.Counter shuffledMapsCounter, Counters.Counter reduceShuffleBytes, Counters.Counter failedShuffleCounter) {
        this.totalMaps = job.getNumMapTasks();
        this.abortFailureLimit = Math.max(30, this.totalMaps / 10);
        this.conf = job;
        this.remainingMaps = this.totalMaps;
        this.finishedMaps = new boolean[this.remainingMaps];
        this.reporter = reporter;
        this.status = status;
        this.reduceId = reduceId;
        this.progress = progress;
        this.shuffledMapsCounter = shuffledMapsCounter;
        this.reduceShuffleBytes = reduceShuffleBytes;
        this.failedShuffleCounter = failedShuffleCounter;
        this.lastProgressTime = this.startTime = System.currentTimeMillis();
        this.maxFailedUniqueFetches = Math.min(this.totalMaps, 5);
        this.maxFetchFailuresBeforeReporting = job.getInt("mapreduce.reduce.shuffle.maxfetchfailures", 10);
        this.reportReadErrorImmediately = job.getBoolean("mapreduce.reduce.shuffle.notify.readerror", true);
        this.maxDelay = job.getLong("mapreduce.reduce.shuffle.retry-delay.max.ms", 60000L);
    }

    public synchronized boolean waitUntilDone(int millis) throws InterruptedException {
        if (this.remainingMaps > 0) {
            this.wait(millis);
            return this.remainingMaps == 0;
        }
        return true;
    }

    public void resolve(TaskCompletionEvent event) throws IOException, InterruptedException {
        if (!event.isMapTask()) {
            return;
        }
        switch (event.getTaskStatus()) {
            case SUCCEEDED: {
                org.apache.hadoop.mapred.TaskAttemptID taskId = event.getTaskAttemptId();
                Map servicedata = event.getServiceMetaData();
                ByteBuffer directShuffleData = (ByteBuffer)servicedata.get("mapr_direct_shuffle");
                PathId pathId = null;
                String host = null;
                try {
                    DataInputByteBuffer in;
                    if (directShuffleData != null) {
                        in = new DataInputByteBuffer();
                        in.reset(new ByteBuffer[]{directShuffleData});
                        host = WritableUtils.readString((DataInput)in);
                        if (host == null) {
                            throw new IOException("null hostname found in taskCompletionEvent location: '" + event.getTaskTrackerHttp() + "'");
                        }
                        int size = WritableUtils.readVInt((DataInput)in);
                        for (int i = 0; i < size; ++i) {
                            String dirName = WritableUtils.readString((DataInput)in);
                            PathId pathIdTmp = FileSystem.get((Configuration)this.conf).createPathId();
                            pathIdTmp.readFields((DataInput)in);
                            if (!dirName.equalsIgnoreCase(".")) continue;
                            pathId = pathIdTmp;
                        }
                    } else {
                        throw new IOException("No mapr_direct_shuffle service info was passed with taskCompletionEvent location: '" + event.getTaskTrackerHttp() + "'");
                    }
                    in.close();
                }
                catch (Throwable t) {
                    throw new IOException("No parentFid info was passed with taskCompletionEvent location: '" + event.getTaskTrackerHttp() + "'");
                }
                int duration = event.getTaskRunTime();
                this.addKnownMapOutput(host, (TaskAttemptID)taskId, pathId);
                if (duration <= this.maxMapRuntime) break;
                this.maxMapRuntime = duration;
                break;
            }
            case FAILED: 
            case KILLED: 
            case OBSOLETE: {
                this.obsoleteMapOutput((TaskAttemptID)event.getTaskAttemptId());
                LOG.info((Object)("Ignoring obsolete output of " + event.getTaskStatus() + " map-task: '" + event.getTaskAttemptId() + "'"));
                break;
            }
            case TIPFAILED: {
                this.tipFailed(event.getTaskAttemptId().getTaskID());
                LOG.info((Object)("Ignoring output of failed map TIP: '" + event.getTaskAttemptId() + "'"));
            }
        }
    }

    public synchronized void addKnownMapOutput(String host, TaskAttemptID taskId, PathId pathId) {
        this.newMapOutputs.add(new MapOutputLocation(taskId, host, pathId));
        this.notifyAll();
    }

    public synchronized void obsoleteMapOutput(TaskAttemptID mapId) {
        this.obsoleteMaps.add(mapId);
    }

    public synchronized void tipFailed(TaskID taskId) {
        if (!this.finishedMaps[taskId.getId()]) {
            this.finishedMaps[taskId.getId()] = true;
            if (--this.remainingMaps == 0) {
                this.notifyAll();
            }
            this.updateStatus();
        }
    }

    public synchronized void copySucceeded(TaskAttemptID mapId, MapOutputLocation loc, long bytes, long millis, MapOutput<K, V> output) throws IOException {
        this.failureCounts.remove(mapId);
        this.hostFailures.remove(loc.getHost());
        int mapIndex = mapId.getTaskID().getId();
        if (!this.finishedMaps[mapIndex]) {
            output.commit();
            this.finishedMaps[mapIndex] = true;
            this.shuffledMapsCounter.increment(1L);
            if (--this.remainingMaps == 0) {
                this.notifyAll();
            }
            this.totalBytesShuffledTillNow += bytes;
            this.updateStatus();
            this.reduceShuffleBytes.increment(bytes);
            this.lastProgressTime = System.currentTimeMillis();
            LOG.debug((Object)("map " + mapId + " done " + this.status.getStateString()));
        }
    }

    public synchronized void copyFailed(TaskAttemptID mapId, MapOutputLocation loc) {
        int failures = 1;
        if (this.failureCounts.containsKey(mapId)) {
            IntWritable x = this.failureCounts.get(mapId);
            x.set(x.get() + 1);
            failures = x.get();
        } else {
            this.failureCounts.put(mapId, new IntWritable(1));
        }
        String hostname = loc.getHost();
        if (this.hostFailures.containsKey(hostname)) {
            IntWritable x = this.hostFailures.get(hostname);
            x.set(x.get() + 1);
        } else {
            this.hostFailures.put(hostname, new IntWritable(1));
        }
        if (failures >= this.abortFailureLimit) {
            try {
                throw new IOException(failures + " failures downloading " + mapId);
            }
            catch (IOException ie) {
                this.reporter.reportException((Throwable)ie);
            }
        }
        this.checkAndInformJobTracker(failures, mapId);
        this.checkReducerHealth();
        long delay = (long)(10000.0 * Math.pow(1.3f, failures));
        if (delay > this.maxDelay) {
            delay = this.maxDelay;
        }
        this.failedShuffleCounter.increment(1L);
    }

    private void updateStatus() {
        float mbs = (float)this.totalBytesShuffledTillNow / 1048576.0f;
        int mapsDone = this.totalMaps - this.remainingMaps;
        long secsSinceStart = (System.currentTimeMillis() - this.startTime) / 1000L + 1L;
        float transferRate = mbs / (float)secsSinceStart;
        this.progress.set((float)mapsDone / (float)this.totalMaps);
        String statusString = mapsDone + " / " + this.totalMaps + " copied.";
        this.status.setStateString(statusString);
        this.progress.setStatus("copy(" + mapsDone + " of " + this.totalMaps + " at " + this.mbpsFormat.format(transferRate) + " MB/s)");
    }

    public static int getClosestPowerOf2(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Undefined for " + value);
        }
        int hob = Integer.highestOneBit(value);
        return Integer.numberOfTrailingZeros(hob) + ((hob >>> 1 & value) == 0 ? 0 : 1);
    }

    public void close() throws InterruptedException {
    }

    public void reportLocalError(IOException ioe) {
        try {
            LOG.error((Object)("Shuffle failed : local error on this node: " + InetAddress.getLocalHost()));
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Shuffle failed : local error on this node");
        }
        this.reporter.reportException((Throwable)ioe);
    }

    private void checkAndInformJobTracker(int failures, TaskAttemptID mapId) {
        if (this.reportReadErrorImmediately || failures % this.maxFetchFailuresBeforeReporting == 0) {
            LOG.info((Object)("Reporting fetch failure for " + mapId + " to the caller: MR AppMaster."));
            this.status.addFetchFailedMap((org.apache.hadoop.mapred.TaskAttemptID)mapId);
        }
    }

    private void checkReducerHealth() {
        boolean reducerStalled;
        int doneMaps;
        float MAX_ALLOWED_FAILED_FETCH_ATTEMPT_PERCENT = 0.5f;
        float MIN_REQUIRED_PROGRESS_PERCENT = 0.5f;
        float MAX_ALLOWED_STALL_TIME_PERCENT = 0.5f;
        long totalFailures = this.failedShuffleCounter.getValue();
        boolean reducerHealthy = (float)totalFailures / (float)(totalFailures + (long)(doneMaps = this.totalMaps - this.remainingMaps)) < 0.5f;
        boolean reducerProgressedEnough = (float)doneMaps / (float)this.totalMaps >= 0.5f;
        int stallDuration = (int)(System.currentTimeMillis() - this.lastProgressTime);
        int shuffleProgressDuration = (int)(this.lastProgressTime - this.startTime);
        int minShuffleRunDuration = Math.max(shuffleProgressDuration, this.maxMapRuntime);
        boolean bl = reducerStalled = (float)stallDuration / (float)minShuffleRunDuration >= 0.5f;
        if (!(this.failureCounts.size() < this.maxFailedUniqueFetches && this.failureCounts.size() != this.totalMaps - doneMaps || reducerHealthy || reducerProgressedEnough && !reducerStalled)) {
            LOG.fatal((Object)"Shuffle failed with too many fetch failures and insufficient progress!");
            String errorMsg = "Exceeded MAX_FAILED_UNIQUE_FETCHES; bailing-out.";
            this.reporter.reportException((Throwable)new IOException(errorMsg));
        }
    }

    public synchronized MapOutputLocation getLocation() throws InterruptedException {
        while (this.newMapOutputs.isEmpty()) {
            this.wait();
        }
        int numScheduled = this.newMapOutputs.size();
        ListIterator<MapOutputLocation> it = this.newMapOutputs.listIterator(this.random.nextInt(numScheduled));
        boolean wrapped = false;
        while (it.hasNext()) {
            TaskAttemptID id;
            MapOutputLocation loc = it.next();
            it.remove();
            if (!wrapped && !it.hasNext()) {
                wrapped = true;
                it = this.newMapOutputs.listIterator(0);
            }
            if (this.obsoleteMaps.contains(id = loc.getTaskAttemptId()) || this.finishedMaps[id.getTaskID().getId()]) {
                LOG.info((Object)(this.reduceId + " Ignoring obsolete copy result for Map Task: " + loc.getTaskAttemptId() + " from host: " + loc.getHost()));
                continue;
            }
            return loc;
        }
        return null;
    }
}

