/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestRenameWithSnapshots {
    private static final Log LOG = LogFactory.getLog(TestRenameWithSnapshots.class);
    private static final long SEED = 0L;
    private static final short REPL = 3;
    private static final short REPL_1 = 2;
    private static final short REPL_2 = 1;
    private static final long BLOCKSIZE = 1024L;
    private static final Configuration conf = new Configuration();
    private static MiniDFSCluster cluster;
    private static FSNamesystem fsn;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;
    private static final String testDir;
    private static final Path dir;
    private static final Path sub1;
    private static final Path file1;
    private static final Path file2;
    private static final Path file3;
    private static final String snap1 = "snap1";
    private static final String snap2 = "snap2";

    public TestRenameWithSnapshots() {
        SnapshotTestHelper.disableLogs();
    }

    @Before
    public void setUp() throws Exception {
        conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testRenameFromSDir2NonSDir() throws Exception {
        String dirStr = "/testRenameWithSnapshot";
        String abcStr = "/testRenameWithSnapshot/abc";
        Path abc = new Path("/testRenameWithSnapshot/abc");
        hdfs.mkdirs(abc, new FsPermission(511));
        hdfs.allowSnapshot(abc);
        Path foo = new Path(abc, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        hdfs.createSnapshot(abc, "s0");
        try {
            hdfs.rename(abc, new Path("/testRenameWithSnapshot", "tmp"));
            Assert.fail((String)("Expect exception since " + abc + " is snapshottable and already has snapshots"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"/testRenameWithSnapshot/abc is snapshottable and already has snapshots", (Throwable)e);
        }
        String xyzStr = "/testRenameWithSnapshot/xyz";
        Path xyz = new Path("/testRenameWithSnapshot/xyz");
        hdfs.mkdirs(xyz, new FsPermission(511));
        Path bar = new Path(xyz, "bar");
        hdfs.rename(foo, bar);
        INode fooRef = fsdir.getINode(SnapshotTestHelper.getSnapshotPath(abc, "s0", "foo").toString());
        Assert.assertTrue((boolean)fooRef.isReference());
        Assert.assertTrue((boolean)(fooRef.asReference() instanceof INodeReference.WithName));
        INodeReference.WithCount withCount = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assert.assertEquals((long)2L, (long)withCount.getReferenceCount());
        INode barRef = fsdir.getINode(bar.toString());
        Assert.assertTrue((boolean)barRef.isReference());
        Assert.assertSame((Object)withCount, (Object)barRef.asReference().getReferredINode());
        hdfs.delete(bar, false);
        Assert.assertEquals((long)1L, (long)withCount.getReferenceCount());
    }

    private static boolean existsInDiffReport(List<SnapshotDiffReport.DiffReportEntry> entries, SnapshotDiffReport.DiffType type, String relativePath) {
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            System.out.println("DiffEntry is:" + entry.getType() + "\"" + new String(entry.getRelativePath()) + "\"");
            if (entry.getType() != type || new String(entry.getRelativePath()).compareTo(relativePath) != 0) continue;
            return true;
        }
        return false;
    }

    @Test(timeout=60000L)
    public void testRenameFileNotInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, snap1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.rename(file1, file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        List entries = diffReport.getDiffList();
        Assert.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file2.getName()));
    }

    @Test
    public void testRenameFileInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, snap1);
        hdfs.rename(file1, file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        System.out.println("DiffList is " + diffReport.toString());
        List entries = diffReport.getDiffList();
        Assert.assertTrue((entries.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file2.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, file1.getName()));
    }

    @Test(timeout=60000L)
    public void testRenameTwiceInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, snap1);
        hdfs.rename(file1, file2);
        hdfs.createSnapshot(sub1, snap2);
        hdfs.rename(file2, file3);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, snap2);
        LOG.info((Object)("DiffList is " + diffReport.toString()));
        List entries = diffReport.getDiffList();
        Assert.assertTrue((entries.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file2.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, file1.getName()));
        diffReport = hdfs.getSnapshotDiffReport(sub1, snap2, "");
        LOG.info((Object)("DiffList is " + diffReport.toString()));
        entries = diffReport.getDiffList();
        Assert.assertTrue((entries.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file3.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, file2.getName()));
        diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        LOG.info((Object)("DiffList is " + diffReport.toString()));
        entries = diffReport.getDiffList();
        Assert.assertTrue((entries.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file3.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, file1.getName()));
    }

    @Test(timeout=60000L)
    public void testRenameFileInSubDirOfDirWithSnapshot() throws Exception {
        Path sub2 = new Path(sub1, "sub2");
        Path sub2file1 = new Path(sub2, "sub2file1");
        Path sub2file2 = new Path(sub2, "sub2file2");
        String sub1snap1 = "sub1snap1";
        hdfs.mkdirs(sub1);
        hdfs.mkdirs(sub2);
        DFSTestUtil.createFile((FileSystem)hdfs, sub2file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap1");
        hdfs.rename(sub2file1, sub2file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, "sub1snap1", "");
        LOG.info((Object)("DiffList is \n\"" + diffReport.toString() + "\""));
        List entries = diffReport.getDiffList();
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, sub2.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, sub2.getName() + "/" + sub2file2.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, sub2.getName() + "/" + sub2file1.getName()));
    }

    @Test(timeout=60000L)
    public void testRenameDirectoryInSnapshot() throws Exception {
        Path sub2 = new Path(sub1, "sub2");
        Path sub3 = new Path(sub1, "sub3");
        Path sub2file1 = new Path(sub2, "sub2file1");
        String sub1snap1 = "sub1snap1";
        hdfs.mkdirs(sub1);
        hdfs.mkdirs(sub2);
        DFSTestUtil.createFile((FileSystem)hdfs, sub2file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap1");
        hdfs.rename(sub2, sub3);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, "sub1snap1", "");
        LOG.info((Object)("DiffList is \n\"" + diffReport.toString() + "\""));
        List entries = diffReport.getDiffList();
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, ""));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, sub3.getName()));
        Assert.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, sub2.getName()));
    }

    @Test(timeout=60000L)
    public void testRenameDirAcrossSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        Path bar2 = new Path(foo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.setReplication(bar2, (short)2);
        hdfs.delete(bar, true);
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        Path snapshotBar = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assert.assertTrue((boolean)hdfs.exists(snapshotBar));
        Path newBar2 = new Path(newfoo, "bar2");
        Assert.assertTrue((boolean)hdfs.exists(newBar2));
        hdfs.delete(newBar2, true);
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar2");
        Assert.assertTrue((boolean)hdfs.exists(bar2_s2));
        FileStatus status = hdfs.getFileStatus(bar2_s2);
        Assert.assertEquals((long)3L, (long)status.getReplication());
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
    }

    @Test(timeout=60000L)
    public void testRenameFileAcrossSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        hdfs.setReplication(newfoo, (short)2);
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        Assert.assertTrue((boolean)hdfs.exists(foo_s2));
        FileStatus status = hdfs.getFileStatus(foo_s2);
        Assert.assertEquals((long)3L, (long)status.getReplication());
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo");
        Assert.assertFalse((boolean)hdfs.exists(foo_s3));
        INodeDirectorySnapshottable sdir2Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir2.toString());
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        INodeFile sfoo = fsdir.getINode(newfoo.toString()).asFile();
        Assert.assertEquals((long)s2.getId(), (long)sfoo.getDiffs().getLastSnapshotId());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_1() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        Path bar2 = new Path(foo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        Path newbar = new Path(newfoo, bar.getName());
        Path newbar2 = new Path(newfoo, bar2.getName());
        Path newbar3 = new Path(newfoo, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, newbar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.delete(newbar, true);
        hdfs.delete(newbar3, true);
        Assert.assertFalse((boolean)hdfs.exists(newbar3));
        Assert.assertFalse((boolean)hdfs.exists(bar));
        Path bar_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar");
        Path bar3_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar3");
        Assert.assertTrue((boolean)hdfs.exists(bar_s4));
        Assert.assertTrue((boolean)hdfs.exists(bar3_s4));
        hdfs.createSnapshot(sdir1, "s5");
        hdfs.delete(newbar2, true);
        Assert.assertFalse((boolean)hdfs.exists(bar2));
        Path bar2_s5 = SnapshotTestHelper.getSnapshotPath(sdir1, "s5", "foo/bar2");
        Assert.assertTrue((boolean)hdfs.exists(bar2_s5));
        hdfs.deleteSnapshot(sdir1, "s5");
        this.restartClusterAndCheckImage(true);
        Assert.assertFalse((boolean)hdfs.exists(bar2_s5));
        Path bar2_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar2");
        Assert.assertTrue((boolean)hdfs.exists(bar2_s4));
        hdfs.deleteSnapshot(sdir1, "s4");
        Assert.assertFalse((boolean)hdfs.exists(bar_s4));
        Path bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar");
        Assert.assertFalse((boolean)hdfs.exists(bar_s3));
        bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar");
        Assert.assertFalse((boolean)hdfs.exists(bar_s3));
        Path bar_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assert.assertTrue((boolean)hdfs.exists(bar_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s4));
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar2");
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar2");
        Assert.assertTrue((boolean)hdfs.exists(bar2_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar3_s4));
        Path bar3_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar3");
        Assert.assertFalse((boolean)hdfs.exists(bar3_s3));
        bar3_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar3");
        Assert.assertFalse((boolean)hdfs.exists(bar3_s3));
        Path bar3_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar3");
        Assert.assertFalse((boolean)hdfs.exists(bar3_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assert.assertFalse((boolean)hdfs.exists(bar_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s3");
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
    }

    private void restartClusterAndCheckImage(boolean compareQuota) throws IOException {
        File fsnBefore = new File(testDir, "dumptree_before");
        File fsnMiddle = new File(testDir, "dumptree_middle");
        File fsnAfter = new File(testDir, "dumptree_after");
        SnapshotTestHelper.dumpTree2File(fsdir, fsnBefore);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnMiddle);
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnAfter);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnMiddle, compareQuota);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnAfter, compareQuota);
    }

    @Test
    public void testRenameFileAndDeleteSnapshot() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        hdfs.setReplication(newfoo, (short)2);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.setReplication(newfoo, (short)1);
        FileStatus status = hdfs.getFileStatus(newfoo);
        Assert.assertEquals((long)1L, (long)status.getReplication());
        Path foo_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo");
        status = hdfs.getFileStatus(foo_s4);
        Assert.assertEquals((long)2L, (long)status.getReplication());
        hdfs.createSnapshot(sdir1, "s5");
        Path foo_s5 = SnapshotTestHelper.getSnapshotPath(sdir1, "s5", "foo");
        status = hdfs.getFileStatus(foo_s5);
        Assert.assertEquals((long)1L, (long)status.getReplication());
        hdfs.deleteSnapshot(sdir1, "s5");
        this.restartClusterAndCheckImage(true);
        Assert.assertFalse((boolean)hdfs.exists(foo_s5));
        status = hdfs.getFileStatus(foo_s4);
        Assert.assertEquals((long)2L, (long)status.getReplication());
        hdfs.deleteSnapshot(sdir1, "s4");
        Assert.assertFalse((boolean)hdfs.exists(foo_s4));
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo");
        Assert.assertFalse((boolean)hdfs.exists(foo_s3));
        foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo");
        Assert.assertFalse((boolean)hdfs.exists(foo_s3));
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        Assert.assertTrue((boolean)hdfs.exists(foo_s2));
        status = hdfs.getFileStatus(foo_s2);
        Assert.assertEquals((long)3L, (long)status.getReplication());
        INodeFile snode = fsdir.getINode(newfoo.toString()).asFile();
        Assert.assertEquals((long)1L, (long)snode.getDiffs().asList().size());
        INodeDirectorySnapshottable sdir2Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir2.toString());
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        Assert.assertEquals((long)s2.getId(), (long)snode.getDiffs().getLastSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assert.assertFalse((boolean)hdfs.exists(foo_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s3");
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameMoreThanOnceAcrossSnapDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo_dir1 = new Path(sdir1, "foo");
        Path bar1_dir1 = new Path(foo_dir1, "bar1");
        Path bar2_dir1 = new Path(sdir1, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar1_dir1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2_dir1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s3");
        Path foo_dir2 = new Path(sdir2, "foo");
        hdfs.rename(foo_dir1, foo_dir2);
        Path bar2_dir2 = new Path(sdir2, "bar");
        hdfs.rename(bar2_dir1, bar2_dir2);
        this.restartClusterAndCheckImage(true);
        Path bar1_dir2 = new Path(foo_dir2, "bar1");
        hdfs.setReplication(bar1_dir2, (short)2);
        hdfs.setReplication(bar2_dir2, (short)2);
        Path bar1_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo/bar1");
        Path bar2_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "bar");
        Path bar1_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar1");
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "bar");
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s2));
        FileStatus statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assert.assertEquals((long)2L, (long)statusBar1.getReplication());
        FileStatus statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assert.assertEquals((long)3L, (long)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir2);
        Assert.assertEquals((long)2L, (long)statusBar2.getReplication());
        Path foo_dir3 = new Path(sdir3, "foo");
        hdfs.rename(foo_dir2, foo_dir3);
        Path bar2_dir3 = new Path(sdir3, "bar");
        hdfs.rename(bar2_dir2, bar2_dir3);
        this.restartClusterAndCheckImage(true);
        Path bar1_dir3 = new Path(foo_dir3, "bar1");
        hdfs.setReplication(bar1_dir3, (short)1);
        hdfs.setReplication(bar2_dir3, (short)1);
        Path bar1_s3 = SnapshotTestHelper.getSnapshotPath(sdir3, "s3", "foo/bar1");
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir3, "s3", "bar");
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir3);
        Assert.assertEquals((long)1L, (long)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assert.assertEquals((long)3L, (long)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir3);
        Assert.assertEquals((long)1L, (long)statusBar2.getReplication());
        hdfs.rename(foo_dir3, foo_dir2);
        hdfs.rename(bar2_dir3, bar2_dir2);
        this.restartClusterAndCheckImage(true);
        hdfs.setReplication(bar1_dir2, (short)3);
        hdfs.setReplication(bar2_dir2, (short)3);
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assert.assertEquals((long)3L, (long)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir2);
        Assert.assertEquals((long)3L, (long)statusBar2.getReplication());
        hdfs.rename(foo_dir2, foo_dir1);
        hdfs.rename(bar2_dir2, bar2_dir1);
        INodeReference fooRef = fsdir.getINode4Write(foo_dir1.toString()).asReference();
        INodeReference.WithCount fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assert.assertEquals((long)2L, (long)fooWithCount.getReferenceCount());
        INodeDirectory foo = fooWithCount.asDirectory();
        Assert.assertEquals((long)1L, (long)foo.getDiffs().asList().size());
        INodeDirectorySnapshottable sdir1Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir1.toString());
        Snapshot s1 = sdir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assert.assertEquals((long)s1.getId(), (long)foo.getDirectoryWithSnapshotFeature().getLastSnapshotId());
        INodeFile bar1 = fsdir.getINode4Write(bar1_dir1.toString()).asFile();
        Assert.assertEquals((long)1L, (long)bar1.getDiffs().asList().size());
        Assert.assertEquals((long)s1.getId(), (long)bar1.getDiffs().getLastSnapshotId());
        INodeReference barRef = fsdir.getINode4Write(bar2_dir1.toString()).asReference();
        INodeReference.WithCount barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assert.assertEquals((long)2L, (long)barWithCount.getReferenceCount());
        INodeFile bar = barWithCount.asFile();
        Assert.assertEquals((long)1L, (long)bar.getDiffs().asList().size());
        Assert.assertEquals((long)s1.getId(), (long)bar.getDiffs().getLastSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.delete(foo_dir1, true);
        hdfs.delete(bar2_dir1, true);
        this.restartClusterAndCheckImage(true);
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        Assert.assertFalse((boolean)hdfs.exists(foo_dir1));
        Assert.assertFalse((boolean)hdfs.exists(bar1_dir1));
        Assert.assertFalse((boolean)hdfs.exists(bar2_dir1));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assert.assertEquals((long)3L, (long)statusBar2.getReplication());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        fooRef = fsdir.getINode(foo_s1.toString()).asReference();
        fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assert.assertEquals((long)1L, (long)fooWithCount.getReferenceCount());
        barRef = fsdir.getINode(bar2_s1.toString()).asReference();
        barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assert.assertEquals((long)1L, (long)barWithCount.getReferenceCount());
    }

    @Test
    public void testRenameMoreThanOnceAcrossSnapDirs_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo_dir1 = new Path(sdir1, "foo");
        Path bar1_dir1 = new Path(foo_dir1, "bar1");
        Path bar_dir1 = new Path(sdir1, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar1_dir1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar_dir1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s3");
        Path foo_dir2 = new Path(sdir2, "foo");
        hdfs.rename(foo_dir1, foo_dir2);
        Path bar_dir2 = new Path(sdir2, "bar");
        hdfs.rename(bar_dir1, bar_dir2);
        Path bar1_dir2 = new Path(foo_dir2, "bar1");
        hdfs.setReplication(bar1_dir2, (short)2);
        hdfs.setReplication(bar_dir2, (short)2);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s11");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s22");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s33");
        Path foo_dir3 = new Path(sdir3, "foo");
        hdfs.rename(foo_dir2, foo_dir3);
        Path bar_dir3 = new Path(sdir3, "bar");
        hdfs.rename(bar_dir2, bar_dir3);
        Path bar1_dir3 = new Path(foo_dir3, "bar1");
        hdfs.setReplication(bar1_dir3, (short)1);
        hdfs.setReplication(bar_dir3, (short)1);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s111");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s222");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s333");
        Path bar1_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo/bar1");
        Path bar1_s22 = SnapshotTestHelper.getSnapshotPath(sdir2, "s22", "foo/bar1");
        Path bar1_s333 = SnapshotTestHelper.getSnapshotPath(sdir3, "s333", "foo/bar1");
        Path bar_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "bar");
        Path bar_s22 = SnapshotTestHelper.getSnapshotPath(sdir2, "s22", "bar");
        Path bar_s333 = SnapshotTestHelper.getSnapshotPath(sdir3, "s333", "bar");
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assert.assertTrue((boolean)hdfs.exists(bar_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar_s333));
        FileStatus statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir3);
        Assert.assertEquals((long)1L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s22);
        Assert.assertEquals((long)2L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s333);
        Assert.assertEquals((long)1L, (long)statusBar1.getReplication());
        FileStatus statusBar = hdfs.getFileStatus(bar_s1);
        Assert.assertEquals((long)3L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_dir3);
        Assert.assertEquals((long)1L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s22);
        Assert.assertEquals((long)2L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s333);
        Assert.assertEquals((long)1L, (long)statusBar.getReplication());
        hdfs.rename(foo_dir3, foo_dir2);
        hdfs.rename(bar_dir3, bar_dir2);
        hdfs.setReplication(bar1_dir2, (short)3);
        hdfs.setReplication(bar_dir2, (short)3);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1111");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2222");
        Path bar1_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "foo/bar1");
        Path bar_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "bar");
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s2222));
        Assert.assertTrue((boolean)hdfs.exists(bar_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar_s333));
        Assert.assertTrue((boolean)hdfs.exists(bar_s2222));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s22);
        Assert.assertEquals((long)2L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s333);
        Assert.assertEquals((long)1L, (long)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s2222);
        Assert.assertEquals((long)3L, (long)statusBar1.getReplication());
        statusBar = hdfs.getFileStatus(bar_s1);
        Assert.assertEquals((long)3L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_dir2);
        Assert.assertEquals((long)3L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s22);
        Assert.assertEquals((long)2L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s333);
        Assert.assertEquals((long)1L, (long)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s2222);
        Assert.assertEquals((long)3L, (long)statusBar.getReplication());
        hdfs.rename(foo_dir2, foo_dir1);
        hdfs.rename(bar_dir2, bar_dir1);
        INodeDirectorySnapshottable sdir1Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir1.toString());
        INodeDirectorySnapshottable sdir2Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir2.toString());
        INodeDirectorySnapshottable sdir3Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir3.toString());
        INodeReference fooRef = fsdir.getINode4Write(foo_dir1.toString()).asReference();
        INodeReference.WithCount fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assert.assertEquals((long)5L, (long)fooWithCount.getReferenceCount());
        INodeDirectory foo = fooWithCount.asDirectory();
        List fooDiffs = foo.getDiffs().asList();
        Assert.assertEquals((long)4L, (long)fooDiffs.size());
        Snapshot s2222 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2222"));
        Snapshot s333 = sdir3Node.getSnapshot(DFSUtil.string2Bytes((String)"s333"));
        Snapshot s22 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s22"));
        Snapshot s1 = sdir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assert.assertEquals((long)s2222.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(3)).getSnapshotId());
        Assert.assertEquals((long)s333.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(2)).getSnapshotId());
        Assert.assertEquals((long)s22.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(1)).getSnapshotId());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        INodeFile bar1 = fsdir.getINode4Write(bar1_dir1.toString()).asFile();
        List bar1Diffs = bar1.getDiffs().asList();
        Assert.assertEquals((long)3L, (long)bar1Diffs.size());
        Assert.assertEquals((long)s333.getId(), (long)((FileDiff)bar1Diffs.get(2)).getSnapshotId());
        Assert.assertEquals((long)s22.getId(), (long)((FileDiff)bar1Diffs.get(1)).getSnapshotId());
        Assert.assertEquals((long)s1.getId(), (long)((FileDiff)bar1Diffs.get(0)).getSnapshotId());
        INodeReference barRef = fsdir.getINode4Write(bar_dir1.toString()).asReference();
        INodeReference.WithCount barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assert.assertEquals((long)5L, (long)barWithCount.getReferenceCount());
        INodeFile bar = barWithCount.asFile();
        List barDiffs = bar.getDiffs().asList();
        Assert.assertEquals((long)4L, (long)barDiffs.size());
        Assert.assertEquals((long)s2222.getId(), (long)((FileDiff)barDiffs.get(3)).getSnapshotId());
        Assert.assertEquals((long)s333.getId(), (long)((FileDiff)barDiffs.get(2)).getSnapshotId());
        Assert.assertEquals((long)s22.getId(), (long)((FileDiff)barDiffs.get(1)).getSnapshotId());
        Assert.assertEquals((long)s1.getId(), (long)((FileDiff)barDiffs.get(0)).getSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.delete(foo_dir1, true);
        hdfs.delete(bar_dir1, true);
        this.restartClusterAndCheckImage(true);
        Path bar1_s1111 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1111", "foo/bar1");
        Path bar_s1111 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1111", "bar");
        Assert.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assert.assertTrue((boolean)hdfs.exists(bar1_s2222));
        Assert.assertFalse((boolean)hdfs.exists(bar1_s1111));
        Assert.assertTrue((boolean)hdfs.exists(bar_s1));
        Assert.assertTrue((boolean)hdfs.exists(bar_s22));
        Assert.assertTrue((boolean)hdfs.exists(bar_s333));
        Assert.assertTrue((boolean)hdfs.exists(bar_s2222));
        Assert.assertFalse((boolean)hdfs.exists(bar_s1111));
        Path foo_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "foo");
        fooRef = fsdir.getINode(foo_s2222.toString()).asReference();
        fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assert.assertEquals((long)4L, (long)fooWithCount.getReferenceCount());
        foo = fooWithCount.asDirectory();
        fooDiffs = foo.getDiffs().asList();
        Assert.assertEquals((long)4L, (long)fooDiffs.size());
        Assert.assertEquals((long)s2222.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(3)).getSnapshotId());
        bar1Diffs = bar1.getDiffs().asList();
        Assert.assertEquals((long)3L, (long)bar1Diffs.size());
        Assert.assertEquals((long)s333.getId(), (long)((FileDiff)bar1Diffs.get(2)).getSnapshotId());
        barRef = fsdir.getINode(bar_s2222.toString()).asReference();
        barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assert.assertEquals((long)4L, (long)barWithCount.getReferenceCount());
        bar = barWithCount.asFile();
        barDiffs = bar.getDiffs().asList();
        Assert.assertEquals((long)4L, (long)barDiffs.size());
        Assert.assertEquals((long)s2222.getId(), (long)((FileDiff)barDiffs.get(3)).getSnapshotId());
    }

    @Test(timeout=60000L)
    public void testRenameFromNonSDir2SDir() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, snap1);
        Path newfoo = new Path(sdir2, "foo");
        hdfs.rename(foo, newfoo);
        INode fooNode = fsdir.getINode4Write(newfoo.toString());
        Assert.assertTrue((boolean)(fooNode instanceof INodeDirectory));
    }

    @Test(timeout=60000L)
    public void testRenameAndUpdateSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(sdir2, "bar");
        hdfs.mkdirs(foo);
        hdfs.mkdirs(bar);
        hdfs.allowSnapshot(foo);
        SnapshotTestHelper.createSnapshot(hdfs, bar, snap1);
        Assert.assertEquals((long)2L, (long)fsn.getSnapshottableDirListing().length);
        INodeDirectory fooNode = fsdir.getINode4Write(foo.toString()).asDirectory();
        long fooId = fooNode.getId();
        try {
            hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.fail((String)("Expect exception since " + bar + " is snapshottable and already has snapshots"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)(bar.toString() + " is snapshottable and already has snapshots"), (Throwable)e);
        }
        hdfs.deleteSnapshot(bar, snap1);
        hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
        SnapshottableDirectoryStatus[] dirs = fsn.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)dirs.length);
        Assert.assertEquals((Object)bar, (Object)dirs[0].getFullPath());
        Assert.assertEquals((long)fooId, (long)dirs[0].getDirStatus().getFileId());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        this.restartClusterAndCheckImage(true);
        Path bar2 = new Path(newfoo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.delete(newfoo, true);
        Path bar2_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar2");
        Assert.assertTrue((boolean)hdfs.exists(bar2_s4));
        Path bar_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar");
        Assert.assertTrue((boolean)hdfs.exists(bar_s4));
        hdfs.deleteSnapshot(sdir1, "s4");
        this.restartClusterAndCheckImage(true);
        Path bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar");
        Assert.assertFalse((boolean)hdfs.exists(bar_s3));
        bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar");
        Assert.assertTrue((boolean)hdfs.exists(bar_s3));
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar2");
        Assert.assertFalse((boolean)hdfs.exists(bar2_s3));
        hdfs.deleteSnapshot(sdir2, "s3");
        Path bar_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assert.assertTrue((boolean)hdfs.exists(bar_s2));
        INodeDirectorySnapshottable sdir2Node = (INodeDirectorySnapshottable)fsdir.getINode(sdir2.toString());
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        INodeReference fooRef = fsdir.getINode(foo_s2.toString()).asReference();
        Assert.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount fooWC = (INodeReference.WithCount)fooRef.getReferredINode();
        Assert.assertEquals((long)1L, (long)fooWC.getReferenceCount());
        INodeDirectory fooDir = fooWC.getReferredINode().asDirectory();
        List diffs = fooDir.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffs.size());
        Assert.assertEquals((long)s2.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)diffs.get(0)).getSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assert.assertFalse((boolean)hdfs.exists(bar_s2));
        this.restartClusterAndCheckImage(true);
        Quota.Counts q = fsdir.getRoot().getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)4L, (long)q.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)0L, (long)q.get((Enum)Quota.DISKSPACE));
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
        q = fsdir.getRoot().getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)3L, (long)q.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)0L, (long)q.get((Enum)Quota.DISKSPACE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAndAppend() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, snap1);
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        INode fooRef = fsdir.getINode4Write(foo2.toString());
        Assert.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
        FSDataOutputStream out = hdfs.append(foo2);
        try {
            byte[] content = new byte[1024];
            new Random().nextBytes(content);
            out.write(content);
            fooRef = fsdir.getINode4Write(foo2.toString());
            Assert.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
            INodeFile fooNode = fooRef.asFile();
            Assert.assertTrue((boolean)fooNode.isWithSnapshot());
            Assert.assertTrue((boolean)fooNode.isUnderConstruction());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        fooRef = fsdir.getINode4Write(foo2.toString());
        Assert.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
        INodeFile fooNode = fooRef.asFile();
        Assert.assertTrue((boolean)fooNode.isWithSnapshot());
        Assert.assertFalse((boolean)fooNode.isUnderConstruction());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameUndo_1() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        Path dir2file = new Path(sdir2, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, dir2file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        INodeDirectory dir2 = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        INodeDirectory mockDir2 = (INodeDirectory)Mockito.spy((Object)dir2);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir2)).addChild((INode)Matchers.anyObject(), Matchers.anyBoolean(), Mockito.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir2, (INode)mockDir2, fsdir.getINodeMap());
        Path newfoo = new Path(sdir2, "foo");
        boolean result = hdfs.rename(foo, newfoo);
        Assert.assertFalse((boolean)result);
        INodeDirectorySnapshottable dir1Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir1.toString());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        ReadOnlyList dir1Children = dir1Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir1Children.size());
        Assert.assertEquals((Object)foo.getName(), (Object)((INode)dir1Children.get(0)).getLocalName());
        List dir1Diffs = dir1Node.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)dir1Diffs.size());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.CREATED).size());
        INode fooNode = fsdir.getINode4Write(foo.toString());
        Assert.assertTrue((fooNode.isDirectory() && fooNode.asDirectory().isWithSnapshot() ? 1 : 0) != 0);
        List fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assert.assertEquals((long)1L, (long)fooDiffs.size());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        INode fooNode_s1 = fsdir.getINode(foo_s1.toString());
        Assert.assertTrue((fooNode_s1 == fooNode ? 1 : 0) != 0);
        Assert.assertFalse((boolean)hdfs.exists(newfoo));
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Assert.assertFalse((boolean)dir2Node.isWithSnapshot());
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir2Children.size());
        Assert.assertEquals((Object)dir2file.getName(), (Object)((INode)dir2Children.get(0)).getLocalName());
    }

    @Test
    public void testRenameUndo_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path dir2file = new Path(sdir2, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, dir2file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        INodeDirectory dir2 = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        INodeDirectory mockDir2 = (INodeDirectory)Mockito.spy((Object)dir2);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir2)).addChild((INode)Matchers.anyObject(), Matchers.anyBoolean(), Mockito.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir2, (INode)mockDir2, fsdir.getINodeMap());
        Path newfoo = new Path(sdir2, "foo");
        boolean result = hdfs.rename(foo, newfoo);
        Assert.assertFalse((boolean)result);
        INodeDirectorySnapshottable dir1Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir1.toString());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        ReadOnlyList dir1Children = dir1Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir1Children.size());
        Assert.assertEquals((Object)foo.getName(), (Object)((INode)dir1Children.get(0)).getLocalName());
        List dir1Diffs = dir1Node.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)dir1Diffs.size());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)1L, (long)childrenDiff.getList(Diff.ListType.CREATED).size());
        INode fooNode = fsdir.getINode4Write(foo.toString());
        Assert.assertTrue((boolean)(fooNode instanceof INodeDirectory));
        Assert.assertTrue((childrenDiff.getList(Diff.ListType.CREATED).get(0) == fooNode ? 1 : 0) != 0);
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        Assert.assertFalse((boolean)hdfs.exists(foo_s1));
        Assert.assertFalse((boolean)hdfs.exists(newfoo));
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Assert.assertFalse((boolean)dir2Node.isWithSnapshot());
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir2Children.size());
        Assert.assertEquals((Object)dir2file.getName(), (Object)((INode)dir2Children.get(0)).getLocalName());
    }

    @Test
    public void testRenameUndo_3() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        INodeDirectory dir3 = fsdir.getINode4Write(sdir3.toString()).asDirectory();
        INodeDirectory mockDir3 = (INodeDirectory)Mockito.spy((Object)dir3);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir3)).addChild((INode)Matchers.anyObject(), Matchers.anyBoolean(), Mockito.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir3, (INode)mockDir3, fsdir.getINodeMap());
        Path foo_dir2 = new Path(sdir2, "foo2");
        Path foo_dir3 = new Path(sdir3, "foo3");
        hdfs.rename(foo, foo_dir2);
        boolean result = hdfs.rename(foo_dir2, foo_dir3);
        Assert.assertFalse((boolean)result);
        INodeDirectorySnapshottable dir1Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir1.toString());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        INodeDirectorySnapshottable dir2Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir2.toString());
        Snapshot s2 = dir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir2Children.size());
        List dir2Diffs = dir2Node.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)dir2Diffs.size());
        Assert.assertEquals((long)s2.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)1L, (long)childrenDiff.getList(Diff.ListType.CREATED).size());
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo2");
        Assert.assertFalse((boolean)hdfs.exists(foo_s2));
        INode fooNode = fsdir.getINode4Write(foo_dir2.toString());
        Assert.assertTrue((childrenDiff.getList(Diff.ListType.CREATED).get(0) == fooNode ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(fooNode instanceof INodeReference.DstReference));
        List fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assert.assertEquals((long)1L, (long)fooDiffs.size());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        hdfs.createSnapshot(sdir2, "s3");
        result = hdfs.rename(foo_dir2, foo_dir3);
        Assert.assertFalse((boolean)result);
        dir2Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir2.toString());
        Snapshot s3 = dir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s3"));
        fooNode = fsdir.getINode4Write(foo_dir2.toString());
        dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)dir2Children.size());
        dir2Diffs = dir2Node.getDiffs().asList();
        Assert.assertEquals((long)2L, (long)dir2Diffs.size());
        Assert.assertEquals((long)s2.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getSnapshotId());
        Assert.assertEquals((long)s3.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(1)).getSnapshotId());
        childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)1L, (long)childrenDiff.getList(Diff.ListType.CREATED).size());
        Assert.assertTrue((childrenDiff.getList(Diff.ListType.CREATED).get(0) == fooNode ? 1 : 0) != 0);
        childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(1)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)0L, (long)childrenDiff.getList(Diff.ListType.CREATED).size());
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo2");
        Assert.assertFalse((boolean)hdfs.exists(foo_s2));
        Assert.assertTrue((boolean)hdfs.exists(foo_s3));
        Assert.assertTrue((boolean)(fooNode instanceof INodeReference.DstReference));
        fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assert.assertEquals((long)2L, (long)fooDiffs.size());
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        Assert.assertEquals((long)s3.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(1)).getSnapshotId());
    }

    @Test
    public void testRenameUndo_4() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        Path foo2 = new Path(sdir2, "foo2");
        hdfs.mkdirs(foo2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo3 = new Path(sdir3, "foo3");
        hdfs.rename(foo2, foo3);
        INode foo3Node = fsdir.getINode4Write(foo3.toString());
        Assert.assertTrue((boolean)foo3Node.isReference());
        INodeDirectory dir3 = fsdir.getINode4Write(sdir3.toString()).asDirectory();
        INodeDirectory mockDir3 = (INodeDirectory)Mockito.spy((Object)dir3);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir3)).addChild((INode)Mockito.isNull(), Matchers.anyBoolean(), Mockito.anyInt());
        Mockito.when((Object)mockDir3.addChild((INode)Mockito.isNotNull(), Matchers.anyBoolean(), Mockito.anyInt())).thenReturn((Object)false).thenCallRealMethod();
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir3, (INode)mockDir3, fsdir.getINodeMap());
        foo3Node.setParent(mockDir3);
        try {
            hdfs.rename(foo, foo3, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.fail((String)("the rename from " + foo + " to " + foo3 + " should fail"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("rename from " + foo + " to " + foo3 + " failed."), (Throwable)e);
        }
        INode foo3Node_undo = fsdir.getINode4Write(foo3.toString());
        Assert.assertSame((Object)foo3Node, (Object)foo3Node_undo);
        INodeReference.WithCount foo3_wc = (INodeReference.WithCount)foo3Node.asReference().getReferredINode();
        Assert.assertEquals((long)2L, (long)foo3_wc.getReferenceCount());
        Assert.assertSame((Object)foo3Node, (Object)foo3_wc.getParentReference());
    }

    @Test
    public void testRenameUndo_5() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path subdir2 = new Path(dir2, "subdir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(subdir2);
        Path foo = new Path(dir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 5L, 0x7FFFFFFFFFFFFFFEL);
        Path foo2 = new Path(subdir2, foo.getName());
        boolean rename = hdfs.rename(foo, foo2);
        Assert.assertFalse((boolean)rename);
        Assert.assertTrue((boolean)hdfs.exists(foo));
        Assert.assertTrue((boolean)hdfs.exists(bar));
        INodeDirectory dir1Node = fsdir.getINode4Write(dir1.toString()).asDirectory();
        List childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir1Node.getChildrenList(0x7FFFFFFE));
        Assert.assertEquals((long)1L, (long)childrenList.size());
        INode fooNode = (INode)childrenList.get(0);
        Assert.assertTrue((boolean)fooNode.asDirectory().isWithSnapshot());
        INode barNode = fsdir.getINode4Write(bar.toString());
        Assert.assertTrue((barNode.getClass() == INodeFile.class ? 1 : 0) != 0);
        Assert.assertSame((Object)fooNode, (Object)barNode.getParent());
        List diffList = ((INodeDirectorySnapshottable)dir1Node).getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.CREATED).isEmpty());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.DELETED).isEmpty());
        INode dir2Node = fsdir.getINode4Write(dir2.toString());
        Assert.assertTrue((dir2Node.getClass() == INodeDirectorySnapshottable.class ? 1 : 0) != 0);
        Quota.Counts counts = dir2Node.computeQuotaUsage();
        Assert.assertEquals((long)3L, (long)counts.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)0L, (long)counts.get((Enum)Quota.DISKSPACE));
        childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir2Node.asDirectory().getChildrenList(0x7FFFFFFE));
        Assert.assertEquals((long)1L, (long)childrenList.size());
        INode subdir2Node = (INode)childrenList.get(0);
        Assert.assertSame((Object)dir2Node, (Object)subdir2Node.getParent());
        Assert.assertSame((Object)subdir2Node, (Object)fsdir.getINode4Write(subdir2.toString()));
        diffList = ((INodeDirectorySnapshottable)dir2Node).getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.CREATED).isEmpty());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.DELETED).isEmpty());
    }

    @Test
    public void testRenameUndo_6() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path sub_dir2 = new Path(dir2, "subdir");
        Path subsub_dir2 = new Path(sub_dir2, "subdir");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(subsub_dir2);
        Path foo = new Path(dir1, "foo");
        hdfs.mkdirs(foo);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 4L, 0x7FFFFFFFFFFFFFFEL);
        try {
            hdfs.rename(foo, subsub_dir2, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.fail((String)"Expect QuotaExceedException");
        }
        catch (QuotaExceededException e) {
            String msg = "Failed to record modification for snapshot: The NameSpace quota (directories and files) is exceeded: quota=4 file count=5";
            GenericTestUtils.assertExceptionContains((String)msg, (Throwable)e);
        }
        Assert.assertTrue((boolean)hdfs.exists(foo));
        INodeDirectory dir1Node = fsdir.getINode4Write(dir1.toString()).asDirectory();
        List childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir1Node.getChildrenList(0x7FFFFFFE));
        Assert.assertEquals((long)1L, (long)childrenList.size());
        INode fooNode = (INode)childrenList.get(0);
        Assert.assertTrue((boolean)fooNode.asDirectory().isWithSnapshot());
        Assert.assertSame((Object)dir1Node, (Object)fooNode.getParent());
        List diffList = ((INodeDirectorySnapshottable)dir1Node).getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.CREATED).isEmpty());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.DELETED).isEmpty());
        INode dir2Node = fsdir.getINode4Write(dir2.toString());
        Assert.assertTrue((dir2Node.getClass() == INodeDirectorySnapshottable.class ? 1 : 0) != 0);
        Quota.Counts counts = dir2Node.computeQuotaUsage();
        Assert.assertEquals((long)4L, (long)counts.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)0L, (long)counts.get((Enum)Quota.DISKSPACE));
        childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir2Node.asDirectory().getChildrenList(0x7FFFFFFE));
        Assert.assertEquals((long)1L, (long)childrenList.size());
        INode subdir2Node = (INode)childrenList.get(0);
        Assert.assertTrue((boolean)subdir2Node.asDirectory().isWithSnapshot());
        Assert.assertSame((Object)dir2Node, (Object)subdir2Node.getParent());
        Assert.assertSame((Object)subdir2Node, (Object)fsdir.getINode4Write(sub_dir2.toString()));
        INode subsubdir2Node = fsdir.getINode4Write(subsub_dir2.toString());
        Assert.assertTrue((subsubdir2Node.getClass() == INodeDirectory.class ? 1 : 0) != 0);
        Assert.assertSame((Object)subdir2Node, (Object)subsubdir2Node.getParent());
        diffList = ((INodeDirectorySnapshottable)dir2Node).getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.CREATED).isEmpty());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.DELETED).isEmpty());
        diffList = subdir2Node.asDirectory().getDiffs().asList();
        Assert.assertEquals((long)0L, (long)diffList.size());
    }

    @Test
    public void testRenameUndo_7() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        Path invalid = new Path(foo, ".snapshot");
        try {
            hdfs.rename(bar, invalid);
            Assert.fail((String)"expect exception since invalid name is used for rename");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"\".snapshot\" is a reserved name", (Throwable)e);
        }
        INodeDirectorySnapshottable rootNode = (INodeDirectorySnapshottable)fsdir.getINode4Write(root.toString());
        INodeDirectory fooNode = fsdir.getINode4Write(foo.toString()).asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)children.size());
        List diffList = fooNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Snapshot s1 = rootNode.getSnapshot(DFSUtil.string2Bytes((String)snap1));
        Assert.assertEquals((long)s1.getId(), (long)diff.getSnapshotId());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.DELETED).isEmpty());
        Assert.assertTrue((boolean)diff.getChildrenDiff().getList(Diff.ListType.CREATED).isEmpty());
        INodeFile barNode = fsdir.getINode4Write(bar.toString()).asFile();
        Assert.assertSame((Object)barNode, (Object)children.get(0));
        Assert.assertSame((Object)fooNode, (Object)barNode.getParent());
        List barDiffList = barNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)barDiffList.size());
        FileDiff barDiff = (FileDiff)barDiffList.get(0);
        Assert.assertEquals((long)s1.getId(), (long)barDiff.getSnapshotId());
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameExceedQuota() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path sub_dir2 = new Path(dir2, "subdir");
        Path subfile_dir2 = new Path(sub_dir2, "subfile");
        hdfs.mkdirs(dir1);
        DFSTestUtil.createFile((FileSystem)hdfs, subfile_dir2, 1024L, (short)3, 0L);
        Path foo = new Path(dir1, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 5L, 0x7FFFFFFFFFFFFFFEL);
        hdfs.rename(foo, subfile_dir2, new Options.Rename[]{Options.Rename.OVERWRITE});
        INode dir2Node = fsdir.getINode4Write(dir2.toString());
        Assert.assertTrue((dir2Node.getClass() == INodeDirectorySnapshottable.class ? 1 : 0) != 0);
        Quota.Counts counts = dir2Node.computeQuotaUsage();
        Assert.assertEquals((long)7L, (long)counts.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)6144L, (long)counts.get((Enum)Quota.DISKSPACE));
    }

    @Test
    public void testRename2PreDescendant() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, snap1);
        Path bar2 = new Path(sdir2, "bar");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, snap1);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRename2PreDescendant_2() throws Exception {
        Path root = new Path("/");
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        Path file1InBar = new Path(bar, "file1");
        Path file2InBar = new Path(bar, "file2");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        DFSTestUtil.createFile((FileSystem)hdfs, file1InBar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2InBar, 1024L, (short)3, 0L);
        hdfs.setQuota(sdir1, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(sdir2, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(bar, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        hdfs.delete(file1InBar, true);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap2);
        hdfs.delete(file2InBar, true);
        Path bar2 = new Path(sdir2, "bar2");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo2");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(root, snap2);
        this.restartClusterAndCheckImage(false);
    }

    @Test
    public void testRename2PreDescendant_3() throws Exception {
        Path root = new Path("/");
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        Path fileInBar = new Path(bar, "file");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        DFSTestUtil.createFile((FileSystem)hdfs, fileInBar, 1024L, (short)3, 0L);
        hdfs.setQuota(sdir1, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(sdir2, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(bar, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        hdfs.delete(fileInBar, true);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap2);
        Path bar2 = new Path(sdir2, "bar2");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo2");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(root, snap1);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_3() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(foo2, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        Path bar3 = new Path(foo2, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, bar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir2, "s3");
        hdfs.delete(foo2, true);
        hdfs.deleteSnapshot(sdir2, "s3");
        INodeDirectorySnapshottable dir1Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir1.toString());
        Quota.Counts q1 = dir1Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)4L, (long)q1.get((Enum)Quota.NAMESPACE));
        INodeDirectorySnapshottable dir2Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir2.toString());
        Quota.Counts q2 = dir2Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)2L, (long)q2.get((Enum)Quota.NAMESPACE));
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", foo.getName());
        INode fooRef = fsdir.getINode(foo_s1.toString());
        Assert.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount wc = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assert.assertEquals((long)1L, (long)wc.getReferenceCount());
        INodeDirectory fooNode = wc.getReferredINode().asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)bar.getName(), (Object)((INode)children.get(0)).getLocalName());
        List diffList = fooNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff diff = ((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getChildrenDiff();
        Assert.assertEquals((long)0L, (long)diff.getList(Diff.ListType.CREATED).size());
        Assert.assertEquals((long)0L, (long)diff.getList(Diff.ListType.DELETED).size());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_4() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(foo2, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        Path bar3 = new Path(foo2, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, bar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir2, "s3");
        hdfs.rename(foo2, foo);
        hdfs.deleteSnapshot(sdir2, "s3");
        INodeDirectorySnapshottable dir1Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir1.toString());
        Quota.Counts q1 = dir1Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)9L, (long)q1.get((Enum)Quota.NAMESPACE));
        INodeDirectorySnapshottable dir2Node = (INodeDirectorySnapshottable)fsdir.getINode4Write(sdir2.toString());
        Quota.Counts q2 = dir2Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)2L, (long)q2.get((Enum)Quota.NAMESPACE));
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", foo.getName());
        INode fooRef = fsdir.getINode(foo_s1.toString());
        Assert.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount wc = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assert.assertEquals((long)2L, (long)wc.getReferenceCount());
        INodeDirectory fooNode = wc.getReferredINode().asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)bar.getName(), (Object)((INode)children.get(0)).getLocalName());
        Assert.assertEquals((Object)bar2.getName(), (Object)((INode)children.get(1)).getLocalName());
        Assert.assertEquals((Object)bar3.getName(), (Object)((INode)children.get(2)).getLocalName());
        List diffList = fooNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff diff = ((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getChildrenDiff();
        Assert.assertEquals((long)2L, (long)diff.getList(Diff.ListType.CREATED).size());
        Assert.assertEquals((long)0L, (long)diff.getList(Diff.ListType.DELETED).size());
        INode fooRef2 = fsdir.getINode4Write(foo.toString());
        Assert.assertTrue((boolean)(fooRef2 instanceof INodeReference.DstReference));
        INodeReference.WithCount wc2 = (INodeReference.WithCount)fooRef2.asReference().getReferredINode();
        Assert.assertSame((Object)wc, (Object)wc2);
        Assert.assertSame((Object)fooRef2, (Object)wc.getParentReference());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_5() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        Path dir3 = new Path("/dir3");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        hdfs.mkdirs(dir3);
        Path foo = new Path(dir1, "foo");
        hdfs.mkdirs(foo);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.deleteSnapshot(dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        Path foo2 = new Path(dir2, foo.getName());
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(dir2, "foo/bar");
        Path bar3 = new Path(dir3, "bar");
        hdfs.rename(bar2, bar3);
        hdfs.delete(foo2, true);
        Assert.assertTrue((boolean)hdfs.exists(bar3));
        INodeFile barNode = (INodeFile)fsdir.getINode4Write(bar3.toString());
        Assert.assertSame((Object)fsdir.getINode4Write(dir3.toString()), (Object)barNode.getParent());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_6() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(foo, "bar");
        Path file = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        hdfs.delete(file, true);
        Path newfoo = new Path(dir1, foo.getName());
        hdfs.rename(foo, newfoo);
        Path foo_s0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "dir2/foo");
        Assert.assertTrue((String)("the snapshot path " + foo_s0 + " should exist"), (boolean)hdfs.exists(foo_s0));
        hdfs.deleteSnapshot(test, "s0");
        Assert.assertFalse((String)("after deleting s0, " + foo_s0 + " should not exist"), (boolean)hdfs.exists(foo_s0));
        INodeDirectory dir2Node = fsdir.getINode4Write(dir2.toString()).asDirectory();
        Assert.assertTrue((String)("the diff list of " + dir2 + " should be empty after deleting s0"), (boolean)dir2Node.getDiffs().asList().isEmpty());
        Assert.assertTrue((boolean)hdfs.exists(newfoo));
        INode fooRefNode = fsdir.getINode4Write(newfoo.toString());
        Assert.assertTrue((boolean)(fooRefNode instanceof INodeReference.DstReference));
        INodeDirectory fooNode = fooRefNode.asDirectory();
        Assert.assertTrue((boolean)fooNode.isWithSnapshot());
        Assert.assertTrue((boolean)fooNode.getDiffs().asList().isEmpty());
        INodeDirectory barNode = ((INode)fooNode.getChildrenList(0x7FFFFFFE).get(0)).asDirectory();
        Assert.assertTrue((boolean)barNode.getDiffs().asList().isEmpty());
        Assert.assertTrue((boolean)barNode.getChildrenList(0x7FFFFFFE).isEmpty());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_7() throws Exception {
        fsn.getSnapshotManager().setAllowNestedSnapshots(true);
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(foo, "bar");
        Path file = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        SnapshotTestHelper.createSnapshot(hdfs, test, "s1");
        hdfs.delete(file, true);
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        Path newfoo = new Path(dir1, foo.getName());
        hdfs.rename(foo, newfoo);
        hdfs.deleteSnapshot(test, "s1");
        Path file_s2 = SnapshotTestHelper.getSnapshotPath(dir2, "s2", "foo/bar/file");
        Assert.assertFalse((boolean)hdfs.exists(file_s2));
        Path file_s0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "dir2/foo/bar/file");
        Assert.assertTrue((boolean)hdfs.exists(file_s0));
        INodeDirectory dir1Node = fsdir.getINode4Write(dir1.toString()).asDirectory();
        List dir1DiffList = dir1Node.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)dir1DiffList.size());
        List dList = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1DiffList.get(0)).getChildrenDiff().getList(Diff.ListType.DELETED);
        Assert.assertTrue((boolean)dList.isEmpty());
        List cList = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1DiffList.get(0)).getChildrenDiff().getList(Diff.ListType.CREATED);
        Assert.assertEquals((long)1L, (long)cList.size());
        INode cNode = (INode)cList.get(0);
        INode fooNode = fsdir.getINode4Write(newfoo.toString());
        Assert.assertSame((Object)cNode, (Object)fooNode);
        Path newbar = new Path(newfoo, bar.getName());
        INodeDirectory barNode = fsdir.getINode4Write(newbar.toString()).asDirectory();
        Assert.assertSame((Object)fooNode.asDirectory(), (Object)barNode.getParent());
        List barDiffList = barNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)barDiffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)barDiffList.get(0);
        INodeDirectorySnapshottable testNode = (INodeDirectorySnapshottable)fsdir.getINode4Write(test.toString());
        Snapshot s0 = testNode.getSnapshot(DFSUtil.string2Bytes((String)"s0"));
        Assert.assertEquals((long)s0.getId(), (long)diff.getSnapshotId());
        Assert.assertEquals((Object)"file", (Object)((INode)diff.getChildrenDiff().getList(Diff.ListType.DELETED).get(0)).getLocalName());
        INodeDirectory dir2Node = fsdir.getINode4Write(dir2.toString()).asDirectory();
        List dir2DiffList = dir2Node.getDiffs().asList();
        Assert.assertEquals((long)2L, (long)dir2DiffList.size());
        dList = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2DiffList.get(1)).getChildrenDiff().getList(Diff.ListType.DELETED);
        Assert.assertEquals((long)1L, (long)dList.size());
        cList = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2DiffList.get(0)).getChildrenDiff().getList(Diff.ListType.CREATED);
        Assert.assertTrue((boolean)cList.isEmpty());
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(dir2, "s2", foo.getName());
        INodeReference.WithName fooNode_s2 = (INodeReference.WithName)fsdir.getINode(foo_s2.toString());
        Assert.assertSame(dList.get(0), (Object)fooNode_s2);
        Assert.assertSame((Object)fooNode.asReference().getReferredINode(), (Object)fooNode_s2.getReferredINode());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testCleanDstReference() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(bar);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path fileInBar = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, fileInBar, 1024L, (short)3, 0L);
        Path foo2 = new Path(test, "foo2");
        hdfs.rename(foo, foo2);
        hdfs.createSnapshot(test, "s1");
        hdfs.delete(new Path(foo2, "bar"), true);
        hdfs.delete(foo2, true);
        Path sfileInBar = SnapshotTestHelper.getSnapshotPath(test, "s1", "foo2/bar/file");
        Assert.assertTrue((boolean)hdfs.exists(sfileInBar));
        hdfs.deleteSnapshot(test, "s1");
        Assert.assertFalse((boolean)hdfs.exists(sfileInBar));
        this.restartClusterAndCheckImage(true);
        Path barInS0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "foo/bar");
        INodeDirectory barNode = fsdir.getINode(barInS0.toString()).asDirectory();
        Assert.assertEquals((long)0L, (long)barNode.getChildrenList(0x7FFFFFFE).size());
        List diffList = barNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assert.assertEquals((long)0L, (long)diff.getChildrenDiff().getList(Diff.ListType.DELETED).size());
        Assert.assertEquals((long)0L, (long)diff.getChildrenDiff().getList(Diff.ListType.CREATED).size());
    }

    @Test
    public void testRenameUCFileInSnapshot() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(foo);
        hdfs.create(bar);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path bar2 = new Path(foo, "bar2");
        hdfs.rename(bar, bar2);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testAppendFileAfterRenameInSnapshot() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path bar2 = new Path(foo, "bar2");
        hdfs.rename(bar, bar2);
        FSDataOutputStream out = hdfs.append(bar2);
        out.writeByte(0);
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        this.restartClusterAndCheckImage(true);
    }

    static {
        testDir = System.getProperty("test.build.data", "build/test/data");
        dir = new Path("/testRenameWithSnapshots");
        sub1 = new Path(dir, "sub1");
        file1 = new Path(sub1, "file1");
        file2 = new Path(sub1, "file2");
        file3 = new Path(sub1, "file3");
    }
}

