/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;

public class ContainerSimulator
implements Delayed {
    private ContainerId id;
    private Resource resource;
    private long endTime;
    private long lifeTime;
    private String hostname;
    private int priority;
    private String type;

    public ContainerSimulator(Resource resource, long lifeTime, String hostname, int priority, String type) {
        this.resource = resource;
        this.lifeTime = lifeTime;
        this.hostname = hostname;
        this.priority = priority;
        this.type = type;
    }

    public ContainerSimulator(ContainerId id, Resource resource, long endTime, long lifeTime) {
        this.id = id;
        this.resource = resource;
        this.endTime = endTime;
        this.lifeTime = lifeTime;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ContainerId getId() {
        return this.id;
    }

    @Override
    public int compareTo(Delayed o) {
        if (!(o instanceof ContainerSimulator)) {
            throw new IllegalArgumentException("Parameter must be a ContainerSimulator instance");
        }
        ContainerSimulator other = (ContainerSimulator)o;
        return (int)Math.signum(this.endTime - other.endTime);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getType() {
        return this.type;
    }

    public void setPriority(int p) {
        this.priority = p;
    }
}

