/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.kms.server.EagerKeyGeneratorKeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@InterfaceAudience.Private
public class KMSWebApp
implements ServletContextListener {
    private static final String LOG4J_PROPERTIES = "kms-log4j.properties";
    private static final String METRICS_PREFIX = "hadoop.kms.";
    private static final String ADMIN_CALLS_METER = "hadoop.kms.admin.calls.meter";
    private static final String KEY_CALLS_METER = "hadoop.kms.key.calls.meter";
    private static final String INVALID_CALLS_METER = "hadoop.kms.invalid.calls.meter";
    private static final String UNAUTHORIZED_CALLS_METER = "hadoop.kms.unauthorized.calls.meter";
    private static final String UNAUTHENTICATED_CALLS_METER = "hadoop.kms.unauthenticated.calls.meter";
    private static final String GENERATE_EEK_METER = "hadoop.kms.generate_eek.calls.meter";
    private static final String DECRYPT_EEK_METER = "hadoop.kms.decrypt_eek.calls.meter";
    private static Logger LOG;
    private static MetricRegistry metricRegistry;
    private JmxReporter jmxReporter;
    private static Configuration kmsConf;
    private static KMSACLs kmsAcls;
    private static Meter adminCallsMeter;
    private static Meter keyCallsMeter;
    private static Meter unauthorizedCallsMeter;
    private static Meter unauthenticatedCallsMeter;
    private static Meter decryptEEKCallsMeter;
    private static Meter generateEEKCallsMeter;
    private static Meter invalidCallsMeter;
    private static KMSAudit kmsAudit;
    private static KeyProviderCryptoExtension keyProviderCryptoExtension;

    private void initLogging(String confDir) {
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.defaultInitOverride", "true");
            boolean fromClasspath = true;
            File log4jConf = new File(confDir, LOG4J_PROPERTIES).getAbsoluteFile();
            if (log4jConf.exists()) {
                PropertyConfigurator.configureAndWatch((String)log4jConf.getPath(), (long)1000L);
                fromClasspath = false;
            } else {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL log4jUrl = cl.getResource(LOG4J_PROPERTIES);
                if (log4jUrl != null) {
                    PropertyConfigurator.configure((URL)log4jUrl);
                }
            }
            LOG = LoggerFactory.getLogger(KMSWebApp.class);
            LOG.debug("KMS log starting");
            if (fromClasspath) {
                LOG.warn("Log4j configuration file '{}' not found", (Object)LOG4J_PROPERTIES);
                LOG.warn("Logging with INFO level to standard output");
            }
        } else {
            LOG = LoggerFactory.getLogger(KMSWebApp.class);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            String confDir = System.getProperty("kms.config.dir");
            if (confDir == null) {
                throw new RuntimeException("System property 'kms.config.dir' not defined");
            }
            kmsConf = KMSConfiguration.getKMSConf();
            this.initLogging(confDir);
            LOG.info("-------------------------------------------------------------");
            LOG.info("  Java runtime version : {}", (Object)System.getProperty("java.runtime.version"));
            LOG.info("  KMS Hadoop Version: " + VersionInfo.getVersion());
            LOG.info("-------------------------------------------------------------");
            kmsAcls = new KMSACLs();
            kmsAcls.startReloader();
            metricRegistry = new MetricRegistry();
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
            this.jmxReporter.start();
            generateEEKCallsMeter = (Meter)metricRegistry.register(GENERATE_EEK_METER, (Metric)new Meter());
            decryptEEKCallsMeter = (Meter)metricRegistry.register(DECRYPT_EEK_METER, (Metric)new Meter());
            adminCallsMeter = (Meter)metricRegistry.register(ADMIN_CALLS_METER, (Metric)new Meter());
            keyCallsMeter = (Meter)metricRegistry.register(KEY_CALLS_METER, (Metric)new Meter());
            invalidCallsMeter = (Meter)metricRegistry.register(INVALID_CALLS_METER, (Metric)new Meter());
            unauthorizedCallsMeter = (Meter)metricRegistry.register(UNAUTHORIZED_CALLS_METER, (Metric)new Meter());
            unauthenticatedCallsMeter = (Meter)metricRegistry.register(UNAUTHENTICATED_CALLS_METER, (Metric)new Meter());
            kmsAudit = new KMSAudit(kmsConf.getLong("hadoop.kms.audit.aggregation.window.ms", 10000L));
            sce.getServletContext().setAttribute("hadoop.conf", (Object)kmsConf);
            sce.getServletContext().setAttribute("admins.acl", (Object)new AccessControlList("*"));
            String providerString = kmsConf.get("hadoop.kms.key.provider.uri");
            if (providerString == null) {
                throw new IllegalStateException("No KeyProvider has been defined");
            }
            KeyProvider keyProvider = KeyProviderFactory.get((URI)new URI(providerString), (Configuration)kmsConf);
            if (kmsConf.getBoolean("hadoop.kms.cache.enable", true)) {
                long keyTimeOutMillis = kmsConf.getLong("hadoop.kms.cache.timeout.ms", 600000L);
                long currKeyTimeOutMillis = kmsConf.getLong("hadoop.kms.current.key.cache.timeout.ms", 30000L);
                keyProvider = new CachingKeyProvider(keyProvider, keyTimeOutMillis, currKeyTimeOutMillis);
            }
            LOG.info("Initialized KeyProvider " + keyProvider);
            keyProviderCryptoExtension = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
            keyProviderCryptoExtension = new EagerKeyGeneratorKeyProviderCryptoExtension(kmsConf, keyProviderCryptoExtension);
            if (kmsConf.getBoolean("hadoop.kms.key.authorization.enable", true)) {
                keyProviderCryptoExtension = new KeyAuthorizationKeyProvider(keyProviderCryptoExtension, kmsAcls);
            }
            LOG.info("Initialized KeyProviderCryptoExtension " + keyProviderCryptoExtension);
            int defaultBitlength = kmsConf.getInt("hadoop.security.key.default.bitlength", 128);
            LOG.info("Default key bitlength is {}", (Object)defaultBitlength);
            LOG.info("KMS Started");
        }
        catch (Throwable ex) {
            System.out.println();
            System.out.println("ERROR: Hadoop KMS could not be started");
            System.out.println();
            System.out.println("REASON: " + ex.toString());
            System.out.println();
            System.out.println("Stacktrace:");
            System.out.println("---------------------------------------------------");
            ex.printStackTrace(System.out);
            System.out.println("---------------------------------------------------");
            System.out.println();
            System.exit(1);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        kmsAudit.shutdown();
        kmsAcls.stopReloader();
        this.jmxReporter.stop();
        this.jmxReporter.close();
        metricRegistry = null;
        LOG.info("KMS Stopped");
    }

    public static Configuration getConfiguration() {
        return new Configuration(kmsConf);
    }

    public static KMSACLs getACLs() {
        return kmsAcls;
    }

    public static Meter getAdminCallsMeter() {
        return adminCallsMeter;
    }

    public static Meter getKeyCallsMeter() {
        return keyCallsMeter;
    }

    public static Meter getInvalidCallsMeter() {
        return invalidCallsMeter;
    }

    public static Meter getGenerateEEKCallsMeter() {
        return generateEEKCallsMeter;
    }

    public static Meter getDecryptEEKCallsMeter() {
        return decryptEEKCallsMeter;
    }

    public static Meter getUnauthorizedCallsMeter() {
        return unauthorizedCallsMeter;
    }

    public static Meter getUnauthenticatedCallsMeter() {
        return unauthenticatedCallsMeter;
    }

    public static KeyProviderCryptoExtension getKeyProvider() {
        return keyProviderCryptoExtension;
    }

    public static KMSAudit getKMSAudit() {
        return kmsAudit;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

