/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.ErrorTxn;
import org.junit.Assert;
import org.junit.Test;

public class PrepRequestProcessorTest
extends ClientBase {
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;

    @Test
    public void testPRequest() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        zks.sessionTracker = new MySessionTracker();
        PrepRequestProcessor processor = new PrepRequestProcessor(zks, (RequestProcessor)new MyRequestProcessor());
        Request foo = new Request(null, 1L, 1, 1, ByteBuffer.allocate(3), null);
        processor.pRequest(foo);
    }

    private class MySessionTracker
    implements SessionTracker {
        private MySessionTracker() {
        }

        public void addSession(long id, int to) {
        }

        public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        public long createSession(int sessionTimeout) {
            return 0L;
        }

        public void dumpSessions(PrintWriter pwriter) {
        }

        public void removeSession(long sessionId) {
        }

        public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        }

        public void shutdown() {
        }

        public boolean touchSession(long sessionId, int sessionTimeout) {
            return false;
        }

        public void setSessionClosing(long sessionId) {
        }
    }

    private class MyRequestProcessor
    implements RequestProcessor {
        private MyRequestProcessor() {
        }

        public void processRequest(Request request) {
            Assert.assertEquals((String)"Request should have marshalling error", (Object)new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()), (Object)request.txn);
        }

        public void shutdown() {
        }
    }
}

