/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@InterfaceStability.Unstable
public class Resources {
    private static final Resource NONE = new Resource(){

        public int getMemory() {
            return 0;
        }

        public void setMemory(int memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int getVirtualCores() {
            return 0;
        }

        public void setVirtualCores(int cores) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public double getDisks() {
            return 0.0;
        }

        public void setDisks(double disks) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int compareTo(Resource o) {
            int diff = 0 - o.getMemory();
            if (diff == 0 && (diff = 0 - o.getVirtualCores()) == 0) {
                diff = Resource.getAbsIntValue((double)(0.0 - o.getDisks()));
            }
            return diff;
        }
    };
    private static final Resource UNBOUNDED = new Resource(){

        public int getMemory() {
            return Integer.MAX_VALUE;
        }

        public void setMemory(int memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int getVirtualCores() {
            return Integer.MAX_VALUE;
        }

        public void setVirtualCores(int cores) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public double getDisks() {
            return 2.147483647E9;
        }

        public void setDisks(double disks) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int compareTo(Resource o) {
            int diff = 0 - o.getMemory();
            if (diff == 0 && (diff = 0 - o.getVirtualCores()) == 0) {
                diff = Resource.getAbsIntValue((double)(0 - o.getVirtualCores()));
            }
            return diff;
        }
    };

    public static Resource createResource(int memory) {
        return Resources.createResource(memory, memory > 0 ? 1 : 0);
    }

    public static Resource createResource(int memory, int cores) {
        return Resources.createResource(memory, cores, 0.0);
    }

    public static Resource createResource(int memory, int cores, double disks) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(memory);
        resource.setVirtualCores(cores);
        resource.setDisks(disks);
        return resource;
    }

    public static Resource none() {
        return NONE;
    }

    public static Resource unbounded() {
        return UNBOUNDED;
    }

    public static Resource clone(Resource res) {
        return Resources.createResource(res.getMemory(), res.getVirtualCores(), res.getDisks());
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() + rhs.getMemory());
        lhs.setVirtualCores(lhs.getVirtualCores() + rhs.getVirtualCores());
        lhs.setDisks(lhs.getDisks() + rhs.getDisks());
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() - rhs.getMemory());
        lhs.setVirtualCores(lhs.getVirtualCores() - rhs.getVirtualCores());
        lhs.setDisks(lhs.getDisks() - rhs.getDisks());
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom(Resources.clone(lhs), rhs);
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract(NONE, resource);
    }

    public static Resource multiplyTo(Resource lhs, double by) {
        lhs.setMemory((int)((double)lhs.getMemory() * by));
        lhs.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        lhs.setDisks(lhs.getDisks() * by);
        return lhs;
    }

    public static Resource multiply(Resource lhs, double by) {
        return Resources.multiplyTo(Resources.clone(lhs), by);
    }

    public static Resource multiplyAndNormalizeUp(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeUp(lhs, by, factor);
    }

    public static Resource multiplyAndNormalizeDown(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeDown(lhs, by, factor);
    }

    public static Resource multiplyAndRoundDown(Resource lhs, double by) {
        Resource out = Resources.clone(lhs);
        out.setMemory((int)((double)lhs.getMemory() * by));
        out.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        out.setDisks(lhs.getDisks() * by);
        return out;
    }

    public static Resource normalize(ResourceCalculator calculator, Resource lhs, Resource min, Resource max, Resource increment) {
        return calculator.normalize(lhs, min, max, increment);
    }

    public static Resource roundUp(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundUp(lhs, factor);
    }

    public static Resource roundDown(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundDown(lhs, factor);
    }

    public static boolean isInvalidDivisor(ResourceCalculator resourceCalculator, Resource divisor) {
        return resourceCalculator.isInvalidDivisor(divisor);
    }

    public static float ratio(ResourceCalculator resourceCalculator, Resource lhs, Resource rhs) {
        return resourceCalculator.ratio(lhs, rhs);
    }

    public static float divide(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.divide(clusterResource, lhs, rhs);
    }

    public static Resource divideAndCeil(ResourceCalculator resourceCalculator, Resource lhs, int rhs) {
        return resourceCalculator.divideAndCeil(lhs, rhs);
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.equals((Object)rhs);
    }

    public static boolean lessThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) < 0;
    }

    public static boolean lessThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0;
    }

    public static boolean greaterThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) > 0;
    }

    public static boolean greaterThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0;
    }

    public static Resource min(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0 ? lhs : rhs;
    }

    public static Resource max(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0 ? lhs : rhs;
    }

    public static boolean fitsIn(Resource smaller, Resource bigger) {
        return smaller.getMemory() <= bigger.getMemory() && smaller.getVirtualCores() <= bigger.getVirtualCores() && smaller.getDisks() <= bigger.getDisks();
    }

    public static Resource componentwiseMin(Resource lhs, Resource rhs) {
        return Resources.createResource(Math.min(lhs.getMemory(), rhs.getMemory()), Math.min(lhs.getVirtualCores(), rhs.getVirtualCores()), Math.min(lhs.getDisks(), rhs.getDisks()));
    }

    public static Resource componentwiseMax(Resource lhs, Resource rhs) {
        return Resources.createResource(Math.max(lhs.getMemory(), rhs.getMemory()), Math.max(lhs.getVirtualCores(), rhs.getVirtualCores()));
    }
}

