/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.MultiTxn;
import org.apache.zookeeper.txn.Txn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFromLogTest
extends ZKTestCase
implements Watcher {
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int NUM_MESSAGES = 300;
    protected static final Logger LOG = LoggerFactory.getLogger(LoadFromLogTest.class);
    private static final int TRANSACTION_OVERHEAD = 2;
    private static final int TOTAL_TRANSACTIONS = 302;
    private volatile boolean connected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoad() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);
        try {
            for (int i = 0; i < 300; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        File logDir = new File(tmpDir, "version-2");
        FileTxnLog txnLog = new FileTxnLog(logDir);
        TxnLog.TxnIterator itr = txnLog.read(0L);
        long expectedZxid = 0L;
        long lastZxid = 0L;
        do {
            TxnHeader hdr = itr.getHeader();
            Assert.assertTrue((String)("not the same transaction. lastZxid=" + lastZxid + ", zxid=" + hdr.getZxid()), (lastZxid != hdr.getZxid() ? 1 : 0) != 0);
            Assert.assertTrue((String)("excepting next transaction. expected=" + ++expectedZxid + ", retreived=" + hdr.getZxid()), (hdr.getZxid() == expectedZxid ? 1 : 0) != 0);
            lastZxid = hdr.getZxid();
        } while (itr.next());
        Assert.assertTrue((String)("processed all transactions. " + expectedZxid + " == " + 302), (expectedZxid == 302L ? 1 : 0) != 0);
    }

    public void process(WatchedEvent event) {
        block0 : switch (event.getType()) {
            case None: {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.connected = true;
                        break block0;
                    }
                    case Disconnected: {
                        this.connected = false;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Test
    public void testTxnFailure() throws Exception {
        long count = 1L;
        File tmpDir = ClientBase.createTmpDir();
        FileTxnSnapLog logFile = new FileTxnSnapLog(tmpDir, tmpDir);
        DataTree dt = new DataTree();
        dt.createNode("/test", new byte[0], null, 0L, -1, 1L, 1L);
        for (count = 1L; count <= 3L; ++count) {
            dt.createNode("/test/" + count, new byte[0], null, 0L, -1, count, System.currentTimeMillis());
        }
        DataNode zk = dt.getNode("/test");
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, -1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
        LOG.info("Attempting to create /test/" + (count - 1L));
        this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, -1);
    }

    private void doOp(FileTxnSnapLog logFile, int type, String path, DataTree dt, DataNode parent, int cversion) throws Exception {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        int prevCversion = parent.stat.getCversion();
        long prevPzxid = parent.stat.getPzxid();
        List child = dt.getChildren(parentName, null, null);
        String childStr = "";
        for (String s : child) {
            childStr = childStr + s + " ";
        }
        LOG.info("Children: " + childStr + " for " + parentName);
        LOG.info("(cverions, pzxid): " + prevCversion + ", " + prevPzxid);
        DeleteTxn txn = null;
        TxnHeader txnHeader = null;
        if (type == 2) {
            txn = new DeleteTxn(path);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, System.currentTimeMillis(), 2);
        } else if (type == 1) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, System.currentTimeMillis(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
        } else if (type == 14) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, System.currentTimeMillis(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
            ArrayList<Txn> txnList = new ArrayList<Txn>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
            txn.serialize((OutputArchive)boa, "request");
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            Txn txact = new Txn(1, bb.array());
            txnList.add(txact);
            txn = new MultiTxn(txnList);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, System.currentTimeMillis(), 14);
        }
        logFile.processTransaction(txnHeader, dt, null, (Record)txn);
        int newCversion = parent.stat.getCversion();
        long newPzxid = parent.stat.getPzxid();
        child = dt.getChildren(parentName, null, null);
        childStr = "";
        for (String s : child) {
            childStr = childStr + s + " ";
        }
        LOG.info("Children: " + childStr + " for " + parentName);
        LOG.info("(cverions, pzxid): " + newCversion + ", " + newPzxid);
        Assert.assertTrue((String)(type + " <cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"), (newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0);
    }

    @Test
    public void testPad() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        FileTxnLog txnLog = new FileTxnLog(tmpDir);
        TxnHeader txnHeader = new TxnHeader(43981L, 291, 291L, System.currentTimeMillis(), 1);
        CreateTxn txn = new CreateTxn("/Test", new byte[0], null, false, 1);
        txnLog.append(txnHeader, (Record)txn);
        FileInputStream in = new FileInputStream(tmpDir.getPath() + "/log." + Long.toHexString(txnHeader.getZxid()));
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)in);
        FileHeader header = new FileHeader();
        header.deserialize((InputArchive)ia, "fileheader");
        LOG.info("Received magic : " + header.getMagic() + " Expected : " + FileTxnLog.TXNLOG_MAGIC);
        Assert.assertTrue((String)"Missing magic number ", (header.getMagic() == FileTxnLog.TXNLOG_MAGIC ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestore() throws Exception {
        String path;
        String[] children;
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)10000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);
        long start = System.currentTimeMillis();
        while (!this.connected) {
            long end = System.currentTimeMillis();
            if (end - start > 5000L) {
                Assert.assertTrue((String)"Could not connect with server in 5 seconds", (boolean)false);
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                LOG.warn("Intrrupted");
            }
        }
        String lastPath = null;
        try {
            zk.create("/invalidsnap", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i = 0; i < 300; ++i) {
                lastPath = zk.create("/invalidsnap/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        }
        finally {
            zk.close();
        }
        String[] tokens = lastPath.split("-");
        String expectedPath = "/invalidsnap/test-" + String.format("%010d", new Integer(tokens[1]) + 1);
        long eZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to " + zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        f.shutdown();
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)10000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        this.connected = false;
        long fZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        Assert.assertTrue((String)("Restore failed expected zxid=" + eZxid + " found=" + fZxid), (fZxid == eZxid ? 1 : 0) != 0);
        zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);
        start = System.currentTimeMillis();
        while (!this.connected) {
            long end = System.currentTimeMillis();
            if (end - start > 5000L) {
                Assert.assertTrue((String)"Could not connect with server in 5 seconds", (boolean)false);
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                LOG.warn("Intrrupted");
            }
        }
        try {
            children = zk.getChildren("/invalidsnap", false).toArray(new String[0]);
            path = zk.create("/invalidsnap/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        finally {
            zk.close();
        }
        LOG.info("Expected " + expectedPath + " found " + path);
        Assert.assertTrue((String)("Error in sequential znode creation expected " + expectedPath + " found " + path), (boolean)path.equals(expectedPath));
        Assert.assertTrue((String)("Unexpected number of children " + children.length + " expected " + 300), (children.length == 300 ? 1 : 0) != 0);
        f.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithTransactionErrors() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)10000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);
        long start = System.currentTimeMillis();
        while (!this.connected) {
            long end = System.currentTimeMillis();
            if (end - start > 5000L) {
                Assert.assertTrue((String)"Could not connect with server in 5 seconds", (boolean)false);
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                LOG.warn("Intrrupted");
            }
        }
        try {
            for (int i = 0; i < 300; ++i) {
                try {
                    zk.create("/invaliddir/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                    continue;
                }
                catch (KeeperException.NoNodeException e) {
                    // empty catch block
                }
            }
        }
        finally {
            zk.close();
        }
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to " + zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        f.shutdown();
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)10000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        f.shutdown();
    }
}

