/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.utils.join;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class DataJoinJob {
    public static Class getClassByName(String className) {
        Class<?> retv = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            retv = Class.forName(className, true, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retv;
    }

    public static JobConf createDataJoinJob(String[] args) throws IOException {
        String inputDir = args[0];
        String outputDir = args[1];
        Class<SequenceFileInputFormat> inputFormat = SequenceFileInputFormat.class;
        if (args[2].compareToIgnoreCase("text") != 0) {
            System.out.println("Using SequenceFileInputFormat: " + args[2]);
        } else {
            System.out.println("Using TextInputFormat: " + args[2]);
            inputFormat = TextInputFormat.class;
        }
        int numOfReducers = Integer.parseInt(args[3]);
        Class mapper = DataJoinJob.getClassByName(args[4]);
        Class reducer = DataJoinJob.getClassByName(args[5]);
        Class mapoutputValueClass = DataJoinJob.getClassByName(args[6]);
        Class<TextOutputFormat> outputFormat = TextOutputFormat.class;
        Class outputValueClass = Text.class;
        if (args[7].compareToIgnoreCase("text") != 0) {
            System.out.println("Using SequenceFileOutputFormat: " + args[7]);
            outputFormat = SequenceFileOutputFormat.class;
            outputValueClass = DataJoinJob.getClassByName(args[7]);
        } else {
            System.out.println("Using TextOutputFormat: " + args[7]);
        }
        long maxNumOfValuesPerGroup = 100L;
        String jobName = "";
        if (args.length > 8) {
            maxNumOfValuesPerGroup = Long.parseLong(args[8]);
        }
        if (args.length > 9) {
            jobName = args[9];
        }
        Configuration defaults = new Configuration();
        JobConf job = new JobConf(defaults, DataJoinJob.class);
        job.setJobName("DataJoinJob: " + jobName);
        FileSystem fs = FileSystem.get((Configuration)defaults);
        fs.delete(new Path(outputDir), true);
        FileInputFormat.setInputPaths((JobConf)job, (String)inputDir);
        job.setInputFormat(inputFormat);
        job.setMapperClass(mapper);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(outputDir));
        job.setOutputFormat(outputFormat);
        SequenceFileOutputFormat.setOutputCompressionType((JobConf)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(mapoutputValueClass);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(outputValueClass);
        job.setReducerClass(reducer);
        job.setNumMapTasks(1);
        job.setNumReduceTasks(numOfReducers);
        job.setLong("datajoin.maxNumOfValuesPerGroup", maxNumOfValuesPerGroup);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        boolean sucess = true;
        RunningJob running = null;
        try {
            running = jc.submitJob(job);
            JobID jobId = running.getID();
            System.out.println("Job " + jobId + " is submitted");
            while (!running.isComplete()) {
                System.out.println("Job " + jobId + " is still running.");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                running = jc.getJob(jobId);
            }
            sucess = running.isSuccessful();
        }
        finally {
            if (!sucess && running != null) {
                running.killJob();
            }
            jc.close();
        }
        return sucess;
    }

    public static void main(String[] args) {
        if (args.length < 8 || args.length > 10) {
            System.out.println("usage: DataJoinJob inputdirs outputdir map_input_file_format numofParts mapper_class reducer_class map_output_value_class output_value_class [maxNumOfValuesPerGroup [descriptionOfJob]]]");
            System.exit(-1);
        }
        try {
            JobConf job = DataJoinJob.createDataJoinJob(args);
            boolean success = DataJoinJob.runJob(job);
            if (!success) {
                System.out.println("Job failed");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

