/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.GenSort;
import org.apache.hadoop.examples.terasort.Random16;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraOutputFormatWithCRC;
import org.apache.hadoop.examples.terasort.Unsigned16;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraGenWithCRC
extends Configured
implements Tool {
    static Log LOG = LogFactory.getLog(TeraGenWithCRC.class);

    static long getNumberOfRows(JobContext job) {
        return job.getConfiguration().getLong("terasort.num-rows", 0L);
    }

    static void setNumberOfRows(Job job, long numRows) {
        job.getConfiguration().setLong("terasort.num-rows", numRows);
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = Job.getInstance((Configuration)this.getConf());
        TeraGenWithCRC.setNumberOfRows(job, Long.parseLong(args[0]));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.setJobName("TeraGenWithCRC");
        LOG.info((Object)"Running Teragen with CRC");
        job.setJarByClass(TeraGenWithCRC.class);
        job.setMapperClass(SortGenMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RangeInputFormat.class);
        job.setOutputFormatClass(TeraOutputFormatWithCRC.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraGenWithCRC(), (String[])args);
        System.exit(res);
    }

    public static class SortGenMapper
    extends Mapper<LongWritable, NullWritable, Text, Text> {
        private Text key = new Text();
        private Text value = new Text();
        private Unsigned16 rand = null;
        private Unsigned16 rowId = null;
        private Unsigned16 checksum = new Unsigned16();
        private Checksum crc32 = new PureJavaCrc32();
        private Unsigned16 total = new Unsigned16();
        private static final Unsigned16 ONE = new Unsigned16(1L);
        private byte[] buffer = new byte[100];
        private Counter checksumCounter;

        public void map(LongWritable row, NullWritable ignored, Mapper.Context context) throws IOException, InterruptedException {
            if (this.rand == null) {
                this.rowId = new Unsigned16(row.get());
                this.rand = Random16.skipAhead(this.rowId);
                this.checksumCounter = context.getCounter((Enum)TeraGen.Counters.CHECKSUM);
            }
            Random16.nextRand(this.rand);
            GenSort.generateRecord(this.buffer, this.rand, this.rowId);
            this.key.set(this.buffer, 0, 10);
            this.value.set(this.buffer, 10, 90);
            context.write((Object)this.key, (Object)this.value);
            this.crc32.reset();
            this.crc32.update(this.buffer, 0, 100);
            this.checksum.set(this.crc32.getValue());
            this.total.add(this.checksum);
            this.rowId.add(ONE);
        }

        public void cleanup(Mapper.Context context) {
            if (this.checksumCounter != null) {
                this.checksumCounter.increment(this.total.getLow8());
            }
        }
    }

    static class RandomGenerator {
        private long seed = 0L;
        private static final long mask32 = 0xFFFFFFFFL;
        private static final int seedSkip = 0x8000000;
        private static final long[] seeds = new long[]{0L, 0xF8000000L, 0xF0000000L, 0xE8000000L, 0xE0000000L, 0xD8000000L, 0xD0000000L, 0xC8000000L, 0xC0000000L, 0xB8000000L, 0xB0000000L, 0xA8000000L, 0xA0000000L, 0x98000000L, 0x90000000L, 0x88000000L, 0x80000000L, 0x78000000L, 0x70000000L, 0x68000000L, 0x60000000L, 0x58000000L, 0x50000000L, 0x48000000L, 0x40000000L, 0x38000000L, 0x30000000L, 0x28000000L, 0x20000000L, 0x18000000L, 0x10000000L, 0x8000000L};

        RandomGenerator(long initalIteration) {
            int baseIndex = (int)((initalIteration & 0xFFFFFFFFL) / 0x8000000L);
            this.seed = seeds[baseIndex];
            int i = 0;
            while ((long)i < initalIteration % 0x8000000L) {
                this.next();
                ++i;
            }
        }

        RandomGenerator() {
            this(0L);
        }

        long next() {
            this.seed = this.seed * 3141592621L + 663896637L & 0xFFFFFFFFL;
            return this.seed;
        }
    }

    static class RangeInputFormat
    extends InputFormat<LongWritable, NullWritable> {
        RangeInputFormat() {
        }

        public RecordReader<LongWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new RangeRecordReader();
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            long totalRows = TeraGenWithCRC.getNumberOfRows(context);
            int numSplits = context.getConfiguration().getInt("mapreduce.job.maps", 1);
            long rowsPerSplit = totalRows / (long)numSplits;
            System.out.println("Generating " + totalRows + " using " + numSplits + " maps with step of " + rowsPerSplit);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
            long currentRow = 0L;
            for (int split = 0; split < numSplits - 1; ++split) {
                splits.add(new RangeInputSplit(currentRow, rowsPerSplit));
                currentRow += rowsPerSplit;
            }
            splits.add(new RangeInputSplit(currentRow, totalRows - currentRow));
            return splits;
        }

        static class RangeRecordReader
        extends RecordReader<LongWritable, NullWritable> {
            long startRow;
            long finishedRows;
            long totalRows;
            LongWritable key = null;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                this.startRow = ((RangeInputSplit)split).firstRow;
                this.finishedRows = 0L;
                this.totalRows = ((RangeInputSplit)split).rowCount;
            }

            public void close() throws IOException {
            }

            public LongWritable getCurrentKey() {
                return this.key;
            }

            public NullWritable getCurrentValue() {
                return NullWritable.get();
            }

            public float getProgress() throws IOException {
                return (float)this.finishedRows / (float)this.totalRows;
            }

            public boolean nextKeyValue() {
                if (this.key == null) {
                    this.key = new LongWritable();
                }
                if (this.finishedRows < this.totalRows) {
                    this.key.set(this.startRow + this.finishedRows);
                    ++this.finishedRows;
                    return true;
                }
                return false;
            }
        }

        static class RangeInputSplit
        extends InputSplit
        implements Writable {
            long firstRow;
            long rowCount;

            public RangeInputSplit() {
            }

            public RangeInputSplit(long offset, long length) {
                this.firstRow = offset;
                this.rowCount = length;
            }

            public long getLength() throws IOException {
                return 0L;
            }

            public String[] getLocations() throws IOException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                this.firstRow = WritableUtils.readVLong((DataInput)in);
                this.rowCount = WritableUtils.readVLong((DataInput)in);
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVLong((DataOutput)out, (long)this.firstRow);
                WritableUtils.writeVLong((DataOutput)out, (long)this.rowCount);
            }
        }
    }
}

