/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaLruTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestFsDatasetImpl {
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final int NUM_INIT_VOLUMES = 2;
    private static final String CLUSTER_ID = "cluser-id";
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private static final DataStorage dsForStorageUuid = new DataStorage(new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE));
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private FsDatasetImpl dataset;
    private static final String BLOCKPOOL = "BP-TEST";

    private static Storage.StorageDirectory createStorageDirectory(File root) {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(root);
        dsForStorageUuid.createStorageID(sd, false);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs) throws IOException {
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        for (int i = 0; i < numDirs; ++i) {
            File loc = new File(BASE_DIR + "/data" + i);
            dirStrings.add(new Path(loc.toString()).toUri().toString());
            loc.mkdirs();
            dirs.add(TestFsDatasetImpl.createStorageDirectory(loc));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn(dirs.get(i));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.dirIterator()).thenReturn(dirs.iterator());
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)numDirs);
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        DNConf dnConf = new DNConf(this.conf);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode, this.conf);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 2);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
        Assert.assertEquals((long)2L, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
    }

    @Test
    public void testAddVolumes() throws IOException {
        int numNewVolumes = 3;
        int numExistingVolumes = this.dataset.getVolumes().size();
        int totalVolumes = 3 + numExistingVolumes;
        HashSet<String> expectedVolumes = new HashSet<String>();
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        for (int i = 0; i < 3; ++i) {
            String path = BASE_DIR + "/newData" + i;
            String pathUri = new Path(path).toUri().toString();
            expectedVolumes.add(new File(pathUri).toString());
            StorageLocation loc = StorageLocation.parse((String)pathUri);
            Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path));
            DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
            Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)loc.getFile()), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
            this.dataset.addVolume(loc, (List)nsInfos);
        }
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.storageMap.size());
        HashSet<String> actualVolumes = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            actualVolumes.add(((FsVolumeImpl)this.dataset.getVolumes().get(numExistingVolumes + i)).getBasePath());
        }
        Assert.assertEquals((long)actualVolumes.size(), (long)expectedVolumes.size());
        Assert.assertTrue((boolean)actualVolumes.containsAll(expectedVolumes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRemoveVolumes() throws IOException {
        int NUM_BLOCKS = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            ReplicaHandler replica = this.dataset.createRbw(StorageType.DEFAULT, eb, false);
            Throwable throwable = null;
            if (replica == null) continue;
            if (throwable != null) {
                try {
                    replica.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
                continue;
            }
            replica.close();
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        String volumePathToRemove = dataDirs[0];
        HashSet<File> volumesToRemove = new HashSet<File>();
        volumesToRemove.add(StorageLocation.parse((String)volumePathToRemove).getFile());
        this.dataset.removeVolumes(volumesToRemove, true);
        int expectedNumVolumes = dataDirs.length - 1;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        try {
            this.dataset.asyncDiskService.execute((File)volumesToRemove.iterator().next(), new Runnable(){

                @Override
                public void run() {
                }
            });
            Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find root", (Throwable)e);
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)50L, (long)totalNumReplicas);
    }

    @Test(timeout=5000L)
    public void testRemoveNewlyAddedVolume() throws IOException {
        int numExistingVolumes = this.dataset.getVolumes().size();
        ArrayList<NamespaceInfo> nsInfos = new ArrayList<NamespaceInfo>();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        String newVolumePath = BASE_DIR + "/newVolumeToRemoveLater";
        StorageLocation loc = StorageLocation.parse((String)newVolumePath);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(newVolumePath));
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)loc.getFile()), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
        this.dataset.addVolume(loc, nsInfos);
        Assert.assertEquals((long)(numExistingVolumes + 1), (long)this.dataset.getVolumes().size());
        Mockito.when((Object)this.storage.getNumStorageDirs()).thenReturn((Object)(numExistingVolumes + 1));
        Mockito.when((Object)this.storage.getStorageDir(numExistingVolumes)).thenReturn((Object)sd);
        HashSet<File> volumesToRemove = new HashSet<File>();
        volumesToRemove.add(loc.getFile());
        this.dataset.removeVolumes(volumesToRemove, true);
        Assert.assertEquals((long)numExistingVolumes, (long)this.dataset.getVolumes().size());
    }

    @Test(timeout=5000L)
    public void testChangeVolumeWithRunningCheckDirs() throws IOException {
        RoundRobinVolumeChoosingPolicy blockChooser = new RoundRobinVolumeChoosingPolicy();
        BlockScanner blockScanner = new BlockScanner(this.datanode, this.conf);
        final FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), blockScanner, (VolumeChoosingPolicy)blockChooser);
        ArrayList<FsVolumeImpl> oldVolumes = new ArrayList<FsVolumeImpl>();
        int NUM_VOLUMES = 5;
        for (int i = 0; i < 5; ++i) {
            FsVolumeImpl volume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
            oldVolumes.add(volume);
            Mockito.when((Object)volume.getBasePath()).thenReturn((Object)("data" + i));
            FsVolumeReference ref = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
            Mockito.when((Object)ref.getVolume()).thenReturn((Object)volume);
            volumeList.addVolume(ref);
        }
        FsVolumeImpl newVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        final FsVolumeReference newRef = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
        Mockito.when((Object)newRef.getVolume()).thenReturn((Object)newVolume);
        Mockito.when((Object)newVolume.getBasePath()).thenReturn((Object)"data4");
        FsVolumeImpl blockedVolume = (FsVolumeImpl)volumeList.getVolumes().get(1);
        ((FsVolumeImpl)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                volumeList.removeVolume(new File("data4"), false);
                volumeList.addVolume(newRef);
                return null;
            }
        }).when((Object)blockedVolume)).checkDirs();
        FsVolumeImpl brokenVolume = (FsVolumeImpl)volumeList.getVolumes().get(2);
        ((FsVolumeImpl)Mockito.doThrow((Throwable)new DiskChecker.DiskErrorException("broken")).when((Object)brokenVolume)).checkDirs();
        volumeList.checkDirs();
        for (FsVolumeImpl volume : oldVolumes) {
            ((FsVolumeImpl)Mockito.verify((Object)volume)).checkDirs();
        }
        ((FsVolumeImpl)Mockito.verify((Object)newVolume, (VerificationMode)Mockito.never())).checkDirs();
        Assert.assertTrue((boolean)volumeList.getVolumes().contains(newVolume));
        Assert.assertFalse((boolean)volumeList.getVolumes().contains(brokenVolume));
        Assert.assertEquals((long)4L, (long)volumeList.getVolumes().size());
    }

    @Test
    public void testAddVolumeFailureReleasesInUseLock() throws IOException {
        FsDatasetImpl spyDataset = (FsDatasetImpl)Mockito.spy((Object)this.dataset);
        FsVolumeImpl mockVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File badDir = new File(BASE_DIR, "bad");
        badDir.mkdirs();
        ((FsDatasetImpl)Mockito.doReturn((Object)mockVolume).when((Object)spyDataset)).createFsVolume(Matchers.anyString(), (File)Matchers.any(File.class), (StorageType)Matchers.any(StorageType.class));
        ((FsVolumeImpl)Mockito.doThrow((Throwable)new IOException("Failed to getVolumeMap()")).when((Object)mockVolume)).getVolumeMap(Matchers.anyString(), (ReplicaMap)Matchers.any(ReplicaMap.class), (RamDiskReplicaTracker)Matchers.any(RamDiskReplicaLruTracker.class));
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(badDir);
        sd.lock();
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)badDir.getAbsoluteFile()), (List)Matchers.any())).thenReturn((Object)builder);
        StorageLocation location = StorageLocation.parse((String)badDir.toString());
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        try {
            spyDataset.addVolume(location, (List)nsInfos);
            Assert.fail((String)"Expect to throw MultipleIOException");
        }
        catch (MultipleIOException e) {
            // empty catch block
        }
        FsDatasetTestUtil.assertFileLockReleased(badDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeletingBlocks() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        try {
            FinalizedReplica info;
            ExtendedBlock eb;
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl ds = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            FsVolumeImpl vol = (FsVolumeImpl)ds.getVolumes().get(0);
            ArrayList<FinalizedReplica> blockList = new ArrayList<FinalizedReplica>();
            for (int i = 1; i <= 63; ++i) {
                eb = new ExtendedBlock(BLOCKPOOL, (long)i, 1L, (long)(1000 + i));
                info = new FinalizedReplica(eb.getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
                ds.volumeMap.add(BLOCKPOOL, (ReplicaInfo)info);
                info.getBlockFile().createNewFile();
                info.getMetaFile().createNewFile();
                blockList.add(info);
            }
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
            blockList.clear();
            eb = new ExtendedBlock(BLOCKPOOL, 64L, 1L, 1064L);
            info = new FinalizedReplica(eb.getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
            ds.volumeMap.add(BLOCKPOOL, (ReplicaInfo)info);
            info.getBlockFile().createNewFile();
            info.getMetaFile().createNewFile();
            blockList.add(info);
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Assert.assertFalse((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
        }
        finally {
            cluster.shutdown();
        }
    }
}

