/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestUnderReplicatedBlockQueues {
    @Test
    public void testBlockPriorities() throws Throwable {
        UnderReplicatedBlocks queues = new UnderReplicatedBlocks();
        Block block1 = new Block(1L);
        Block block2 = new Block(2L);
        Block block_very_under_replicated = new Block(3L);
        Block block_corrupt = new Block(4L);
        Block block_corrupt_repl_one = new Block(5L);
        this.assertAdded(queues, block1, 1, 0, 3);
        Assert.assertEquals((long)1L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)1L, (long)queues.size());
        this.assertInLevel(queues, block1, 0);
        Assert.assertFalse((boolean)queues.add(block1, 1, 0, 3));
        this.assertAdded(queues, block2, 2, 0, 3);
        Assert.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)2L, (long)queues.size());
        this.assertInLevel(queues, block2, 2);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        Assert.assertEquals((long)3L, (long)queues.size());
        Assert.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)1L, (long)queues.getCorruptBlockSize());
        this.assertInLevel(queues, block_corrupt, 4);
        this.assertAdded(queues, block_very_under_replicated, 4, 0, 25);
        this.assertInLevel(queues, block_very_under_replicated, 1);
        this.assertAdded(queues, block_corrupt_repl_one, 0, 0, 1);
        Assert.assertEquals((long)2L, (long)queues.getCorruptBlockSize());
        Assert.assertEquals((long)1L, (long)queues.getCorruptReplOneBlockSize());
        queues.update(block_corrupt_repl_one, 0, 0, 3, 0, 2);
        Assert.assertEquals((long)0L, (long)queues.getCorruptReplOneBlockSize());
        queues.update(block_corrupt, 0, 0, 1, 0, -2);
        Assert.assertEquals((long)1L, (long)queues.getCorruptReplOneBlockSize());
        queues.update(block_very_under_replicated, 0, 0, 1, -4, -24);
        Assert.assertEquals((long)2L, (long)queues.getCorruptReplOneBlockSize());
    }

    private void assertAdded(UnderReplicatedBlocks queues, Block block, int curReplicas, int decomissionedReplicas, int expectedReplicas) {
        Assert.assertTrue((String)("Failed to add " + block), (boolean)queues.add(block, curReplicas, decomissionedReplicas, expectedReplicas));
    }

    private void assertInLevel(UnderReplicatedBlocks queues, Block block, int level) {
        UnderReplicatedBlocks.BlockIterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        Assert.fail((String)("Block " + block + " not found in level " + level));
    }
}

