/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplicaInfo;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestBlockReaderFactory {
    static final Log LOG = LogFactory.getLog(TestBlockReaderFactory.class);

    @Before
    public void init() {
        DomainSocket.disableBindPathValidation();
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
    }

    @After
    public void cleanup() {
        DFSInputStream.tcpReadsDisabledForTesting = false;
        BlockReaderFactory.createShortCircuitReplicaInfoCallback = null;
    }

    public static Configuration createShortCircuitConf(String testName, TemporarySocketDirectory sockDir) {
        Configuration conf = new Configuration();
        conf.set("dfs.client.context", testName);
        conf.setLong("dfs.blocksize", 4096L);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), testName + "._PORT").getAbsolutePath());
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.setBoolean("dfs.client.domain.socket.data.traffic", false);
        return conf;
    }

    @Test(timeout=60000L)
    public void testFallbackFromShortCircuitToUnixDomainTraffic() throws Exception {
        DFSInputStream.tcpReadsDisabledForTesting = true;
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration clientConf = TestBlockReaderFactory.createShortCircuitConf("testFallbackFromShortCircuitToUnixDomainTraffic", sockDir);
        clientConf.set("dfs.client.context", "testFallbackFromShortCircuitToUnixDomainTraffic_clientContext");
        clientConf.setBoolean("dfs.client.domain.socket.data.traffic", true);
        Configuration serverConf = new Configuration(clientConf);
        serverConf.setBoolean("dfs.client.read.shortcircuit", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(serverConf).numDataNodes(1).build();
        cluster.waitActive();
        FileSystem dfs = FileSystem.get((URI)cluster.getURI(0), (Configuration)clientConf);
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 8193;
        int SEED = 1027565;
        DFSTestUtil.createFile(dfs, new Path(TEST_FILE), 8193L, (short)1, 1027565L);
        byte[] contents = DFSTestUtil.readFileBuffer(dfs, new Path(TEST_FILE));
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027565L, 8193);
        Assert.assertTrue((boolean)Arrays.equals(contents, expected));
        cluster.shutdown();
        sockDir.close();
    }

    @Test(timeout=60000L)
    public void testMultipleWaitersOnShortCircuitCache() throws Exception {
        int i;
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean creationIsBlocked = new AtomicBoolean(true);
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        BlockReaderFactory.createShortCircuitReplicaInfoCallback = new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
                if (!creationIsBlocked.compareAndSet(true, false)) {
                    Assert.fail((String)"there were multiple calls to createShortCircuitReplicaInfo.  Only one was expected.");
                }
                return null;
            }
        };
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestBlockReaderFactory.createShortCircuitConf("testMultipleWaitersOnShortCircuitCache", sockDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        final DistributedFileSystem dfs = cluster.getFileSystem();
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4000;
        int SEED = 1027565;
        int NUM_THREADS = 10;
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/test_file"), 4000L, (short)1, 1027565L);
        Runnable readerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)dfs, new Path("/test_file"));
                    Assert.assertFalse((boolean)creationIsBlocked.get());
                    byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027565L, 4000);
                    Assert.assertTrue((boolean)Arrays.equals(contents, expected));
                }
                catch (Throwable e) {
                    LOG.error((Object)"readerRunnable error", e);
                    testFailed.set(true);
                }
            }
        };
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread(readerRunnable);
            threads[i].start();
        }
        Thread.sleep(500L);
        latch.countDown();
        for (i = 0; i < 10; ++i) {
            Uninterruptibles.joinUninterruptibly((Thread)threads[i]);
        }
        cluster.shutdown();
        sockDir.close();
        Assert.assertFalse((boolean)testFailed.get());
    }

    @Test(timeout=60000L)
    public void testShortCircuitCacheTemporaryFailure() throws Exception {
        int i;
        BlockReaderTestUtil.enableBlockReaderFactoryTracing();
        final AtomicBoolean replicaCreationShouldFail = new AtomicBoolean(true);
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        BlockReaderFactory.createShortCircuitReplicaInfoCallback = new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                if (replicaCreationShouldFail.get()) {
                    Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                    return new ShortCircuitReplicaInfo();
                }
                return null;
            }
        };
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestBlockReaderFactory.createShortCircuitConf("testShortCircuitCacheTemporaryFailure", sockDir);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4000;
        int NUM_THREADS = 2;
        int SEED = 1027565;
        final CountDownLatch gotFailureLatch = new CountDownLatch(2);
        final CountDownLatch shouldRetryLatch = new CountDownLatch(1);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/test_file"), 4000L, (short)1, 1027565L);
        Runnable readerRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List locatedBlocks = cluster.getNameNode().getRpcServer().getBlockLocations("/test_file", 0L, 4000L).getLocatedBlocks();
                    LocatedBlock lblock = (LocatedBlock)locatedBlocks.get(0);
                    try (BlockReader blockReader = null;){
                        blockReader = BlockReaderTestUtil.getBlockReader(cluster, lblock, 0, 4000);
                        Assert.fail((String)"expected getBlockReader to fail the first time.");
                    }
                    gotFailureLatch.countDown();
                    shouldRetryLatch.await();
                    try {
                        blockReader = BlockReaderTestUtil.getBlockReader(cluster, lblock, 0, 4000);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"error trying to retrieve a block reader the second time.", t);
                        throw t;
                    }
                    finally {
                        if (blockReader != null) {
                            blockReader.close();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"getBlockReader failure", t);
                    testFailed.set(true);
                }
            }
        };
        Thread[] threads = new Thread[2];
        for (i = 0; i < 2; ++i) {
            threads[i] = new Thread(readerRunnable);
            threads[i].start();
        }
        gotFailureLatch.await();
        replicaCreationShouldFail.set(false);
        shouldRetryLatch.countDown();
        for (i = 0; i < 2; ++i) {
            Uninterruptibles.joinUninterruptibly((Thread)threads[i]);
        }
        cluster.shutdown();
        sockDir.close();
        Assert.assertFalse((boolean)testFailed.get());
    }

    @Test
    public void testShortCircuitReadFromServerWithoutShm() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration clientConf = TestBlockReaderFactory.createShortCircuitConf("testShortCircuitReadFromServerWithoutShm", sockDir);
        Configuration serverConf = new Configuration(clientConf);
        serverConf.setInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 0);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(serverConf).numDataNodes(1).build();
        cluster.waitActive();
        clientConf.set("dfs.client.context", "testShortCircuitReadFromServerWithoutShm_clientContext");
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)cluster.getURI(0), (Configuration)clientConf);
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4000;
        int SEED = 1027564;
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test_file"), 4000L, (short)1, 1027564L);
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)fs, new Path("/test_file"));
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027564L, 4000);
        Assert.assertTrue((boolean)Arrays.equals(contents, expected));
        ShortCircuitCache cache = fs.dfs.getClientContext().getShortCircuitCache();
        final DatanodeInfo datanode = new DatanodeInfo(cluster.getDataNodes().get(0).getDatanodeId());
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                Assert.assertEquals((long)1L, (long)info.size());
                DfsClientShmManager.PerDatanodeVisitorInfo vinfo = info.get(datanode);
                Assert.assertTrue((boolean)vinfo.disabled);
                Assert.assertEquals((long)0L, (long)vinfo.full.size());
                Assert.assertEquals((long)0L, (long)vinfo.notFull.size());
            }
        });
        cluster.shutdown();
        sockDir.close();
    }

    @Test
    public void testShortCircuitReadFromClientWithoutShm() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration clientConf = TestBlockReaderFactory.createShortCircuitConf("testShortCircuitReadWithoutShm", sockDir);
        Configuration serverConf = new Configuration(clientConf);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(serverConf).numDataNodes(1).build();
        cluster.waitActive();
        clientConf.setInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 0);
        clientConf.set("dfs.client.context", "testShortCircuitReadFromClientWithoutShm_clientContext");
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)cluster.getURI(0), (Configuration)clientConf);
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4000;
        int SEED = 1027564;
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test_file"), 4000L, (short)1, 1027564L);
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)fs, new Path("/test_file"));
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027564L, 4000);
        Assert.assertTrue((boolean)Arrays.equals(contents, expected));
        ShortCircuitCache cache = fs.dfs.getClientContext().getShortCircuitCache();
        Assert.assertEquals(null, (Object)cache.getDfsClientShmManager());
        cluster.shutdown();
        sockDir.close();
    }

    @Test
    public void testShortCircuitCacheShutdown() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestBlockReaderFactory.createShortCircuitConf("testShortCircuitCacheShutdown", sockDir);
        conf.set("dfs.client.context", "testShortCircuitCacheShutdown");
        Configuration serverConf = new Configuration(conf);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(serverConf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)cluster.getURI(0), (Configuration)conf);
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4000;
        int SEED = 1027564;
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test_file"), 4000L, (short)1, 1027564L);
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)fs, new Path("/test_file"));
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027564L, 4000);
        Assert.assertTrue((boolean)Arrays.equals(contents, expected));
        ShortCircuitCache cache = fs.dfs.getClientContext().getShortCircuitCache();
        cache.close();
        Assert.assertTrue((boolean)cache.getDfsClientShmManager().getDomainSocketWatcher().isClosed());
        cluster.shutdown();
        sockDir.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testPurgingClosedReplicas() throws Exception {
        BlockReaderTestUtil.enableBlockReaderFactoryTracing();
        final AtomicInteger replicasCreated = new AtomicInteger(0);
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        BlockReaderFactory.createShortCircuitReplicaInfoCallback = new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                replicasCreated.incrementAndGet();
                return null;
            }
        };
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestBlockReaderFactory.createShortCircuitConf("testPurgingClosedReplicas", sockDir);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 4095;
        int SEED = 1027552;
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)cluster.getURI(0), (Configuration)conf);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test_file"), 4095L, (short)1, 1027552L);
        final Semaphore sem = new Semaphore(0);
        List locatedBlocks = cluster.getNameNode().getRpcServer().getBlockLocations("/test_file", 0L, 4095L).getLocatedBlocks();
        final LocatedBlock lblock = (LocatedBlock)locatedBlocks.get(0);
        final byte[] buf = new byte[4095];
        Runnable readerRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        try (BlockReader blockReader = null;){
                            blockReader = BlockReaderTestUtil.getBlockReader(cluster, lblock, 0, 4095);
                            sem.release();
                            try {
                                blockReader.readAll(buf, 0, 4095);
                            }
                            finally {
                                sem.acquireUninterruptibly();
                            }
                        }
                        LOG.info((Object)"read another 4095 bytes.");
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"getBlockReader failure", t);
                    testFailed.set(true);
                    sem.release();
                }
            }
        };
        Thread thread = new Thread(readerRunnable);
        thread.start();
        while (thread.isAlive()) {
            sem.acquireUninterruptibly();
            thread.interrupt();
            sem.release();
        }
        Assert.assertFalse((boolean)testFailed.get());
        try (BlockReader blockReader = null;){
            blockReader = BlockReaderTestUtil.getBlockReader(cluster, lblock, 0, 4095);
            blockReader.readFully(buf, 0, 4095);
        }
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027552L, 4095);
        Assert.assertTrue((boolean)Arrays.equals(buf, expected));
        Assert.assertEquals((long)2L, (long)replicasCreated.get());
        dfs.close();
        cluster.shutdown();
        sockDir.close();
    }
}

