/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.Arrays;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.ZooKeeperSaslClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaslClientTest
extends ZKTestCase {
    private String existingPropertyValue = null;

    @Before
    public void setUp() {
        this.existingPropertyValue = System.getProperty("zookeeper.sasl.client");
    }

    @After
    public void tearDown() {
        if (this.existingPropertyValue != null) {
            System.setProperty("zookeeper.sasl.client", this.existingPropertyValue);
        }
    }

    @Test
    public void testSaslClientDisabled() {
        System.clearProperty("zookeeper.sasl.client");
        Assert.assertTrue((boolean)ZooKeeperSaslClient.isEnabled());
        for (String value : Arrays.asList("true", "TRUE")) {
            System.setProperty("zookeeper.sasl.client", value);
            Assert.assertTrue((boolean)ZooKeeperSaslClient.isEnabled());
        }
        for (String value : Arrays.asList("false", "FALSE")) {
            System.setProperty("zookeeper.sasl.client", value);
            Assert.assertFalse((boolean)ZooKeeperSaslClient.isEnabled());
        }
    }
}

