/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.PromoteReadReplicaRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromoteReadReplicaRequestMarshaller
implements Marshaller<Request<PromoteReadReplicaRequest>, PromoteReadReplicaRequest> {
    @Override
    public Request<PromoteReadReplicaRequest> marshall(PromoteReadReplicaRequest promoteReadReplicaRequest) {
        if (promoteReadReplicaRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PromoteReadReplicaRequest> request = new DefaultRequest<PromoteReadReplicaRequest>(promoteReadReplicaRequest, "AmazonRDS");
        request.addParameter("Action", "PromoteReadReplica");
        request.addParameter("Version", "2013-09-09");
        if (promoteReadReplicaRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(promoteReadReplicaRequest.getDBInstanceIdentifier()));
        }
        if (promoteReadReplicaRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger(promoteReadReplicaRequest.getBackupRetentionPeriod()));
        }
        if (promoteReadReplicaRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString(promoteReadReplicaRequest.getPreferredBackupWindow()));
        }
        return request;
    }
}

