/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairSchedulerPlanFollower
extends AbstractSchedulerPlanFollower {
    private static final Logger LOG = LoggerFactory.getLogger(FairSchedulerPlanFollower.class);
    private FairScheduler fs;

    @Override
    public void init(Clock clock, ResourceScheduler sched, Collection<Plan> plans) {
        super.init(clock, sched, plans);
        this.fs = (FairScheduler)sched;
        LOG.info("Initializing Plan Follower Policy:" + this.getClass().getCanonicalName());
    }

    @Override
    protected Queue getPlanQueue(String planQueueName) {
        FSParentQueue planQueue = this.fs.getQueueManager().getParentQueue(planQueueName, false);
        if (planQueue == null) {
            LOG.error("The queue " + planQueueName + " cannot be found or is not a " + "ParentQueue");
        }
        return planQueue;
    }

    @Override
    protected float calculateReservationToPlanRatio(Resource clusterResources, Resource planResources, Resource capToAssign) {
        return Resources.divide((ResourceCalculator)this.fs.getResourceCalculator(), (Resource)clusterResources, (Resource)capToAssign, (Resource)planResources);
    }

    @Override
    protected boolean arePlanResourcesLessThanReservations(Resource clusterResources, Resource planResources, Resource reservedResources) {
        return Resources.greaterThan((ResourceCalculator)this.fs.getResourceCalculator(), (Resource)clusterResources, (Resource)reservedResources, (Resource)planResources);
    }

    @Override
    protected List<? extends Queue> getChildReservationQueues(Queue queue) {
        FSQueue planQueue = (FSQueue)queue;
        List<FSQueue> childQueues = planQueue.getChildQueues();
        return childQueues;
    }

    @Override
    protected void addReservationQueue(String planQueueName, Queue queue, String currResId) {
        String leafQueueName = this.getReservationQueueName(planQueueName, currResId);
        this.fs.getQueueManager().getLeafQueue(leafQueueName, true);
    }

    @Override
    protected void createDefaultReservationQueue(String planQueueName, Queue queue, String defReservationId) {
        String defReservationQueueName = this.getReservationQueueName(planQueueName, defReservationId);
        if (!this.fs.getQueueManager().exists(defReservationQueueName)) {
            this.fs.getQueueManager().getLeafQueue(defReservationQueueName, true);
        }
    }

    @Override
    protected Resource getPlanResources(Plan plan, Queue queue, Resource clusterResources) {
        FSParentQueue planQueue = (FSParentQueue)queue;
        Resource planResources = planQueue.getSteadyFairShare();
        return planResources;
    }

    @Override
    protected Resource getReservationQueueResourceIfExists(Plan plan, ReservationId reservationId) {
        String reservationQueueName = this.getReservationQueueName(plan.getQueueName(), reservationId.toString());
        FSLeafQueue reservationQueue = this.fs.getQueueManager().getLeafQueue(reservationQueueName, false);
        Resource reservationResource = null;
        if (reservationQueue != null) {
            reservationResource = reservationQueue.getSteadyFairShare();
        }
        return reservationResource;
    }

    @Override
    protected String getReservationQueueName(String planQueueName, String reservationQueueName) {
        String planQueueNameFullPath = this.fs.getQueueManager().getQueue(planQueueName).getName();
        if (!reservationQueueName.startsWith(planQueueNameFullPath)) {
            return planQueueNameFullPath + "." + reservationQueueName;
        }
        return reservationQueueName;
    }

    @Override
    protected String getReservationIdFromQueueName(String resQueueName) {
        return resQueueName.substring(resQueueName.lastIndexOf(".") + 1);
    }
}

