/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@InterfaceAudience.Private
@Metrics(about="Nfs3 metrics", context="dfs")
public class Nfs3Metrics {
    @Metric
    MutableRate getattr;
    @Metric
    MutableRate setattr;
    @Metric
    MutableRate lookup;
    @Metric
    MutableRate access;
    @Metric
    MutableRate readlink;
    @Metric
    MutableRate read;
    final MutableQuantiles[] readNanosQuantiles;
    @Metric
    MutableRate write;
    final MutableQuantiles[] writeNanosQuantiles;
    @Metric
    MutableRate create;
    @Metric
    MutableRate mkdir;
    @Metric
    MutableRate symlink;
    @Metric
    MutableRate mknod;
    @Metric
    MutableRate remove;
    @Metric
    MutableRate rmdir;
    @Metric
    MutableRate rename;
    @Metric
    MutableRate link;
    @Metric
    MutableRate readdir;
    @Metric
    MutableRate readdirplus;
    @Metric
    MutableRate fsstat;
    @Metric
    MutableRate fsinfo;
    @Metric
    MutableRate pathconf;
    @Metric
    MutableRate commit;
    final MutableQuantiles[] commitNanosQuantiles;
    @Metric
    MutableCounterLong bytesWritten;
    @Metric
    MutableCounterLong bytesRead;
    final MetricsRegistry registry = new MetricsRegistry("nfs3");
    final String name;
    JvmMetrics jvmMetrics = null;

    public Nfs3Metrics(String name, String sessionId, int[] intervals, JvmMetrics jvmMetrics) {
        this.name = name;
        this.jvmMetrics = jvmMetrics;
        this.registry.tag((MetricsInfo)MsInfo.SessionId, sessionId);
        int len = intervals.length;
        this.readNanosQuantiles = new MutableQuantiles[len];
        this.writeNanosQuantiles = new MutableQuantiles[len];
        this.commitNanosQuantiles = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.readNanosQuantiles[i] = this.registry.newQuantiles("readProcessNanos" + interval + "s", "Read process in ns", "ops", "latency", interval);
            this.writeNanosQuantiles[i] = this.registry.newQuantiles("writeProcessNanos" + interval + "s", "Write process in ns", "ops", "latency", interval);
            this.commitNanosQuantiles[i] = this.registry.newQuantiles("commitProcessNanos" + interval + "s", "Commit process in ns", "ops", "latency", interval);
        }
    }

    public static Nfs3Metrics create(Configuration conf, String gatewayName) {
        String sessionId = conf.get("dfs.metrics.session-id");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)gatewayName, (String)sessionId, (MetricsSystem)ms);
        int[] intervals = conf.getInts("nfs.metrics.percentiles.intervals");
        return (Nfs3Metrics)ms.register((Object)new Nfs3Metrics(gatewayName, sessionId, intervals, jm));
    }

    public String name() {
        return this.name;
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void incrBytesWritten(long bytes) {
        this.bytesWritten.incr(bytes);
    }

    public void incrBytesRead(long bytes) {
        this.bytesRead.incr(bytes);
    }

    public void addGetattr(long latencyNanos) {
        this.getattr.add(latencyNanos);
    }

    public void addSetattr(long latencyNanos) {
        this.setattr.add(latencyNanos);
    }

    public void addLookup(long latencyNanos) {
        this.lookup.add(latencyNanos);
    }

    public void addAccess(long latencyNanos) {
        this.access.add(latencyNanos);
    }

    public void addReadlink(long latencyNanos) {
        this.readlink.add(latencyNanos);
    }

    public void addRead(long latencyNanos) {
        this.read.add(latencyNanos);
        for (MutableQuantiles q : this.readNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void addWrite(long latencyNanos) {
        this.write.add(latencyNanos);
        for (MutableQuantiles q : this.writeNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void addCreate(long latencyNanos) {
        this.create.add(latencyNanos);
    }

    public void addMkdir(long latencyNanos) {
        this.mkdir.add(latencyNanos);
    }

    public void addSymlink(long latencyNanos) {
        this.symlink.add(latencyNanos);
    }

    public void addMknod(long latencyNanos) {
        this.mknod.add(latencyNanos);
    }

    public void addRemove(long latencyNanos) {
        this.remove.add(latencyNanos);
    }

    public void addRmdir(long latencyNanos) {
        this.rmdir.add(latencyNanos);
    }

    public void addRename(long latencyNanos) {
        this.rename.add(latencyNanos);
    }

    public void addLink(long latencyNanos) {
        this.link.add(latencyNanos);
    }

    public void addReaddir(long latencyNanos) {
        this.readdir.add(latencyNanos);
    }

    public void addReaddirplus(long latencyNanos) {
        this.readdirplus.add(latencyNanos);
    }

    public void addFsstat(long latencyNanos) {
        this.fsstat.add(latencyNanos);
    }

    public void addFsinfo(long latencyNanos) {
        this.fsinfo.add(latencyNanos);
    }

    public void addPathconf(long latencyNanos) {
        this.pathconf.add(latencyNanos);
    }

    public void addCommit(long latencyNanos) {
        this.commit.add(latencyNanos);
        for (MutableQuantiles q : this.commitNanosQuantiles) {
            q.add(latencyNanos);
        }
    }
}

