/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestNamenodeCapacityReport {
    private static final Log LOG = LogFactory.getLog(TestNamenodeCapacityReport.class);
    private static final float EPSILON = 1.0E-4f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        long reserved = 10000L;
        conf.setLong("dfs.datanode.du.reserved", reserved);
        try {
            float percentBpUsed;
            long bpUsed;
            float percentRemaining;
            float percentUsed;
            long configCapacity;
            long nonDFSUsed;
            long remaining;
            long used;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            ArrayList live = new ArrayList();
            ArrayList dead = new ArrayList();
            dm.fetchDatanodes(live, dead, false);
            Assert.assertTrue((live.size() == 1 ? 1 : 0) != 0);
            for (DatanodeDescriptor datanode : live) {
                used = datanode.getDfsUsed();
                remaining = datanode.getRemaining();
                nonDFSUsed = datanode.getNonDfsUsed();
                configCapacity = datanode.getCapacity();
                percentUsed = datanode.getDfsUsedPercent();
                percentRemaining = datanode.getRemainingPercent();
                bpUsed = datanode.getBlockPoolUsed();
                percentBpUsed = datanode.getBlockPoolUsedPercent();
                LOG.info((Object)("Datanode configCapacity " + configCapacity + " used " + used + " non DFS used " + nonDFSUsed + " remaining " + remaining + " perentUsed " + percentUsed + " percentRemaining " + percentRemaining));
                Assert.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
                Assert.assertTrue((percentUsed == DFSUtil.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
                Assert.assertTrue((percentRemaining == DFSUtil.getPercentRemaining((long)remaining, (long)configCapacity) ? 1 : 0) != 0);
                Assert.assertTrue((percentBpUsed == DFSUtil.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            }
            DF df = new DF(new File(cluster.getDataDirectory()), (Configuration)conf);
            int numOfDataDirs = 2;
            long diskCapacity = (long)numOfDataDirs * df.getCapacity();
            reserved *= (long)numOfDataDirs;
            configCapacity = namesystem.getCapacityTotal();
            used = namesystem.getCapacityUsed();
            nonDFSUsed = namesystem.getNonDfsUsedSpace();
            remaining = namesystem.getCapacityRemaining();
            percentUsed = namesystem.getPercentUsed();
            percentRemaining = namesystem.getPercentRemaining();
            bpUsed = namesystem.getBlockPoolUsedSpace();
            percentBpUsed = namesystem.getPercentBlockPoolUsed();
            LOG.info((Object)("Data node directory " + cluster.getDataDirectory()));
            LOG.info((Object)("Name node diskCapacity " + diskCapacity + " configCapacity " + configCapacity + " reserved " + reserved + " used " + used + " remaining " + remaining + " nonDFSUsed " + nonDFSUsed + " remaining " + remaining + " percentUsed " + percentUsed + " percentRemaining " + percentRemaining + " bpUsed " + bpUsed + " percentBpUsed " + percentBpUsed));
            Assert.assertTrue((configCapacity == diskCapacity - reserved ? 1 : 0) != 0);
            Assert.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
            Assert.assertTrue((percentUsed == DFSUtil.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
            Assert.assertTrue((percentBpUsed == DFSUtil.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            Assert.assertTrue((percentRemaining == (float)remaining * 100.0f / (float)configCapacity ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXceiverCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 0);
        MiniDFSCluster cluster = null;
        int nodes = 8;
        int fileCount = 5;
        int fileRepl = 3;
        try {
            int i;
            DatanodeDescriptor dnd;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.triggerHeartbeats(datanodes);
            int expectedTotalLoad = 8;
            int expectedInServiceNodes = 8;
            int expectedInServiceLoad = 8;
            Assert.assertEquals((long)8L, (long)namesystem.getNumLiveDataNodes());
            Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
            Assert.assertEquals((long)expectedTotalLoad, (long)namesystem.getTotalLoad());
            Assert.assertEquals((double)((double)expectedInServiceLoad / (double)expectedInServiceLoad), (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            for (int i2 = 0; i2 < 4; ++i2) {
                DataNode dn = (DataNode)datanodes.get(i2);
                dnd = dnm.getDatanode(dn.getDatanodeId());
                dn.shutdown();
                dnd.setLastUpdate(0L);
                BlockManagerTestUtil.checkHeartbeat(namesystem.getBlockManager());
                Assert.assertEquals((long)(--expectedInServiceNodes), (long)namesystem.getNumLiveDataNodes());
                Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
            }
            cluster.restartDataNodes();
            cluster.waitActive();
            datanodes = cluster.getDataNodes();
            expectedInServiceNodes = 8;
            Assert.assertEquals((long)8L, (long)datanodes.size());
            Assert.assertEquals((long)8L, (long)namesystem.getNumLiveDataNodes());
            Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
            Assert.assertEquals((long)expectedTotalLoad, (long)namesystem.getTotalLoad());
            Assert.assertEquals((double)((double)expectedInServiceLoad / (double)expectedInServiceLoad), (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            DFSOutputStream[] streams = new DFSOutputStream[5];
            for (i = 0; i < 5; ++i) {
                streams[i] = (DFSOutputStream)fs.create(new Path("/f" + i), (short)3).getWrappedStream();
                streams[i].write("1".getBytes());
                streams[i].hsync();
                expectedTotalLoad += 6;
                expectedInServiceLoad += 6;
            }
            this.triggerHeartbeats(datanodes);
            Assert.assertEquals((long)8L, (long)namesystem.getNumLiveDataNodes());
            Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
            Assert.assertEquals((long)expectedTotalLoad, (long)namesystem.getTotalLoad());
            Assert.assertEquals((double)((double)expectedInServiceLoad / (double)expectedInServiceNodes), (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            for (i = 0; i < 3; ++i) {
                --expectedInServiceNodes;
                dnd = dnm.getDatanode(((DataNode)datanodes.get(i)).getDatanodeId());
                expectedInServiceLoad -= dnd.getXceiverCount();
                dnm.startDecommission(dnd);
                DataNodeTestUtils.triggerHeartbeat((DataNode)datanodes.get(i));
                Thread.sleep(100L);
                Assert.assertEquals((long)8L, (long)namesystem.getNumLiveDataNodes());
                Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
                Assert.assertEquals((long)expectedTotalLoad, (long)namesystem.getTotalLoad());
                Assert.assertEquals((double)((double)expectedInServiceLoad / (double)expectedInServiceNodes), (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            }
            for (i = 0; i < 5; ++i) {
                block14: {
                    int decomm = 0;
                    for (DatanodeInfo dni : streams[i].getPipeline()) {
                        DatanodeDescriptor dnd2 = dnm.getDatanode((DatanodeID)dni);
                        expectedTotalLoad -= 2;
                        if (dnd2.isDecommissionInProgress() || dnd2.isDecommissioned()) {
                            ++decomm;
                            continue;
                        }
                        expectedInServiceLoad -= 2;
                    }
                    try {
                        streams[i].close();
                    }
                    catch (IOException ioe) {
                        if (decomm >= 3) break block14;
                        throw ioe;
                    }
                }
                this.triggerHeartbeats(datanodes);
                Assert.assertEquals((long)8L, (long)namesystem.getNumLiveDataNodes());
                Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
                Assert.assertEquals((long)expectedTotalLoad, (long)namesystem.getTotalLoad());
                Assert.assertEquals((double)((double)expectedInServiceLoad / (double)expectedInServiceNodes), (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            }
            for (i = 0; i < 8; ++i) {
                DataNode dn = (DataNode)datanodes.get(i);
                dn.shutdown();
                DatanodeDescriptor dnDesc = dnm.getDatanode(dn.getDatanodeId());
                dnDesc.setLastUpdate(0L);
                BlockManagerTestUtil.checkHeartbeat(namesystem.getBlockManager());
                Assert.assertEquals((long)(7 - i), (long)namesystem.getNumLiveDataNodes());
                if (i >= 3) {
                    --expectedInServiceNodes;
                }
                Assert.assertEquals((long)expectedInServiceNodes, (long)namesystem.getNumDatanodesInService());
                double expectedXceiverAvg = i == 7 ? 0.0 : 1.0;
                Assert.assertEquals((double)expectedXceiverAvg, (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
            }
            Assert.assertEquals((long)0L, (long)namesystem.getNumLiveDataNodes());
            Assert.assertEquals((long)0L, (long)namesystem.getNumDatanodesInService());
            Assert.assertEquals((double)0.0, (double)namesystem.getTotalLoad(), (double)1.0E-4f);
            Assert.assertEquals((double)0.0, (double)namesystem.getInServiceXceiverAverage(), (double)1.0E-4f);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void triggerHeartbeats(List<DataNode> datanodes) throws IOException, InterruptedException {
        for (DataNode dn : datanodes) {
            DataNodeTestUtils.triggerHeartbeat(dn);
        }
        Thread.sleep(100L);
    }
}

