/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraGenWithCRC;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraValidateWithCRC
extends Configured
implements Tool {
    private static final Text error = new Text("error");
    static Log LOG = LogFactory.getLog(TeraGenWithCRC.class);

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        TeraInputFormatWithCRC.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.setJobName("TeraValidateWithCRC");
        job.setJarByClass(TeraValidateWithCRC.class);
        job.setMapperClass(ValidateMapper.class);
        job.setReducerClass(ValidateReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        FileInputFormat.setMinInputSplitSize((Job)job, (long)Long.MAX_VALUE);
        job.setInputFormatClass(TeraInputFormatWithCRC.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraValidateWithCRC(), (String[])args);
        System.exit(res);
    }

    static class ValidateReducer
    extends Reducer<Text, Text, Text, Text> {
        private boolean firstKey = true;
        private Text lastKey = new Text();
        private Text lastValue = new Text();

        ValidateReducer() {
        }

        public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            if (error.equals((Object)key)) {
                for (Text val : values) {
                    context.write((Object)key, (Object)val);
                }
            } else {
                Text value = values.iterator().next();
                if (this.firstKey) {
                    this.firstKey = false;
                } else if (value.compareTo((BinaryComparable)this.lastValue) < 0) {
                    context.write((Object)error, (Object)new Text("misordered keys last: " + this.lastKey + " '" + this.lastValue + "' current: " + key + " '" + value + "'"));
                }
                this.lastKey.set(key);
                this.lastValue.set(value);
            }
        }
    }

    static class ValidateMapper
    extends Mapper<Text, Text, Text, Text> {
        private Text lastKey;
        private String filename;
        private final int filler_len = 58;
        private final int crc_len = 8;
        private final int rowid_len = 10;

        ValidateMapper() {
        }

        private String getFilename(FileSplit split) {
            return split.getPath().getName();
        }

        public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.lastKey == null) {
                this.filename = this.getFilename((FileSplit)context.getInputSplit());
                context.write((Object)new Text(this.filename + ":begin"), (Object)key);
                this.lastKey = new Text();
            } else if (key.compareTo((BinaryComparable)this.lastKey) < 0) {
                context.write((Object)error, (Object)new Text("misorder in " + this.filename + " last: '" + this.lastKey + "' current: '" + key + "'"));
            }
            this.lastKey.set(key);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.lastKey != null) {
                context.write((Object)new Text(this.filename + ":end"), (Object)this.lastKey);
            }
        }
    }
}

