/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.StaticHostProvider;
import org.junit.Assert;
import org.junit.Test;

public class StaticHostProviderTest
extends ZKTestCase {
    @Test
    public void testNextGoesRound() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider(2);
        InetSocketAddress first = hostProvider.next(0L);
        Assert.assertTrue((boolean)(first instanceof InetSocketAddress));
        hostProvider.next(0L);
        Assert.assertEquals((Object)first, (Object)hostProvider.next(0L));
    }

    @Test
    public void testNextGoesRoundAndSleeps() throws UnknownHostException {
        int size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; --size) {
            hostProvider.next(0L);
        }
        long start = System.currentTimeMillis();
        hostProvider.next(1000L);
        long stop = System.currentTimeMillis();
        Assert.assertTrue((900L <= stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoesNotSleepForZero() throws UnknownHostException {
        int size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; --size) {
            hostProvider.next(0L);
        }
        long start = System.currentTimeMillis();
        hostProvider.next(0L);
        long stop = System.currentTimeMillis();
        Assert.assertTrue((5L > stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testTwoConsequitiveCallsToNextReturnDifferentElement() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider(2);
        Assert.assertNotSame((Object)hostProvider.next(0L), (Object)hostProvider.next(0L));
    }

    @Test
    public void testOnConnectDoesNotReset() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider(2);
        InetSocketAddress first = hostProvider.next(0L);
        hostProvider.onConnected();
        InetSocketAddress second = hostProvider.next(0L);
        Assert.assertNotSame((Object)first, (Object)second);
    }

    private StaticHostProvider getHostProvider(int size) throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            list.add(new InetSocketAddress("10.10.10." + size, 1234));
            --size;
        }
        return new StaticHostProvider(list);
    }
}

