/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotListing {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final long BLOCKSIZE = 1024L;
    private final Path dir = new Path("/test.snapshot/dir");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=15000L)
    public void testListSnapshots() throws Exception {
        int i;
        int sNum;
        Path snapshotsPath = new Path(this.dir, ".snapshot");
        FileStatus[] stats = null;
        stats = this.hdfs.listStatus(new Path("/.snapshot"));
        Assert.assertEquals((long)0L, (long)stats.length);
        try {
            stats = this.hdfs.listStatus(snapshotsPath);
            Assert.fail((String)"expect SnapshotException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + this.dir.toString()), (Throwable)e);
        }
        this.hdfs.allowSnapshot(this.dir);
        stats = this.hdfs.listStatus(snapshotsPath);
        Assert.assertEquals((long)0L, (long)stats.length);
        int snapshotNum = 5;
        for (sNum = 0; sNum < 5; ++sNum) {
            this.hdfs.createSnapshot(this.dir, "s_" + sNum);
            stats = this.hdfs.listStatus(snapshotsPath);
            Assert.assertEquals((long)(sNum + 1), (long)stats.length);
            for (i = 0; i <= sNum; ++i) {
                Assert.assertEquals((Object)("s_" + i), (Object)stats[i].getPath().getName());
            }
        }
        for (sNum = 4; sNum > 0; --sNum) {
            this.hdfs.deleteSnapshot(this.dir, "s_" + sNum);
            stats = this.hdfs.listStatus(snapshotsPath);
            Assert.assertEquals((long)sNum, (long)stats.length);
            for (i = 0; i < sNum; ++i) {
                Assert.assertEquals((Object)("s_" + i), (Object)stats[i].getPath().getName());
            }
        }
        this.hdfs.deleteSnapshot(this.dir, "s_0");
        stats = this.hdfs.listStatus(snapshotsPath);
        Assert.assertEquals((long)0L, (long)stats.length);
    }
}

