/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;

public class MapRFsOutputFile
extends MapOutputFile {
    private static final String MAPR_LOCAL_OUT = "mapr.localoutput.dir";
    private static final String MAPR_LOCAL_SPILL = "mapr.localspill.dir";
    private static final String MAPR_UNCOMPR_SUFFIX = ".U";
    private static final String MAPR_COMPRESS = "mapreduce.maprfs.use.compression";
    static final String MAPR_LOCAL_VOLS = "mapr.localvolumes.path";
    private String localOutputDir = "";
    private String localSpillDir = "";
    private String localUncompressedOutputDir = "";
    private String localUncompressedSpillDir = "";
    private String hostname;
    private JobConf conf;
    private Map<String, String> jobFidRoots;
    boolean useCompression = true;
    String taskUser;
    String taskUserGroup;
    private static final Log LOG = LogFactory.getLog((String)MapRFsOutputFile.class.getName());
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        ByteBuffer serviceData = AuxiliaryServiceHelper.getServiceDataFromEnv((String)"mapr_direct_shuffle", System.getenv());
        if (serviceData != null) {
            DataInputByteBuffer in = new DataInputByteBuffer();
            in.reset(new ByteBuffer[]{serviceData});
            try {
                this.hostname = WritableUtils.readString((DataInput)in);
                int size = WritableUtils.readVInt((DataInput)in);
                this.jobFidRoots = new HashMap<String, String>(size);
                for (int i = 0; i < size; ++i) {
                    String dirName = WritableUtils.readString((DataInput)in);
                    PathId pathId = FileSystem.get((Configuration)conf).createPathId();
                    pathId.readFields((DataInput)in);
                    this.jobFidRoots.put(dirName, pathId.getFid());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Could not parse servicedata", (Throwable)e);
            }
        }
        this.setLocalDirs();
        this.useCompression = this.useMapRCompression();
    }

    public JobConf getConf() {
        return this.conf;
    }

    private boolean useMapRCompression() {
        return this.conf.getBoolean(MAPR_COMPRESS, true);
    }

    private void setLocalDirs() {
        this.localOutputDir = this.getMapRLocalOutputDir();
        this.localSpillDir = this.getMapRLocalSpillDir();
        this.localUncompressedOutputDir = this.getMapRLocalUncompressedOutputDir();
        this.localUncompressedSpillDir = this.getMapRLocalUncompressedSpillDir();
    }

    private Path getMapRTaskSpillDir(JobID jobId, String taskId) {
        return new Path(this.selectMapRJobSpillDir(jobId), taskId);
    }

    private static synchronized String getPartitionFilename(int partition) {
        return "output." + NUMBER_FORMAT.format(partition);
    }

    private String getRelOutputDir(TaskAttemptID mapTaskId) {
        String prefix = this.useCompression ? this.conf.get(MAPR_LOCAL_OUT) : this.conf.get(MAPR_LOCAL_OUT) + MAPR_UNCOMPR_SUFFIX;
        return prefix + "/" + mapTaskId.getJobID().toString() + "/" + mapTaskId.toString();
    }

    private String getRelOutputDir(String mapTaskId) {
        TaskAttemptID taId = TaskAttemptID.forName((String)mapTaskId);
        String prefix = this.useCompression ? this.conf.get(MAPR_LOCAL_OUT) : this.conf.get(MAPR_LOCAL_OUT) + MAPR_UNCOMPR_SUFFIX;
        return prefix + "/" + taId.getJobID().toString() + "/" + mapTaskId;
    }

    private String getRelSpillDir(TaskAttemptID mapTaskId) {
        String prefix = this.useCompression ? this.conf.get(MAPR_LOCAL_SPILL) : this.conf.get(MAPR_LOCAL_SPILL) + MAPR_UNCOMPR_SUFFIX;
        return prefix + "/" + mapTaskId.getJobID().toString() + "/" + mapTaskId.toString();
    }

    private String getRelSpillDir(String mapTaskId) {
        TaskAttemptID taId = TaskAttemptID.forName((String)mapTaskId);
        String prefix = this.useCompression ? this.conf.get(MAPR_LOCAL_SPILL) : this.conf.get(MAPR_LOCAL_SPILL) + MAPR_UNCOMPR_SUFFIX;
        return prefix + "/" + taId.getJobID().toString() + "/" + mapTaskId;
    }

    public Path getOutputFile() throws IOException {
        return null;
    }

    public String getRelOutputFile(TaskAttemptID mapTaskId, int partition) {
        return this.getRelOutputDir(mapTaskId) + "/" + MapRFsOutputFile.getPartitionFilename(partition);
    }

    public Path getOutputFileForWrite(long size) throws IOException {
        TaskAttemptID taId = TaskAttemptID.forName((String)this.conf.get("mapreduce.task.attempt.id"));
        return new Path(this.getMapRTaskOutputDir(taId.getJobID(), this.conf.get("mapreduce.task.attempt.id")), MapRFsOutputFile.getPartitionFilename(-1));
    }

    public Path getOutputFileForWrite(TaskAttemptID mapTaskId, long size, int partition) throws IOException {
        return new Path(this.getMapRTaskOutputDir(mapTaskId.getJobID(), mapTaskId), MapRFsOutputFile.getPartitionFilename(partition));
    }

    public Path getOutputFileForWriteInVolume(Path existing) {
        return null;
    }

    public Path getOutputIndexFile() throws IOException {
        return null;
    }

    public Path getOutputIndexFileForWrite(long size) throws IOException {
        return null;
    }

    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        return null;
    }

    public Path getSpillFile(int spillNumber) throws IOException {
        TaskAttemptID taId = TaskAttemptID.forName((String)this.conf.get("mapreduce.task.attempt.id"));
        return new Path(this.getMapRTaskSpillDir(taId.getJobID(), this.conf.get("mapreduce.task.attempt.id")), "spill" + spillNumber + ".out");
    }

    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        return this.getSpillFile(spillNumber);
    }

    public Path getLocalPathForWrite(String pathStr, long size) {
        TaskAttemptID taId = TaskAttemptID.forName((String)this.conf.get("mapreduce.task.attempt.id"));
        return new Path(this.selectMapRJobSpillDir(taId.getJobID()), pathStr);
    }

    public Path getSpillIndexFile(int spillNumber) throws IOException {
        TaskAttemptID taId = TaskAttemptID.forName((String)this.conf.get("mapreduce.task.attempt.id"));
        return new Path(this.getMapRTaskSpillDir(taId.getJobID(), this.conf.get("mapreduce.task.attempt.id")), "spill" + spillNumber + ".out.index");
    }

    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        return this.getSpillIndexFile(spillNumber);
    }

    public Path getInputFile(int mapId) throws IOException {
        TaskAttemptID taId = TaskAttemptID.forName((String)this.conf.get("mapreduce.task.attempt.id"));
        return new Path(this.getMapRTaskSpillDir(taId.getJobID(), this.conf.get("mapreduce.task.attempt.id")), "map_" + mapId + ".out");
    }

    public Path getInputFileForWrite(TaskID mapId, long size) throws IOException {
        return this.getInputFile(mapId.getId());
    }

    private Path getMapRTaskSpillDir(JobID jobId, TaskAttemptID taskId) {
        return new Path(this.selectMapRJobSpillDir(jobId), taskId.toString());
    }

    public Path getInputFile(int mapId, TaskAttemptID reduceTaskId) throws IOException {
        return new Path(this.getMapRTaskSpillDir(reduceTaskId.getJobID(), reduceTaskId), "map_" + mapId + ".out");
    }

    public Path getInputFileForWrite(TaskID mapId, TaskAttemptID reduceTaskId, long size) throws IOException {
        return this.getInputFile(mapId.getId(), reduceTaskId);
    }

    public void removeAll() throws IOException {
        this.removeAll(true);
    }

    public void removeAll(boolean isSetup) throws IOException {
        if (isSetup) {
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            String[][] fidRelDirs = new String[][]{{this.getSpillFid(), this.getRelSpillDir(this.conf.get("mapreduce.task.attempt.id"))}, {this.getOutputFid(), this.getRelOutputDir(this.conf.get("mapreduce.task.attempt.id"))}};
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cleaning up dirs " + Arrays.toString((Object[])fidRelDirs) + " for " + this.conf.get("mapreduce.task.attempt.id")));
                }
                for (String[] fidDir : fidRelDirs) {
                    fs.deleteFid(fidDir[0], fidDir[1]);
                    String taskDirFid = fs.mkdirsFid(fidDir[0], fidDir[1]);
                    if (this.taskUser == null) continue;
                    fs.setOwnerFid(taskDirFid, this.taskUser, this.taskUserGroup);
                }
            }
            catch (IOException ioe) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Failed to remove directories " + Arrays.toString((Object[])fidRelDirs) + " for " + this.conf.get("mapreduce.task.attempt.id")), (Throwable)ioe);
                }
                throw ioe;
            }
        } else {
            this.taskUser = null;
            this.taskUserGroup = null;
        }
    }

    private String getMapRFsPath() {
        this.conf.set("mapr.host", this.hostname);
        return this.conf.get("mapr.mapred.localvolume.root.dir.path", this.getMapRVolumeMountPoint() + "/nodeManager");
    }

    private String getMapRLocalOutputDir() {
        return this.getMapRFsPath() + "/" + this.conf.get(MAPR_LOCAL_OUT);
    }

    private String getMapRLocalUncompressedOutputDir() {
        return this.getMapRLocalOutputDir() + MAPR_UNCOMPR_SUFFIX;
    }

    private String getMapRLocalSpillDir() {
        return this.getMapRFsPath() + "/" + this.conf.get(MAPR_LOCAL_SPILL);
    }

    private String getMapRLocalUncompressedSpillDir() {
        return this.getMapRLocalSpillDir() + MAPR_UNCOMPR_SUFFIX;
    }

    Path getMapRJobOutputDir(JobID jobId) {
        return new Path(this.localOutputDir, jobId.toString());
    }

    private Path getMapRJobSpillDir(JobID jobId) {
        return new Path(this.localSpillDir, jobId.toString());
    }

    private Path getMapRJobUncompressedOutputDir(JobID jobId) {
        return new Path(this.localUncompressedOutputDir, jobId.toString());
    }

    private Path getMapRJobUncompressedSpillDir(JobID jobId) {
        return new Path(this.localUncompressedSpillDir, jobId.toString());
    }

    private Path selectMapRJobSpillDir(JobID jobId) {
        if (this.useCompression) {
            return this.getMapRJobSpillDir(jobId);
        }
        return this.getMapRJobUncompressedSpillDir(jobId);
    }

    private Path getMapRTaskOutputDir(JobID jobId, String taskId) {
        return new Path(this.useCompression ? this.getMapRJobOutputDir(jobId) : this.getMapRJobUncompressedOutputDir(jobId), taskId);
    }

    private Path getMapRTaskOutputDir(JobID jobId, TaskAttemptID taskId) {
        return new Path(this.useCompression ? this.getMapRJobOutputDir(jobId) : this.getMapRJobUncompressedOutputDir(jobId), taskId.toString());
    }

    public String getOutputFid() {
        return this.useCompression ? this.jobFidRoots.get(this.conf.get(MAPR_LOCAL_OUT)) : this.jobFidRoots.get(this.conf.get(MAPR_LOCAL_OUT) + MAPR_UNCOMPR_SUFFIX);
    }

    public String getSpillFid() {
        return this.useCompression ? this.jobFidRoots.get(this.conf.get(MAPR_LOCAL_SPILL)) : this.jobFidRoots.get(this.conf.get(MAPR_LOCAL_SPILL) + MAPR_UNCOMPR_SUFFIX);
    }

    public String getSpillFileForWriteFid(TaskAttemptID mapTaskId, int spillNumber, long size) throws IOException {
        return mapTaskId + "/" + "spill" + spillNumber + ".out";
    }

    public String getOutputFileForWriteFid(TaskAttemptID mapTaskId, long size, int partition) throws IOException {
        return mapTaskId + "/" + MapRFsOutputFile.getPartitionFilename(partition);
    }

    public void setUser(String userName, String groupName) {
        this.taskUser = userName;
        this.taskUserGroup = groupName;
    }

    String getMapRVolumeMountPoint() {
        return this.conf.get("mapr.mapred.localvolume.mount.path", "/var/mapr/local/" + this.hostname + "/mapred");
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }

    static enum FidId {
        ROOT,
        OUTPUT,
        OUTPUT_U,
        SPILL,
        SPILL_U;

    }
}

