/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.DistCpUtils;

public class SimpleCopyListing
extends CopyListing {
    private static final Log LOG = LogFactory.getLog(SimpleCopyListing.class);
    private long totalPaths = 0L;
    private long totalBytesToCopy = 0L;

    protected SimpleCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
    }

    @Override
    protected void validatePaths(DistCpOptions options) throws IOException, CopyListing.InvalidInputException {
        Path targetPath = options.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(this.getConf());
        boolean targetIsFile = targetFS.isFile(targetPath);
        if (targetIsFile) {
            if (options.getSourcePaths().size() > 1) {
                throw new CopyListing.InvalidInputException("Multiple source being copied to a file: " + targetPath);
            }
            Path srcPath = options.getSourcePaths().get(0);
            FileSystem sourceFS = srcPath.getFileSystem(this.getConf());
            if (!sourceFS.isFile(srcPath)) {
                throw new CopyListing.InvalidInputException("Cannot copy " + srcPath + ", which is not a file to " + targetPath);
            }
        }
        if (options.shouldAtomicCommit() && targetFS.exists(targetPath)) {
            throw new CopyListing.InvalidInputException("Target path for atomic-commit already exists: " + targetPath + ". Cannot atomic-commit to pre-existing target-path.");
        }
        for (Path path : options.getSourcePaths()) {
            FileSystem fs = path.getFileSystem(this.getConf());
            if (fs.exists(path)) continue;
            throw new CopyListing.InvalidInputException(path + " doesn't exist");
        }
        Credentials credentials = this.getCredentials();
        if (credentials != null) {
            Path[] inputPaths = options.getSourcePaths().toArray(new Path[1]);
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])inputPaths, (Configuration)this.getConf());
        }
    }

    @Override
    public void doBuildListing(Path pathToListingFile, DistCpOptions options) throws IOException {
        this.doBuildListing(this.getWriter(pathToListingFile), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doBuildListing(SequenceFile.Writer fileListWriter, DistCpOptions options) throws IOException {
        try {
            for (Path path : options.getSourcePaths()) {
                boolean explore;
                FileSystem sourceFS = path.getFileSystem(this.getConf());
                path = this.makeQualified(path);
                FileStatus rootStatus = sourceFS.getFileStatus(path);
                Path sourcePathRoot = this.computeSourceRootPath(rootStatus, options);
                FileStatus[] sourceFiles = sourceFS.listStatus(path);
                boolean bl = explore = sourceFiles != null && sourceFiles.length > 0;
                if (!explore || rootStatus.isDirectory()) {
                    CopyListingFileStatus rootCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, rootStatus, options.shouldPreserve(DistCpOptions.FileAttribute.ACL), options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
                    this.writeToFileListingRoot(fileListWriter, rootCopyListingStatus, sourcePathRoot, options);
                }
                if (!explore) continue;
                for (FileStatus sourceStatus : sourceFiles) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Recording source-path: " + sourceStatus.getPath() + " for copy."));
                    }
                    CopyListingFileStatus sourceCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, sourceStatus, options.shouldPreserve(DistCpOptions.FileAttribute.ACL) && sourceStatus.isDirectory(), options.shouldPreserve(DistCpOptions.FileAttribute.XATTR) && sourceStatus.isDirectory());
                    this.writeToFileListing(fileListWriter, sourceCopyListingStatus, sourcePathRoot, options);
                    if (!SimpleCopyListing.isDirectoryAndNotEmpty(sourceFS, sourceStatus)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Traversing non-empty source dir: " + sourceStatus.getPath()));
                    }
                    this.traverseNonEmptyDirectory(fileListWriter, sourceStatus, sourcePathRoot, options);
                }
            }
            fileListWriter.close();
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private Path computeSourceRootPath(FileStatus sourceStatus, DistCpOptions options) throws IOException {
        boolean solitaryFile;
        Path target = options.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean targetPathExists = options.getTargetPathExists();
        boolean bl = solitaryFile = options.getSourcePaths().size() == 1 && !sourceStatus.isDirectory();
        if (solitaryFile) {
            if (targetFS.isFile(target) || !targetPathExists) {
                return sourceStatus.getPath();
            }
            return sourceStatus.getPath().getParent();
        }
        boolean specialHandling = options.getSourcePaths().size() == 1 && !targetPathExists || options.shouldSyncFolder() || options.shouldOverwrite();
        return specialHandling && sourceStatus.isDirectory() ? sourceStatus.getPath() : sourceStatus.getPath().getParent();
    }

    protected boolean shouldCopy(Path path, DistCpOptions options) {
        return true;
    }

    @Override
    protected long getBytesToCopy() {
        return this.totalBytesToCopy;
    }

    @Override
    protected long getNumberOfPaths() {
        return this.totalPaths;
    }

    private Path makeQualified(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(this.getConf());
        if (fs.exists(pathToListFile)) {
            fs.delete(pathToListFile, false);
        }
        return SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CopyListingFileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
    }

    private static boolean isDirectoryAndNotEmpty(FileSystem fileSystem, FileStatus fileStatus) throws IOException {
        return fileStatus.isDirectory() && SimpleCopyListing.getChildren(fileSystem, fileStatus).length > 0;
    }

    private static FileStatus[] getChildren(FileSystem fileSystem, FileStatus parent) throws IOException {
        return fileSystem.listStatus(parent.getPath());
    }

    private void traverseNonEmptyDirectory(SequenceFile.Writer fileListWriter, FileStatus sourceStatus, Path sourcePathRoot, DistCpOptions options) throws IOException {
        FileSystem sourceFS = sourcePathRoot.getFileSystem(this.getConf());
        Stack<FileStatus> pathStack = new Stack<FileStatus>();
        pathStack.push(sourceStatus);
        while (!pathStack.isEmpty()) {
            for (FileStatus child : SimpleCopyListing.getChildren(sourceFS, (FileStatus)pathStack.pop())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Recording source-path: " + sourceStatus.getPath() + " for copy."));
                }
                CopyListingFileStatus childCopyListingStatus = DistCpUtils.toCopyListingFileStatus(sourceFS, child, options.shouldPreserve(DistCpOptions.FileAttribute.ACL) && child.isDirectory(), options.shouldPreserve(DistCpOptions.FileAttribute.XATTR) && child.isDirectory());
                this.writeToFileListing(fileListWriter, childCopyListingStatus, sourcePathRoot, options);
                if (!SimpleCopyListing.isDirectoryAndNotEmpty(sourceFS, child)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Traversing non-empty source dir: " + sourceStatus.getPath()));
                }
                pathStack.push(child);
            }
        }
    }

    private void writeToFileListingRoot(SequenceFile.Writer fileListWriter, CopyListingFileStatus fileStatus, Path sourcePathRoot, DistCpOptions options) throws IOException {
        boolean syncOrOverwrite;
        boolean bl = syncOrOverwrite = options.shouldSyncFolder() || options.shouldOverwrite();
        if (fileStatus.getPath().equals((Object)sourcePathRoot) && fileStatus.isDirectory() && syncOrOverwrite) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip " + fileStatus.getPath()));
            }
            return;
        }
        this.writeToFileListing(fileListWriter, fileStatus, sourcePathRoot, options);
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, CopyListingFileStatus fileStatus, Path sourcePathRoot, DistCpOptions options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("REL PATH: " + DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath()) + ", FULL PATH: " + fileStatus.getPath()));
        }
        CopyListingFileStatus status = fileStatus;
        if (!this.shouldCopy(fileStatus.getPath(), options)) {
            return;
        }
        fileListWriter.append((Writable)new Text(DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath())), (Writable)status);
        fileListWriter.sync();
        if (!fileStatus.isDirectory()) {
            this.totalBytesToCopy += fileStatus.getLen();
        }
        ++this.totalPaths;
    }
}

