/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQuotasWithHA {
    private static final Path TEST_DIR = new Path("/test");
    private static final Path TEST_FILE = new Path(TEST_DIR, "file");
    private static final String TEST_DIR_STR = TEST_DIR.toUri().getPath();
    private static final long NS_QUOTA = 10000L;
    private static final long DS_QUOTA = 10000L;
    private static final long BLOCK_SIZE = 1024L;
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;

    @Before
    public void setupCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setLong("dfs.blocksize", 1024L);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, conf);
        this.cluster.transitionToActive(0);
    }

    @After
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testQuotasTrackedOnStandby() throws Exception {
        this.fs.mkdirs(TEST_DIR);
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.setQuota(TEST_DIR, 10000L, 10000L);
        long expectedSize = 3584L;
        DFSTestUtil.createFile(this.fs, TEST_FILE, expectedSize, (short)1, 1L);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        ContentSummary cs = this.nn1.getRpcServer().getContentSummary(TEST_DIR_STR);
        Assert.assertEquals((long)10000L, (long)cs.getQuota());
        Assert.assertEquals((long)10000L, (long)cs.getSpaceQuota());
        Assert.assertEquals((long)expectedSize, (long)cs.getSpaceConsumed());
        Assert.assertEquals((long)1L, (long)cs.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)cs.getFileCount());
        FSDataOutputStream stm = this.fs.append(TEST_FILE);
        try {
            byte[] data = new byte[1536];
            stm.write(data);
            expectedSize += (long)data.length;
        }
        finally {
            IOUtils.closeStream((Closeable)stm);
        }
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        cs = this.nn1.getRpcServer().getContentSummary(TEST_DIR_STR);
        Assert.assertEquals((long)10000L, (long)cs.getQuota());
        Assert.assertEquals((long)10000L, (long)cs.getSpaceQuota());
        Assert.assertEquals((long)expectedSize, (long)cs.getSpaceConsumed());
        Assert.assertEquals((long)1L, (long)cs.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)cs.getFileCount());
        this.fs.delete(TEST_FILE, true);
        expectedSize = 0L;
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        cs = this.nn1.getRpcServer().getContentSummary(TEST_DIR_STR);
        Assert.assertEquals((long)10000L, (long)cs.getQuota());
        Assert.assertEquals((long)10000L, (long)cs.getSpaceQuota());
        Assert.assertEquals((long)expectedSize, (long)cs.getSpaceConsumed());
        Assert.assertEquals((long)1L, (long)cs.getDirectoryCount());
        Assert.assertEquals((long)0L, (long)cs.getFileCount());
    }
}

