/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FsDatasetCache {
    private static final Log LOG = LogFactory.getLog(FsDatasetCache.class);
    private final HashMap<ExtendedBlockId, Value> mappableBlockMap = new HashMap();
    private final AtomicLong numBlocksCached = new AtomicLong(0L);
    private final FsDatasetImpl dataset;
    private final ThreadPoolExecutor uncachingExecutor;
    private final UsedBytesCount usedBytesCount;
    private final long maxBytes;
    final AtomicLong numBlocksFailedToCache = new AtomicLong(0L);
    final AtomicLong numBlocksFailedToUncache = new AtomicLong(0L);

    public FsDatasetCache(FsDatasetImpl dataset) {
        this.dataset = dataset;
        this.maxBytes = dataset.datanode.getDnConf().getMaxLockedMemory();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FsDatasetCache-%d-" + dataset.toString()).build();
        this.usedBytesCount = new UsedBytesCount();
        this.uncachingExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), workerFactory);
        this.uncachingExecutor.allowCoreThreadTimeOut(true);
    }

    synchronized List<Long> getCachedBlocks(String bpid) {
        ArrayList<Long> blocks = new ArrayList<Long>();
        for (Map.Entry<ExtendedBlockId, Value> entry : this.mappableBlockMap.entrySet()) {
            if (!entry.getKey().getBlockPoolId().equals(bpid) || !entry.getValue().state.shouldAdvertise()) continue;
            blocks.add(entry.getKey().getBlockId());
        }
        return blocks;
    }

    synchronized void cacheBlock(long blockId, String bpid, String blockFileName, long length, long genstamp, Executor volumeExecutor) {
        ExtendedBlockId key = new ExtendedBlockId(blockId, bpid);
        Value prevValue = this.mappableBlockMap.get(key);
        if (prevValue != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Block with id " + blockId + ", pool " + bpid + " already exists in the FsDatasetCache with state " + (Object)((Object)prevValue.state)));
            }
            this.numBlocksFailedToCache.incrementAndGet();
            return;
        }
        this.mappableBlockMap.put(key, new Value(null, State.CACHING));
        volumeExecutor.execute(new CachingTask(key, blockFileName, length, genstamp));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initiating caching for Block with id " + blockId + ", pool " + bpid));
        }
    }

    synchronized void uncacheBlock(String bpid, long blockId) {
        ExtendedBlockId key = new ExtendedBlockId(blockId, bpid);
        Value prevValue = this.mappableBlockMap.get(key);
        if (!this.dataset.datanode.getShortCircuitRegistry().processBlockMunlockRequest(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(key + " is anchored, and can't be uncached now."));
            }
            return;
        }
        if (prevValue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Block with id " + blockId + ", pool " + bpid + " " + "does not need to be uncached, because it is not currently " + "in the mappableBlockMap."));
            }
            this.numBlocksFailedToUncache.incrementAndGet();
            return;
        }
        switch (prevValue.state) {
            case CACHING: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cancelling caching for block with id " + blockId + ", pool " + bpid + "."));
                }
                this.mappableBlockMap.put(key, new Value(prevValue.mappableBlock, State.CACHING_CANCELLED));
                break;
            }
            case CACHED: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Block with id " + blockId + ", pool " + bpid + " " + "has been scheduled for uncaching."));
                }
                this.mappableBlockMap.put(key, new Value(prevValue.mappableBlock, State.UNCACHING));
                this.uncachingExecutor.execute(new UncachingTask(key));
                break;
            }
            default: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Block with id " + blockId + ", pool " + bpid + " " + "does not need to be uncached, because it is " + "in state " + (Object)((Object)prevValue.state) + "."));
                }
                this.numBlocksFailedToUncache.incrementAndGet();
            }
        }
    }

    public long getCacheUsed() {
        return this.usedBytesCount.get();
    }

    public long getCacheCapacity() {
        return this.maxBytes;
    }

    public long getNumBlocksFailedToCache() {
        return this.numBlocksFailedToCache.get();
    }

    public long getNumBlocksFailedToUncache() {
        return this.numBlocksFailedToUncache.get();
    }

    public long getNumBlocksCached() {
        return this.numBlocksCached.get();
    }

    public synchronized boolean isCached(String bpid, long blockId) {
        ExtendedBlockId block = new ExtendedBlockId(blockId, bpid);
        Value val = this.mappableBlockMap.get(block);
        return val != null && val.state.shouldAdvertise();
    }

    private class UncachingTask
    implements Runnable {
        private final ExtendedBlockId key;

        UncachingTask(ExtendedBlockId key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Value value;
            FsDatasetCache fsDatasetCache = FsDatasetCache.this;
            synchronized (fsDatasetCache) {
                value = (Value)FsDatasetCache.this.mappableBlockMap.get(this.key);
            }
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkArgument((value.state == State.UNCACHING ? 1 : 0) != 0);
            IOUtils.closeQuietly((Closeable)value.mappableBlock);
            fsDatasetCache = FsDatasetCache.this;
            synchronized (fsDatasetCache) {
                FsDatasetCache.this.mappableBlockMap.remove(this.key);
            }
            long newUsedBytes = FsDatasetCache.this.usedBytesCount.release(value.mappableBlock.getLength());
            FsDatasetCache.this.numBlocksCached.addAndGet(-1L);
            ((FsDatasetCache)FsDatasetCache.this).dataset.datanode.getMetrics().incrBlocksUncached(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Uncaching of " + this.key + " completed.  " + "usedBytes = " + newUsedBytes));
            }
        }
    }

    private class CachingTask
    implements Runnable {
        private final ExtendedBlockId key;
        private final String blockFileName;
        private final long length;
        private final long genstamp;

        CachingTask(ExtendedBlockId key, String blockFileName, long length, long genstamp) {
            this.key = key;
            this.blockFileName = blockFileName;
            this.length = length;
            this.genstamp = genstamp;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class UsedBytesCount {
        private final AtomicLong usedBytes = new AtomicLong(0L);
        private final PageRounder rounder = new PageRounder();

        private UsedBytesCount() {
        }

        long reserve(long count) {
            long next;
            long cur;
            count = this.rounder.round(count);
            do {
                if ((next = (cur = this.usedBytes.get()) + count) <= FsDatasetCache.this.maxBytes) continue;
                return -1L;
            } while (!this.usedBytes.compareAndSet(cur, next));
            return next;
        }

        long release(long count) {
            count = this.rounder.round(count);
            return this.usedBytes.addAndGet(-count);
        }

        long get() {
            return this.usedBytes.get();
        }
    }

    public static class PageRounder {
        private final long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();

        public long round(long count) {
            long newCount = (count + (this.osPageSize - 1L)) / this.osPageSize;
            return newCount * this.osPageSize;
        }
    }

    private static enum State {
        CACHING,
        CACHING_CANCELLED,
        CACHED,
        UNCACHING;


        public boolean shouldAdvertise() {
            return this == CACHED;
        }
    }

    private static final class Value {
        final State state;
        final MappableBlock mappableBlock;

        Value(MappableBlock mappableBlock, State state) {
            this.mappableBlock = mappableBlock;
            this.state = state;
        }
    }
}

