/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private static final String _known_hosts = "known_hosts";
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private MAC hmacsha1 = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = "\n".getBytes();

    KnownHosts(JSch jSch) {
        this.jsch = jSch;
        this.pool = new Vector();
    }

    void setKnownHosts(String string) throws JSchException {
        try {
            this.known_hosts = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.setKnownHosts(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    void setKnownHosts(InputStream inputStream) throws JSchException {
        this.pool.removeAllElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            InputStream inputStream2 = inputStream;
            String string = null;
            byte[] byArray = new byte[1024];
            int n = 0;
            block2: while (true) {
                byte by;
                Object object;
                int n2;
                n = 0;
                while (true) {
                    if ((n2 = inputStream2.read()) == -1) {
                        if (n != 0) break;
                        break block2;
                    }
                    if (n2 == 13) continue;
                    if (n2 == 10) break;
                    if (byArray.length <= n) {
                        if (n > 10240) break;
                        object = new byte[byArray.length * 2];
                        System.arraycopy(byArray, 0, object, 0, byArray.length);
                        byArray = object;
                    }
                    byArray[n++] = (byte)n2;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    by = byArray[n2];
                    if (by == 32 || by == 9) {
                        continue;
                    }
                    if (by != 35) break;
                    this.addInvalidLine(new String(byArray, 0, n));
                    continue block2;
                }
                if (n2 >= n) {
                    this.addInvalidLine(new String(byArray, 0, n));
                    continue;
                }
                stringBuffer.setLength(0);
                while (n2 < n) {
                    if ((by = byArray[n2++]) == 32 || by == 9) break;
                    stringBuffer.append((char)by);
                }
                String string2 = stringBuffer.toString();
                if (n2 >= n || string2.length() == 0) {
                    this.addInvalidLine(new String(byArray, 0, n));
                    continue;
                }
                stringBuffer.setLength(0);
                int n3 = -1;
                while (n2 < n) {
                    if ((by = byArray[n2++]) == 32 || by == 9) break;
                    stringBuffer.append((char)by);
                }
                if (stringBuffer.toString().equals("ssh-dss")) {
                    n3 = 1;
                } else if (stringBuffer.toString().equals("ssh-rsa")) {
                    n3 = 2;
                } else {
                    n2 = n;
                }
                if (n2 >= n) {
                    this.addInvalidLine(new String(byArray, 0, n));
                    continue;
                }
                stringBuffer.setLength(0);
                while (n2 < n) {
                    if ((by = byArray[n2++]) == 13) continue;
                    if (by == 10) break;
                    stringBuffer.append((char)by);
                }
                string = stringBuffer.toString();
                if (string.length() == 0) {
                    this.addInvalidLine(new String(byArray, 0, n));
                    continue;
                }
                object = null;
                object = new HashedHostKey(string2, n3, Util.fromBase64(string.getBytes(), 0, string.length()));
                this.pool.addElement(object);
            }
            inputStream2.close();
            if (bl) {
                throw new JSchException("KnownHosts: invalid format");
            }
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    private void addInvalidLine(String string) throws JSchException {
        HostKey hostKey = new HostKey(string, 3, null);
        this.pool.addElement(hostKey);
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int check(String string, byte[] byArray) {
        int n = 1;
        if (string == null) {
            return n;
        }
        int n2 = this.getType(byArray);
        Vector vector = this.pool;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n3);
                if (hostKey.isMatched(string) && hostKey.type == n2) {
                    if (Util.array_equals(hostKey.key, byArray)) {
                        return 0;
                    }
                    n = 2;
                }
                ++n3;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HostKey hostKey, UserInfo userInfo) {
        int n = hostKey.type;
        String string = hostKey.getHost();
        byte[] byArray = hostKey.key;
        HostKey hostKey2 = null;
        Vector vector = this.pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.pool.size()) {
                hostKey2 = (HostKey)this.pool.elementAt(n2);
                if (!hostKey2.isMatched(string) || hostKey2.type == n) {
                    // empty if block
                }
                ++n2;
            }
        }
        hostKey2 = hostKey;
        this.pool.addElement(hostKey2);
        String string2 = this.getKnownHostsRepositoryID();
        if (string2 != null) {
            boolean bl = true;
            File file = new File(string2);
            if (!file.exists()) {
                bl = false;
                if (userInfo != null) {
                    bl = userInfo.promptYesNo(string2 + " does not exist.\n" + "Are you sure you want to create it?");
                    file = file.getParentFile();
                    if (bl && file != null && !file.exists() && (bl = userInfo.promptYesNo("The parent directory " + file + " does not exist.\n" + "Are you sure you want to create it?"))) {
                        if (!file.mkdirs()) {
                            userInfo.showMessage(file + " has not been created.");
                            bl = false;
                        } else {
                            userInfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (file == null) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                try {
                    this.sync(string2);
                }
                catch (Exception exception) {
                    System.err.println("sync known_hosts: " + exception);
                }
            }
        }
    }

    public HostKey[] getHostKey() {
        return this.getHostKey(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostKey[] getHostKey(String string, String string2) {
        Vector vector = this.pool;
        synchronized (vector) {
            Object object;
            int n;
            block8: {
                HostKey hostKey;
                n = 0;
                int n2 = 0;
                while (n2 < this.pool.size()) {
                    hostKey = (HostKey)this.pool.elementAt(n2);
                    if (hostKey.type != 3 && (string == null || hostKey.isMatched(string) && (string2 == null || hostKey.getType().equals(string2)))) {
                        ++n;
                    }
                    ++n2;
                }
                if (n != 0) break block8;
                hostKey = null;
                return hostKey;
            }
            HostKey[] hostKeyArray = new HostKey[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.pool.size()) {
                object = (HostKey)this.pool.elementAt(n4);
                if (((HostKey)object).type != 3 && (string == null || ((HostKey)object).isMatched(string) && (string2 == null || ((HostKey)object).getType().equals(string2)))) {
                    hostKeyArray[n3++] = object;
                }
                ++n4;
            }
            object = hostKeyArray;
            return object;
        }
    }

    public void remove(String string, String string2) {
        this.remove(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string, String string2, byte[] byArray) {
        boolean bl = false;
        Vector vector = this.pool;
        synchronized (vector) {
            int n = 0;
            while (n < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n);
                if (string == null || hostKey.isMatched(string) && (string2 == null || hostKey.getType().equals(string2) && (byArray == null || Util.array_equals(byArray, hostKey.key)))) {
                    String string3 = hostKey.getHost();
                    if (string3.equals(string) || hostKey instanceof HashedHostKey && ((HashedHostKey)hostKey).isHashed()) {
                        this.pool.removeElement(hostKey);
                    } else {
                        hostKey.host = this.deleteSubString(string3, string);
                    }
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            try {
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    protected synchronized void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream outputStream) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                int n = 0;
                while (n < this.pool.size()) {
                    HostKey hostKey = (HostKey)this.pool.elementAt(n);
                    String string = hostKey.getHost();
                    String string2 = hostKey.getType();
                    if (string2.equals("UNKNOWN")) {
                        outputStream.write(string.getBytes());
                        outputStream.write(cr);
                    } else {
                        outputStream.write(string.getBytes());
                        outputStream.write(space);
                        outputStream.write(string2.getBytes());
                        outputStream.write(space);
                        outputStream.write(hostKey.getKey().getBytes());
                        outputStream.write(cr);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private int getType(byte[] byArray) {
        if (byArray[8] == 100) {
            return 1;
        }
        if (byArray[8] == 114) {
            return 2;
        }
        return 3;
    }

    private String deleteSubString(String string, String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 == -1) break;
            if (!string2.equals(string.substring(n, n4))) {
                n = n4 + 1;
                continue;
            }
            return string.substring(0, n) + string.substring(n4 + 1);
        }
        if (string.endsWith(string2) && n3 - n == n2) {
            return string.substring(0, n2 == n3 ? 0 : n3 - n2 - 1);
        }
        return string;
    }

    private synchronized MAC getHMACSHA1() {
        if (this.hmacsha1 == null) {
            try {
                Class<?> clazz = Class.forName(JSch.getConfig("hmac-sha1"));
                this.hmacsha1 = (MAC)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("hmacsha1: " + exception);
            }
        }
        return this.hmacsha1;
    }

    HostKey createHashedHostKey(String string, byte[] byArray) throws JSchException {
        HashedHostKey hashedHostKey = new HashedHostKey(string, byArray);
        hashedHostKey.hash();
        return hashedHostKey;
    }

    class HashedHostKey
    extends HostKey {
        private static final String HASH_MAGIC = "|1|";
        private static final String HASH_DELIM = "|";
        private boolean hashed = false;
        byte[] salt = null;
        byte[] hash = null;

        HashedHostKey(String string, byte[] byArray) throws JSchException {
            this(string, 0, byArray);
        }

        HashedHostKey(String string, int n, byte[] byArray) throws JSchException {
            super(string, n, byArray);
            if (this.host.startsWith(HASH_MAGIC) && this.host.substring(HASH_MAGIC.length()).indexOf(HASH_DELIM) > 0) {
                String string2 = this.host.substring(HASH_MAGIC.length());
                String string3 = string2.substring(0, string2.indexOf(HASH_DELIM));
                String string4 = string2.substring(string2.indexOf(HASH_DELIM) + 1);
                this.salt = Util.fromBase64(string3.getBytes(), 0, string3.length());
                this.hash = Util.fromBase64(string4.getBytes(), 0, string4.length());
                if (this.salt.length != 20 || this.hash.length != 20) {
                    this.salt = null;
                    this.hash = null;
                    return;
                }
                this.hashed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isMatched(String string) {
            if (!this.hashed) {
                return super.isMatched(string);
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            try {
                MAC mAC2 = mAC;
                synchronized (mAC2) {
                    mAC.init(this.salt);
                    byte[] byArray = string.getBytes();
                    mAC.update(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[mAC.getBlockSize()];
                    mAC.doFinal(byArray2, 0);
                    boolean bl = Util.array_equals(this.hash, byArray2);
                    return bl;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                return false;
            }
        }

        boolean isHashed() {
            return this.hashed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void hash() {
            Object object;
            Object object2;
            if (this.hashed) {
                return;
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            if (this.salt == null) {
                object = object2 = Session.random;
                synchronized (object) {
                    this.salt = new byte[mAC.getBlockSize()];
                    object2.fill(this.salt, 0, this.salt.length);
                }
            }
            try {
                object2 = mAC;
                synchronized (object2) {
                    mAC.init(this.salt);
                    object = this.host.getBytes();
                    mAC.update((byte[])object, 0, ((Object)object).length);
                    this.hash = new byte[mAC.getBlockSize()];
                    mAC.doFinal(this.hash, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = HASH_MAGIC + new String(Util.toBase64(this.salt, 0, this.salt.length)) + HASH_DELIM + new String(Util.toBase64(this.hash, 0, this.hash.length));
            this.hashed = true;
        }
    }
}

