/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.apache.hadoop.portmap.PortmapResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

final class RpcProgramPortmap
extends IdleStateAwareChannelUpstreamHandler {
    static final int PROGRAM = 100000;
    static final int VERSION = 2;
    static final int PMAPPROC_NULL = 0;
    static final int PMAPPROC_SET = 1;
    static final int PMAPPROC_UNSET = 2;
    static final int PMAPPROC_GETPORT = 3;
    static final int PMAPPROC_DUMP = 4;
    static final int PMAPPROC_GETVERSADDR = 9;
    private static final Log LOG = LogFactory.getLog(RpcProgramPortmap.class);
    private final ConcurrentHashMap<String, PortmapMapping> map = new ConcurrentHashMap();
    private final ChannelGroup allChannels;

    RpcProgramPortmap(ChannelGroup allChannels) {
        this.allChannels = allChannels;
        PortmapMapping m = new PortmapMapping(100000, 2, 6, 111);
        PortmapMapping m1 = new PortmapMapping(100000, 2, 17, 111);
        this.map.put(PortmapMapping.key(m), m);
        this.map.put(PortmapMapping.key(m1), m1);
    }

    private XDR nullOp(int xid, XDR in, XDR out) {
        return PortmapResponse.voidReply(out, xid);
    }

    private XDR set(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap set key=" + key));
        }
        this.map.put(key, mapping);
        return PortmapResponse.intReply(out, xid, mapping.getPort());
    }

    private XDR unset(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap remove key=" + key));
        }
        this.map.remove(key);
        return PortmapResponse.booleanReply(out, xid, true);
    }

    private XDR getport(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap GETPORT key=" + key + " " + mapping));
        }
        PortmapMapping value = this.map.get(key);
        int res = 0;
        if (value != null) {
            res = value.getPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found mapping for key: " + key + " port:" + res));
            }
        } else {
            LOG.warn((Object)("Warning, no mapping for key: " + key));
        }
        return PortmapResponse.intReply(out, xid, res);
    }

    private XDR dump(int xid, XDR in, XDR out) {
        PortmapMapping[] pmapList = this.map.values().toArray(new PortmapMapping[0]);
        return PortmapResponse.pmapList(out, xid, pmapList);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RpcInfo info = (RpcInfo)e.getMessage();
        RpcCall rpcCall = (RpcCall)info.header();
        int portmapProc = rpcCall.getProcedure();
        int xid = rpcCall.getXid();
        XDR in = new XDR(info.data().toByteBuffer().asReadOnlyBuffer(), XDR.State.READING);
        XDR out = new XDR();
        if (portmapProc == 0) {
            out = this.nullOp(xid, in, out);
        } else if (portmapProc == 1) {
            out = this.set(xid, in, out);
        } else if (portmapProc == 2) {
            out = this.unset(xid, in, out);
        } else if (portmapProc == 4) {
            out = this.dump(xid, in, out);
        } else if (portmapProc == 3) {
            out = this.getport(xid, in, out);
        } else if (portmapProc == 9) {
            out = this.getport(xid, in, out);
        } else {
            LOG.info((Object)("PortmapHandler unknown rpc procedure=" + portmapProc));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance(xid, RpcAcceptedReply.AcceptState.PROC_UNAVAIL, new VerifierNone());
            reply.write(out);
        }
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.allChannels.add((Object)e.getChannel());
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (e.getState() == IdleState.ALL_IDLE) {
            e.getChannel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.warn((Object)"Encountered ", e.getCause());
        e.getChannel().close();
    }
}

