/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingUpgrade {
    private static final Log LOG = LogFactory.getLog(TestRollingUpgrade.class);

    public static void runCmd(DFSAdmin dfsadmin, boolean success, String ... args) throws Exception {
        if (success) {
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args));
        } else {
            Assert.assertTrue((dfsadmin.run(args) != 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminRollingUpgradeCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            Path baz = new Path("/baz");
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            dfs.mkdirs(foo);
            TestRollingUpgrade.runCmd(dfsadmin, false, "-rollingUpgrade", "abc");
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "query");
            dfs.mkdirs(bar);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
            dfs.mkdirs(baz);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(new String[0]);
            dfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static Configuration setConf(Configuration conf, File dir, MiniJournalCluster mjc) {
        conf.set("dfs.namenode.name.dir", dir.getAbsolutePath());
        conf.set("dfs.namenode.edits.dir", mjc.getQuorumJournalURI("myjournal").toString());
        conf.setLong("dfs.namenode.checkpoint.txns", 0L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRollingUpgradeWithQJM() throws Exception {
        String nnDirPrefix = MiniDFSCluster.getBaseDirectory() + "/nn/";
        File nn1Dir = new File(nnDirPrefix + "image1");
        File nn2Dir = new File(nnDirPrefix + "image2");
        LOG.info((Object)("nn1Dir=" + nn1Dir));
        LOG.info((Object)("nn2Dir=" + nn2Dir));
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniJournalCluster mjc = new MiniJournalCluster.Builder((Configuration)conf).build();
        TestRollingUpgrade.setConf((Configuration)conf, nn1Dir, mjc);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
        cluster.shutdown();
        MiniDFSCluster cluster2 = null;
        try {
            FileUtil.fullyDelete((File)nn2Dir);
            FileUtil.copy((File)nn1Dir, (FileSystem)FileSystem.getLocal((Configuration)conf).getRaw(), (Path)new Path(nn2Dir.getAbsolutePath()), (boolean)false, (Configuration)conf);
            MiniDFSCluster cluster3 = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            Path baz = new Path("/baz");
            DistributedFileSystem dfs = cluster3.getFileSystem();
            dfs.mkdirs(foo);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            RollingUpgradeInfo info1 = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            LOG.info((Object)("START\n" + info1));
            Assert.assertEquals((Object)info1, (Object)dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            dfs.mkdirs(bar);
            cluster3.shutdown();
            Configuration conf2 = TestRollingUpgrade.setConf(new Configuration(), nn2Dir, mjc);
            cluster2 = new MiniDFSCluster.Builder(conf2).numDataNodes(0).format(false).manageNameDfsDirs(false).build();
            DistributedFileSystem dfs2 = cluster2.getFileSystem();
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertFalse((boolean)dfs2.exists(baz));
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            dfs2.mkdirs(baz);
            LOG.info((Object)"RESTART cluster 2");
            cluster2.restartNameNode(new String[0]);
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
            try {
                cluster2.restartNameNode("-upgrade");
            }
            catch (IOException e) {
                LOG.info((Object)"The exception is expected.", (Throwable)e);
            }
            LOG.info((Object)"RESTART cluster 2 again");
            cluster2.restartNameNode(new String[0]);
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
            RollingUpgradeInfo finalize = dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
            LOG.info((Object)("FINALIZE: " + finalize));
            Assert.assertEquals((long)info1.getStartTime(), (long)finalize.getStartTime());
            LOG.info((Object)"RESTART cluster 2 with regular startup option");
            cluster2.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster2.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
        }
        finally {
            if (cluster2 != null) {
                cluster2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            cluster.getFileSystem().mkdirs(foo);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            cluster.getFileSystem().rollEdits();
            cluster.getFileSystem().rollEdits();
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            cluster.getFileSystem().rollEdits();
            cluster.getFileSystem().rollEdits();
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            cluster.restartNameNode(new String[0]);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            cluster.restartNameNode(new String[0]);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, cluster);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, cluster);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void startRollingUpgrade(Path foo, Path bar, MiniDFSCluster cluster) throws IOException {
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        dfs.mkdirs(bar);
        Assert.assertTrue((boolean)dfs.exists(foo));
        Assert.assertTrue((boolean)dfs.exists(bar));
    }

    private static void rollbackRollingUpgrade(Path foo, Path bar, MiniDFSCluster cluster) throws IOException {
        cluster.restartNameNode("-rollingUpgrade", "rollback");
        DistributedFileSystem dfs = cluster.getFileSystem();
        Assert.assertTrue((boolean)dfs.exists(foo));
        Assert.assertFalse((boolean)dfs.exists(bar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminDatanodeUpgradeControlCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnAddr = dn.getDatanodeId().getIpcAddr(false);
            String[] args1 = new String[]{"-getDatanodeInfo", dnAddr};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args1));
            String[] args2 = new String[]{"-shutdownDatanode", dnAddr, "upgrade"};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args2));
            Thread.sleep(2000L);
            Assert.assertFalse((String)"DataNode should exit", (boolean)dn.isDatanodeUp());
            Assert.assertEquals((long)-1L, (long)dfsadmin.run(args1));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFinalize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.getConfiguration(1).setInt("dfs.ha.tail-edits.period", 1);
            dfsCluster.restartNameNode(1);
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfs.mkdirs(foo);
            FSImage fsimage = dfsCluster.getNamesystem(0).getFSImage();
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            dfs.mkdirs(bar);
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)fsimage.hasRollbackFSImage());
            info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
            Assert.assertTrue((boolean)info.isFinalized());
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertFalse((boolean)fsimage.hasRollbackFSImage());
            dfsCluster.restartNameNode(0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testQuery() throws Exception {
        Configuration conf = new Configuration();
        MiniQJMHACluster cluster = null;
        try {
            cluster = new MiniQJMHACluster.Builder(conf).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfsCluster.shutdownNameNode(1);
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
            Assert.assertFalse((boolean)info.createdRollbackImages());
            dfsCluster.restartNameNode(1);
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)dfsCluster.getNamesystem(0).getFSImage().hasRollbackFSImage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testQueryAfterRestart() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            TestRollingUpgrade.queryForPreparation(dfs);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNodes();
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCheckpoint() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.namenode.checkpoint.period", 1);
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        try {
            cluster = new MiniQJMHACluster.Builder(conf).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            TestRollingUpgrade.queryForPreparation(dfs);
            dfs.mkdirs(foo);
            long txid = dfs.rollEdits();
            Assert.assertTrue((txid > 0L ? 1 : 0) != 0);
            int retries = 0;
            while (++retries < 5) {
                NNStorage storage = dfsCluster.getNamesystem(1).getFSImage().getStorage();
                if (storage.getFsImageName(txid - 1L) != null) {
                    return;
                }
                Thread.sleep(1000L);
            }
            Assert.fail((String)"new checkpoint does not exist");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void queryForPreparation(DistributedFileSystem dfs) throws IOException, InterruptedException {
        RollingUpgradeInfo info;
        int retries = 0;
        while (++retries < 10 && !(info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY)).createdRollbackImages()) {
            Thread.sleep(1000L);
        }
        if (retries >= 10) {
            Assert.fail((String)"Query return false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointWithSNN() throws Exception {
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        SecondaryNameNode snn = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
            snn = new SecondaryNameNode((Configuration)conf);
            dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/test/foo"));
            snn.doCheckpoint();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            dfs.mkdirs(new Path("/test/bar"));
            snn.doCheckpoint();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{dfs});
            if (snn != null) {
                snn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{dfs});
        if (snn != null) {
            snn.shutdown();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }
}

