/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.hadoop.yarn.util.StringHelper;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class WebAppUtils {
    private static final Log LOG = LogFactory.getLog(WebAppUtils.class);
    public static final String HTTPS_PREFIX = "https://";
    public static final String HTTP_PREFIX = "http://";

    public static void setRMWebAppPort(Configuration conf, int port) {
        String hostname = WebAppUtils.getRMWebAppURLWithoutScheme(conf);
        hostname = hostname.contains(":") ? hostname.substring(0, hostname.indexOf(":")) : hostname;
        WebAppUtils.setRMWebAppHostnameAndPort(conf, hostname, port);
    }

    public static void setRMWebAppHostnameAndPort(Configuration conf, String hostname, int port) {
        String resolvedAddress = hostname + ":" + port;
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            conf.set("yarn.resourcemanager.webapp.https.address", resolvedAddress);
        } else {
            conf.set("yarn.resourcemanager.webapp.address", resolvedAddress);
        }
    }

    public static void setNMWebAppHostNameAndPort(Configuration conf, String hostName, int port) {
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            conf.set("yarn.nodemanager.webapp.https.address", hostName + ":" + port);
        } else {
            conf.set("yarn.nodemanager.webapp.address", hostName + ":" + port);
        }
    }

    public static String getRMWebAppURLWithScheme(Configuration conf) {
        return WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getRMWebAppURLWithoutScheme(conf);
    }

    public static String getRMWebAppURLWithoutScheme(Configuration conf) {
        if (conf.getBoolean("yarn.resourcemanager.webapp.all-ifaces", true)) {
            if (YarnConfiguration.useHttps((Configuration)conf)) {
                return "0.0.0.0:" + conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090).getPort();
            }
            return "0.0.0.0:" + conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088).getPort();
        }
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090");
        }
        return conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
    }

    public static List<String> getProxyHostsAndPortsForAmFilter(Configuration conf) {
        ArrayList<String> addrs = new ArrayList<String>();
        String proxyAddr = conf.get("yarn.web-proxy.address");
        if (proxyAddr == null || proxyAddr.isEmpty()) {
            if (HAUtil.isHAEnabled((Configuration)conf)) {
                List<String> haAddrs = RMHAUtils.getRMHAWebappAddresses(new YarnConfiguration(conf));
                for (String addr : haAddrs) {
                    try {
                        InetSocketAddress socketAddr = NetUtils.createSocketAddr((String)addr);
                        addrs.add(WebAppUtils.getResolvedAddress(socketAddr));
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            if (addrs.isEmpty()) {
                addrs.add(WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf));
            }
        } else {
            addrs.add(proxyAddr);
        }
        return addrs;
    }

    public static String getProxyHostAndPort(Configuration conf) {
        String addr = conf.get("yarn.web-proxy.address");
        if (addr == null || addr.isEmpty()) {
            addr = WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
        }
        return addr;
    }

    public static String getResolvedRMWebAppURLWithScheme(Configuration conf) {
        return WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf) {
        return WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf, YarnConfiguration.useHttps((Configuration)conf) ? HttpConfig.Policy.HTTPS_ONLY : HttpConfig.Policy.HTTP_ONLY);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf, HttpConfig.Policy httpPolicy) {
        InetSocketAddress address = null;
        address = httpPolicy == HttpConfig.Policy.HTTPS_ONLY ? conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090) : conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088);
        return WebAppUtils.getResolvedAddress(address);
    }

    private static String getResolvedAddress(InetSocketAddress address) {
        address = NetUtils.getConnectAddress((InetSocketAddress)address);
        StringBuilder sb = new StringBuilder();
        InetAddress resolved = address.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            String lh = address.getHostName();
            try {
                lh = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sb.append(lh);
        } else {
            sb.append(address.getHostName());
        }
        sb.append(":").append(address.getPort());
        return sb.toString();
    }

    public static String getNMWebAppURLWithoutScheme(Configuration conf) {
        if (conf.getBoolean("yarn.nodemanager.webapp.all-ifaces", true)) {
            if (YarnConfiguration.useHttps((Configuration)conf)) {
                return "0.0.0.0:" + conf.getSocketAddr("yarn.nodemanager.webapp.https.address", "0.0.0.0:8044", 8044).getPort();
            }
            return "0.0.0.0:" + conf.getSocketAddr("yarn.nodemanager.webapp.address", "0.0.0.0:8042", 8042).getPort();
        }
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.nodemanager.webapp.https.address", "0.0.0.0:8044");
        }
        return conf.get("yarn.nodemanager.webapp.address", "0.0.0.0:8042");
    }

    public static String getAHSWebAppURLWithoutScheme(Configuration conf) {
        if (conf.getBoolean("yarn.timeline-service.webapp.all-ifaces", true)) {
            if (YarnConfiguration.useHttps((Configuration)conf)) {
                return "0.0.0.0:" + conf.getSocketAddr("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190", 8190).getPort();
            }
            return "0.0.0.0:" + conf.getSocketAddr("yarn.timeline-service.webapp.address", "0.0.0.0:8188", 8188).getPort();
        }
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190");
        }
        return conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188");
    }

    public static String getURLWithScheme(String schemePrefix, String url) {
        if (url.indexOf("://") > 0) {
            return url;
        }
        return schemePrefix + url;
    }

    public static String getRunningLogURL(String nodeHttpAddress, String containerId, String user) {
        if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || containerId == null || containerId.isEmpty() || user == null || user.isEmpty()) {
            return null;
        }
        return StringHelper.PATH_JOINER.join((Object)nodeHttpAddress, (Object)"node", new Object[]{"containerlogs", containerId, user});
    }

    public static String getAggregatedLogURL(String serverHttpAddress, String allocatedNode, String containerId, String entity, String user) {
        if (serverHttpAddress == null || serverHttpAddress.isEmpty() || allocatedNode == null || allocatedNode.isEmpty() || containerId == null || containerId.isEmpty() || entity == null || entity.isEmpty() || user == null || user.isEmpty()) {
            return null;
        }
        return StringHelper.PATH_JOINER.join((Object)serverHttpAddress, (Object)"applicationhistory", new Object[]{"logs", allocatedNode, containerId, entity, user});
    }

    public static String getHttpSchemePrefix(Configuration conf) {
        return YarnConfiguration.useHttps((Configuration)conf) ? HTTPS_PREFIX : HTTP_PREFIX;
    }

    public static HttpServer2.Builder loadSslConfiguration(HttpServer2.Builder builder) {
        Configuration sslConf = new Configuration(false);
        boolean needsClientAuth = false;
        sslConf.addResource("ssl-server.xml");
        return builder.needsClientAuth(needsClientAuth).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
    }
}

