/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSchedulerMetrics
extends SchedulerMetrics {
    private int totalMemoryMB = Integer.MAX_VALUE;
    private int totalVCores = Integer.MAX_VALUE;
    private boolean maxReset = false;

    public FairSchedulerMetrics() {
        this.appTrackedMetrics.add("demand.memory");
        this.appTrackedMetrics.add("demand.vcores");
        this.appTrackedMetrics.add("usage.memory");
        this.appTrackedMetrics.add("usage.vcores");
        this.appTrackedMetrics.add("minshare.memory");
        this.appTrackedMetrics.add("minshare.vcores");
        this.appTrackedMetrics.add("maxshare.memory");
        this.appTrackedMetrics.add("maxshare.vcores");
        this.appTrackedMetrics.add("fairshare.memory");
        this.appTrackedMetrics.add("fairshare.vcores");
        this.queueTrackedMetrics.add("demand.memory");
        this.queueTrackedMetrics.add("demand.vcores");
        this.queueTrackedMetrics.add("usage.memory");
        this.queueTrackedMetrics.add("usage.vcores");
        this.queueTrackedMetrics.add("minshare.memory");
        this.queueTrackedMetrics.add("minshare.vcores");
        this.queueTrackedMetrics.add("maxshare.memory");
        this.queueTrackedMetrics.add("maxshare.vcores");
        this.queueTrackedMetrics.add("fairshare.memory");
        this.queueTrackedMetrics.add("fairshare.vcores");
    }

    @Override
    public void trackApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        super.trackApp(appAttemptId, oldAppId);
        FairScheduler fair = (FairScheduler)this.scheduler;
        final AppSchedulable app = fair.getSchedulerApp(appAttemptId).getAppSchedulable();
        this.metrics.register("variable.app." + oldAppId + ".demand.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getDemand().getMemory();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".demand.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getDemand().getVirtualCores();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".usage.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getResourceUsage().getMemory();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".usage.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getResourceUsage().getVirtualCores();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".minshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getMinShare().getMemory();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".minshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getMinShare().getMemory();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".maxshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return Math.min(app.getMaxShare().getMemory(), FairSchedulerMetrics.this.totalMemoryMB);
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".maxshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return Math.min(app.getMaxShare().getVirtualCores(), FairSchedulerMetrics.this.totalVCores);
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".fairshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getFairShare().getVirtualCores();
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".fairshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return app.getFairShare().getVirtualCores();
            }
        });
    }

    @Override
    public void trackQueue(String queueName) {
        this.trackedQueues.add(queueName);
        FairScheduler fair = (FairScheduler)this.scheduler;
        final FSQueue queue = fair.getQueueManager().getQueue(queueName);
        this.metrics.register("variable.queue." + queueName + ".demand.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getDemand().getMemory();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".demand.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getDemand().getVirtualCores();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".usage.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getResourceUsage().getMemory();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".usage.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getResourceUsage().getVirtualCores();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".minshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getMinShare().getMemory();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".minshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getMinShare().getVirtualCores();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".maxshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (!FairSchedulerMetrics.this.maxReset && SLSRunner.simulateInfoMap.containsKey("Number of nodes") && SLSRunner.simulateInfoMap.containsKey("Node memory (MB)") && SLSRunner.simulateInfoMap.containsKey("Node VCores")) {
                    int numNMs = Integer.parseInt(SLSRunner.simulateInfoMap.get("Number of nodes").toString());
                    int numMemoryMB = Integer.parseInt(SLSRunner.simulateInfoMap.get("Node memory (MB)").toString());
                    int numVCores = Integer.parseInt(SLSRunner.simulateInfoMap.get("Node VCores").toString());
                    FairSchedulerMetrics.this.totalMemoryMB = numNMs * numMemoryMB;
                    FairSchedulerMetrics.this.totalVCores = numNMs * numVCores;
                    FairSchedulerMetrics.this.maxReset = false;
                }
                return Math.min(queue.getMaxShare().getMemory(), FairSchedulerMetrics.this.totalMemoryMB);
            }
        });
        this.metrics.register("variable.queue." + queueName + ".maxshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return Math.min(queue.getMaxShare().getVirtualCores(), FairSchedulerMetrics.this.totalVCores);
            }
        });
        this.metrics.register("variable.queue." + queueName + ".fairshare.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getFairShare().getMemory();
            }
        });
        this.metrics.register("variable.queue." + queueName + ".fairshare.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return queue.getFairShare().getVirtualCores();
            }
        });
    }

    @Override
    public void untrackQueue(String queueName) {
        this.trackedQueues.remove(queueName);
        this.metrics.remove("variable.queue." + queueName + ".demand.memory");
        this.metrics.remove("variable.queue." + queueName + ".demand.vcores");
        this.metrics.remove("variable.queue." + queueName + ".usage.memory");
        this.metrics.remove("variable.queue." + queueName + ".usage.vcores");
        this.metrics.remove("variable.queue." + queueName + ".minshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".minshare.vcores");
        this.metrics.remove("variable.queue." + queueName + ".maxshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".maxshare.vcores");
        this.metrics.remove("variable.queue." + queueName + ".fairshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".fairshare.vcores");
    }
}

