/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;

@InterfaceAudience.Private
abstract class BalancingPolicy {
    long totalCapacity;
    long totalUsedSpace;
    private double avgUtilization;

    BalancingPolicy() {
    }

    void reset() {
        this.totalCapacity = 0L;
        this.totalUsedSpace = 0L;
        this.avgUtilization = 0.0;
    }

    abstract String getName();

    abstract void accumulateSpaces(DatanodeInfo var1);

    void initAvgUtilization() {
        this.avgUtilization = (double)this.totalUsedSpace * 100.0 / (double)this.totalCapacity;
    }

    double getAvgUtilization() {
        return this.avgUtilization;
    }

    abstract double getUtilization(DatanodeInfo var1);

    public String toString() {
        return BalancingPolicy.class.getSimpleName() + "." + this.getClass().getSimpleName();
    }

    static BalancingPolicy parse(String s) {
        BalancingPolicy[] all;
        for (BalancingPolicy p : all = new BalancingPolicy[]{Node.INSTANCE, Pool.INSTANCE}) {
            if (!p.getName().equalsIgnoreCase(s)) continue;
            return p;
        }
        throw new IllegalArgumentException("Cannot parse string \"" + s + "\"");
    }

    static class Pool
    extends BalancingPolicy {
        static final Pool INSTANCE = new Pool();

        private Pool() {
        }

        @Override
        String getName() {
            return "blockpool";
        }

        @Override
        void accumulateSpaces(DatanodeInfo d) {
            this.totalCapacity += d.getCapacity();
            this.totalUsedSpace += d.getBlockPoolUsed();
        }

        @Override
        double getUtilization(DatanodeInfo d) {
            return (double)d.getBlockPoolUsed() * 100.0 / (double)d.getCapacity();
        }
    }

    static class Node
    extends BalancingPolicy {
        static final Node INSTANCE = new Node();

        private Node() {
        }

        @Override
        String getName() {
            return "datanode";
        }

        @Override
        void accumulateSpaces(DatanodeInfo d) {
            this.totalCapacity += d.getCapacity();
            this.totalUsedSpace += d.getDfsUsed();
        }

        @Override
        double getUtilization(DatanodeInfo d) {
            return (double)d.getDfsUsed() * 100.0 / (double)d.getCapacity();
        }
    }
}

