/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.avro.AvroReflectSerialization;
import org.apache.hadoop.util.ReflectionUtils;
import org.mockito.Mockito;

public class TestSequenceFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSequenceFile.class);
    private Configuration conf = new Configuration();

    public TestSequenceFile() {
    }

    public TestSequenceFile(String name) {
        super(name);
    }

    public void testZlibSequenceFile() throws Exception {
        LOG.info((Object)"Testing SequenceFile with DefaultCodec");
        this.compressedSeqFileTest((CompressionCodec)new DefaultCodec());
        LOG.info((Object)"Successfully tested SequenceFile with DefaultCodec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressedSeqFileTest(CompressionCodec codec) throws Exception {
        int count = 10240;
        int megabytes = 1;
        int factor = 5;
        Path file = new Path(System.getProperty("test.build.data", ".") + "/test.seq");
        Path recordCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.rc.seq");
        Path blockCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.bc.seq");
        int seed = new Random().nextInt();
        LOG.info((Object)("Seed = " + seed));
        try (LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);){
            this.writeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null);
            this.readTest((FileSystem)fs, count, seed, file);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, file);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, file);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.writeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, codec);
            this.readTest((FileSystem)fs, count, seed, recordCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, recordCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, recordCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.writeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, codec);
            this.readTest((FileSystem)fs, count, seed, blockCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, blockCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, blockCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
        }
    }

    private void writeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec) throws IOException {
        fs.delete(file, true);
        LOG.info((Object)("creating " + count + " records with " + compressionType + " compression"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    private void readTest(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.debug((Object)("reading " + count + " records"));
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, this.conf);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        DataOutputBuffer rawKey = new DataOutputBuffer();
        SequenceFile.ValueBytes rawValue = reader.createValueBytes();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            try {
                if (i % 5 == 0) {
                    rawKey.reset();
                    reader.nextRaw(rawKey, rawValue);
                    continue;
                }
                if (i % 2 == 0) {
                    reader.next((Writable)k);
                    reader.getCurrentValue((Writable)v);
                } else {
                    reader.next((Writable)k, (Writable)v);
                }
                if (!k.equals(key)) {
                    throw new RuntimeException("wrong key at " + i);
                }
                if (v.equals(value)) continue;
                throw new RuntimeException("wrong value at " + i);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Problem on row " + i));
                LOG.info((Object)("Expected key = " + key));
                LOG.info((Object)("Expected len = " + key.getLength()));
                LOG.info((Object)("Actual key = " + k));
                LOG.info((Object)("Actual len = " + k.getLength()));
                LOG.info((Object)("Expected value = " + value));
                LOG.info((Object)("Expected len = " + value.getLength()));
                LOG.info((Object)("Actual value = " + v));
                LOG.info((Object)("Actual len = " + v.getLength()));
                LOG.info((Object)("Key equals: " + k.equals(key)));
                LOG.info((Object)("value equals: " + v.equals(value)));
                throw ioe;
            }
        }
        reader.close();
    }

    private void sortTest(FileSystem fs, int count, int megabytes, int factor, boolean fast, Path file) throws IOException {
        fs.delete(new Path(file + ".sorted"), true);
        SequenceFile.Sorter sorter = this.newSorter(fs, fast, megabytes, factor);
        LOG.debug((Object)("sorting " + count + " records"));
        sorter.sort(file, file.suffix(".sorted"));
        LOG.info((Object)("done sorting " + count + " debug"));
    }

    private void checkSort(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.info((Object)("sorting " + count + " records in memory for debug"));
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        TreeMap<RandomDatum, RandomDatum> map = new TreeMap<RandomDatum, RandomDatum>();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            map.put(key, value);
        }
        LOG.debug((Object)("checking order of " + count + " records"));
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        Iterator iterator = map.entrySet().iterator();
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file.suffix(".sorted"), this.conf);
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = iterator.next();
            RandomDatum key = (RandomDatum)entry.getKey();
            RandomDatum value = (RandomDatum)entry.getValue();
            reader.next((Writable)k, (Writable)v);
            if (!k.equals(key)) {
                throw new RuntimeException("wrong key at " + i);
            }
            if (v.equals(value)) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        LOG.debug((Object)("sucessfully checked " + count + " records"));
    }

    private void mergeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, boolean fast, int factor, int megabytes) throws IOException {
        int i;
        LOG.debug((Object)("creating " + factor + " files with " + count / factor + " records"));
        SequenceFile.Writer[] writers = new SequenceFile.Writer[factor];
        Path[] names = new Path[factor];
        Path[] sortedNames = new Path[factor];
        for (int i2 = 0; i2 < factor; ++i2) {
            names[i2] = file.suffix("." + i2);
            sortedNames[i2] = names[i2].suffix(".sorted");
            fs.delete(names[i2], true);
            fs.delete(sortedNames[i2], true);
            writers[i2] = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)names[i2], RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType);
        }
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writers[i % factor].append((Writable)key, (Writable)value);
        }
        for (i = 0; i < factor; ++i) {
            writers[i].close();
        }
        for (i = 0; i < factor; ++i) {
            LOG.debug((Object)("sorting file " + i + " with " + count / factor + " records"));
            this.newSorter(fs, fast, megabytes, factor).sort(names[i], sortedNames[i]);
        }
        LOG.info((Object)("merging " + factor + " files with " + count / factor + " debug"));
        fs.delete(new Path(file + ".sorted"), true);
        this.newSorter(fs, fast, megabytes, factor).merge(sortedNames, file.suffix(".sorted"));
    }

    private SequenceFile.Sorter newSorter(FileSystem fs, boolean fast, int megabytes, int factor) {
        SequenceFile.Sorter sorter = fast ? new SequenceFile.Sorter(fs, (RawComparator)new RandomDatum.Comparator(), RandomDatum.class, RandomDatum.class, this.conf) : new SequenceFile.Sorter(fs, RandomDatum.class, RandomDatum.class, this.conf);
        sorter.setMemory(megabytes * 1024 * 1024);
        sorter.setFactor(factor);
        return sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceFileMetadata() throws Exception {
        LOG.info((Object)"Testing SequenceFile with metadata");
        int count = 10240;
        DefaultCodec codec = new DefaultCodec();
        Path file = new Path(System.getProperty("test.build.data", ".") + "/test.seq.metadata");
        Path sortedFile = new Path(System.getProperty("test.build.data", ".") + "/test.sorted.seq.metadata");
        Path recordCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.rc.seq.metadata");
        Path blockCompressedFile = new Path(System.getProperty("test.build.data", ".") + "/test.bc.seq.metadata");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        SequenceFile.Metadata theMetadata = new SequenceFile.Metadata();
        theMetadata.set(new Text("name_1"), new Text("value_1"));
        theMetadata.set(new Text("name_2"), new Text("value_2"));
        theMetadata.set(new Text("name_3"), new Text("value_3"));
        theMetadata.set(new Text("name_4"), new Text("value_4"));
        int seed = new Random().nextInt();
        try {
            this.writeMetadataTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null, theMetadata);
            SequenceFile.Metadata aMetadata = this.readMetadata((FileSystem)fs, file);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  1");
            }
            this.writeMetadataTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, (CompressionCodec)codec, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, recordCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  2");
            }
            this.writeMetadataTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, blockCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  3");
            }
            this.sortMetadataTest((FileSystem)fs, file, sortedFile, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, recordCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info((Object)("The original metadata:\n" + theMetadata.toString()));
                LOG.info((Object)("The retrieved metadata:\n" + aMetadata.toString()));
                throw new RuntimeException("metadata not match:  4");
            }
        }
        finally {
            fs.close();
        }
        LOG.info((Object)"Successfully tested SequenceFile with metadata");
    }

    private SequenceFile.Metadata readMetadata(FileSystem fs, Path file) throws IOException {
        LOG.info((Object)("reading file: " + file.toString()));
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, this.conf);
        SequenceFile.Metadata meta = reader.getMetadata();
        reader.close();
        return meta;
    }

    private void writeMetadataTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec, SequenceFile.Metadata metadata) throws IOException {
        fs.delete(file, true);
        LOG.info((Object)("creating " + count + " records with metadata and with " + compressionType + " compression"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, null, (SequenceFile.Metadata)metadata);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    private void sortMetadataTest(FileSystem fs, Path unsortedFile, Path sortedFile, SequenceFile.Metadata metadata) throws IOException {
        fs.delete(sortedFile, true);
        LOG.info((Object)("sorting: " + unsortedFile + " to: " + sortedFile));
        WritableComparator comparator = WritableComparator.get(RandomDatum.class);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)comparator, RandomDatum.class, RandomDatum.class, this.conf, metadata);
        sorter.sort(new Path[]{unsortedFile}, sortedFile, false);
    }

    public void testClose() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path1 = new Path(System.getProperty("test.build.data", ".") + "/test1.seq");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path1, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file1-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file1-2"), (Writable)NullWritable.get());
        writer.close();
        Path path2 = new Path(System.getProperty("test.build.data", ".") + "/test2.seq");
        writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path2, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file2-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file2-2"), (Writable)NullWritable.get());
        writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        reader.close();
        reader.close();
        SequenceFile.Reader reader1 = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        Text text = new Text();
        reader1.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file1-1", (String)text.toString());
        SequenceFile.Reader reader2 = new SequenceFile.Reader((FileSystem)fs, path2, conf);
        reader2.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file2-1", (String)text.toString());
        reader1.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file1-2", (String)text.toString());
        reader2.next((Writable)text);
        TestSequenceFile.assertEquals((String)"file2-2", (String)text.toString());
        TestSequenceFile.assertFalse((boolean)reader1.next((Writable)text));
        TestSequenceFile.assertFalse((boolean)reader2.next((Writable)text));
    }

    public void testCreateUsesFsArg() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
        Path p = new Path(System.getProperty("test.build.data", ".") + "/testCreateUsesFSArg.seq");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)spyFs, (Configuration)this.conf, (Path)p, NullWritable.class, NullWritable.class);
        writer.close();
        ((FileSystem)Mockito.verify((Object)spyFs)).getDefaultReplication(p);
    }

    public void testCloseForErroneousSequenceFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(System.getProperty("test.build.data", ".") + "/broken.seq");
        fs.create(path).close();
        final TestFSDataInputStream[] openedFile = new TestFSDataInputStream[1];
        try {
            new SequenceFile.Reader((FileSystem)fs, path, conf){

                protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
                    FSDataInputStream in = super.openFile(fs, file, bufferSize, length);
                    openedFile[0] = new TestFSDataInputStream((InputStream)in);
                    return openedFile[0];
                }
            };
            TestSequenceFile.fail((String)"IOException expected.");
        }
        catch (IOException expected) {
            // empty catch block
        }
        TestSequenceFile.assertNotNull((String)(path + " should have been opened."), (Object)((Object)openedFile[0]));
        TestSequenceFile.assertTrue((String)("InputStream for " + path + " should have been closed."), (boolean)openedFile[0].isClosed());
    }

    public void testCreateWriterOnExistingFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path name = new Path(new Path(System.getProperty("test.build.data", "."), "createWriterOnExistingFile"), "file");
        fs.create(name);
        SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)false, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
    }

    public void testRecursiveSeqFileCreate() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path name = new Path(new Path(System.getProperty("test.build.data", "."), "recursiveCreateDir"), "file");
        boolean createParent = false;
        try {
            SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)createParent, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
            TestSequenceFile.fail((String)"Expected an IOException due to missing parent");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        createParent = true;
        SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)createParent, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
    }

    public void testSerializationAvailability() throws IOException {
        Configuration conf = new Configuration();
        Path path = new Path(System.getProperty("test.build.data", "."), "serializationAvailability");
        try {
            SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(String.class), SequenceFile.Writer.valueClass(NullWritable.class)});
            TestSequenceFile.fail((String)"Must throw IOException for missing serializer for the Key class");
        }
        catch (IOException e) {
            TestSequenceFile.assertTrue((boolean)e.getMessage().startsWith("Could not find a serializer for the Key class: '" + String.class.getName() + "'."));
        }
        try {
            SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(NullWritable.class), SequenceFile.Writer.valueClass(String.class)});
            TestSequenceFile.fail((String)"Must throw IOException for missing serializer for the Value class");
        }
        catch (IOException e) {
            TestSequenceFile.assertTrue((boolean)e.getMessage().startsWith("Could not find a serializer for the Value class: '" + String.class.getName() + "'."));
        }
        this.writeTest(FileSystem.get((Configuration)conf), 1, 1, path, SequenceFile.CompressionType.NONE, null);
        conf.setStrings("io.serializations", new String[]{AvroReflectSerialization.class.getName()});
        try {
            new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
            TestSequenceFile.fail((String)"Must throw IOException for missing deserializer for the Key class");
        }
        catch (IOException e) {
            TestSequenceFile.assertTrue((boolean)e.getMessage().startsWith("Could not find a deserializer for the Key class: '" + RandomDatum.class.getName() + "'."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        int megabytes = 1;
        int factor = 10;
        boolean create = true;
        boolean rwonly = false;
        boolean check = false;
        boolean fast = false;
        boolean merge = false;
        String compressType = "NONE";
        String compressionCodec = "org.apache.hadoop.io.compress.DefaultCodec";
        Path file = null;
        int seed = new Random().nextInt();
        String usage = "Usage: SequenceFile [-count N] [-seed #] [-check] [-compressType <NONE|RECORD|BLOCK>] -codec <compressionCodec> [[-rwonly] | {[-megabytes M] [-factor F] [-nocreate] [-fast] [-merge]}]  file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        try (FileSystem fs = null;){
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-megabytes")) {
                    megabytes = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-factor")) {
                    factor = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    seed = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-rwonly")) {
                    rwonly = true;
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-check")) {
                    check = true;
                    continue;
                }
                if (args[i].equals("-fast")) {
                    fast = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    merge = true;
                    continue;
                }
                if (args[i].equals("-compressType")) {
                    compressType = args[++i];
                    continue;
                }
                if (args[i].equals("-codec")) {
                    compressionCodec = args[++i];
                    continue;
                }
                file = new Path(args[i]);
            }
            TestSequenceFile test = new TestSequenceFile();
            fs = file.getFileSystem(test.conf);
            LOG.info((Object)("count = " + count));
            LOG.info((Object)("megabytes = " + megabytes));
            LOG.info((Object)("factor = " + factor));
            LOG.info((Object)("create = " + create));
            LOG.info((Object)("seed = " + seed));
            LOG.info((Object)("rwonly = " + rwonly));
            LOG.info((Object)("check = " + check));
            LOG.info((Object)("fast = " + fast));
            LOG.info((Object)("merge = " + merge));
            LOG.info((Object)("compressType = " + compressType));
            LOG.info((Object)("compressionCodec = " + compressionCodec));
            LOG.info((Object)("file = " + file));
            if (rwonly && (!create || merge || fast)) {
                System.err.println(usage);
                System.exit(-1);
            }
            SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.valueOf((String)compressType);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)test.conf.getClassByName(compressionCodec), (Configuration)test.conf);
            if (rwonly || create && !merge) {
                test.writeTest(fs, count, seed, file, compressionType, codec);
                test.readTest(fs, count, seed, file);
            }
            if (!rwonly) {
                if (merge) {
                    test.mergeTest(fs, count, seed, file, compressionType, fast, factor, megabytes);
                } else {
                    test.sortTest(fs, count, megabytes, factor, fast, file);
                }
            }
            if (check) {
                test.checkSort(fs, count, seed, file);
            }
        }
    }

    private static class TestFSDataInputStream
    extends FSDataInputStream {
        private boolean closed = false;

        private TestFSDataInputStream(InputStream in) throws IOException {
            super(in);
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

