/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public abstract class AbstractContractMkdirTest
extends AbstractFSContractTestBase {
    @Test
    public void testMkDirRmDir() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path dir = this.path("testMkDirRmDir");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        this.assertPathExists("mkdir failed", dir);
        this.assertDeleted(dir, false);
    }

    @Test
    public void testMkDirRmRfDir() throws Throwable {
        this.describe("create a directory then recursive delete it");
        FileSystem fs = this.getFileSystem();
        Path dir = this.path("testMkDirRmRfDir");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        this.assertPathExists("mkdir failed", dir);
        this.assertDeleted(dir, true);
    }

    @Test
    public void testNoMkdirOverFile() throws Throwable {
        this.describe("try to mkdir over a file");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testNoMkdirOverFile");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, dataset);
        try {
            boolean made = fs.mkdirs(path);
            AbstractContractMkdirTest.fail((String)("mkdirs did not fail over a file but returned " + made + "; " + this.ls(path)));
        }
        catch (ParentNotDirectoryException e) {
            this.handleExpectedException((Exception)((Object)e));
        }
        catch (FileAlreadyExistsException e) {
            this.handleExpectedException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleRelaxedException("mkdirs", "FileAlreadyExistsException", e);
        }
        this.assertIsFile(path);
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), path, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
        this.assertPathExists("mkdir failed", path);
        this.assertDeleted(path, true);
    }

    @Test
    public void testMkdirOverParentFile() throws Throwable {
        this.describe("try to mkdir where a parent is a file");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testMkdirOverParentFile");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, dataset);
        Path child = new Path(path, "child-to-mkdir");
        try {
            boolean made = fs.mkdirs(child);
            AbstractContractMkdirTest.fail((String)("mkdirs did not fail over a file but returned " + made + "; " + this.ls(path)));
        }
        catch (ParentNotDirectoryException e) {
            this.handleExpectedException((Exception)((Object)e));
        }
        catch (FileAlreadyExistsException e) {
            this.handleExpectedException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleRelaxedException("mkdirs", "ParentNotDirectoryException", e);
        }
        this.assertIsFile(path);
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), path, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
        this.assertPathExists("mkdir failed", path);
        this.assertDeleted(path, true);
    }

    @Test
    public void testMkdirSlashHandling() throws Throwable {
        this.describe("verify mkdir slash handling");
        FileSystem fs = this.getFileSystem();
        AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(this.path("testmkdir/a")));
        this.assertPathExists("mkdir without trailing slash failed", this.path("testmkdir/a"));
        AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(this.path("testmkdir/b/")));
        this.assertPathExists("mkdir with trailing slash failed", this.path("testmkdir/b/"));
        this.assertPathExists("check path existence without trailing slash failed", this.path("testmkdir/b"));
    }
}

