/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.sink.GraphiteSink;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestGraphiteMetrics {
    private AbstractMetric makeMetric(String name, Number value) {
        AbstractMetric metric = (AbstractMetric)Mockito.mock(AbstractMetric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        return metric;
    }

    @Test
    public void testPutMetrics() {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1.25));
        metrics.add(this.makeMetric("foo2", 2.25));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        OutputStreamWriter mockWriter = (OutputStreamWriter)Mockito.mock(OutputStreamWriter.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        Whitebox.setInternalState((Object)sink, (String)"writer", (Object)mockWriter);
        sink.putMetrics((MetricsRecord)record);
        try {
            ((OutputStreamWriter)Mockito.verify((Object)mockWriter)).write((String)argument.capture());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = ((String)argument.getValue()).toString();
        Assert.assertEquals((Object)true, (Object)(result.equals("null.all.Context.Context=all.Hostname=host.foo1 1.25 10\nnull.all.Context.Context=all.Hostname=host.foo2 2.25 10\n") || result.equals("null.all.Context.Context=all.Hostname=host.foo2 2.25 10\nnull.all.Context.Context=all.Hostname=host.foo1 1.25 10\n") ? 1 : 0));
    }

    @Test
    public void testPutMetrics2() {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, null));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1));
        metrics.add(this.makeMetric("foo2", 2));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        OutputStreamWriter mockWriter = (OutputStreamWriter)Mockito.mock(OutputStreamWriter.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        Whitebox.setInternalState((Object)sink, (String)"writer", (Object)mockWriter);
        sink.putMetrics((MetricsRecord)record);
        try {
            ((OutputStreamWriter)Mockito.verify((Object)mockWriter)).write((String)argument.capture());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = ((String)argument.getValue()).toString();
        Assert.assertEquals((Object)true, (Object)(result.equals("null.all.Context.Context=all.foo1 1 10\nnull.all.Context.Context=all.foo2 2 10\n") || result.equals("null.all.Context.Context=all.foo2 2 10\nnull.all.Context.Context=all.foo1 1 10\n") ? 1 : 0));
    }

    @Test(expected=MetricsException.class)
    public void testCloseAndWrite() throws IOException {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1.25));
        metrics.add(this.makeMetric("foo2", 2.25));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        OutputStreamWriter writer = (OutputStreamWriter)Mockito.mock(OutputStreamWriter.class);
        Whitebox.setInternalState((Object)sink, (String)"writer", (Object)writer);
        sink.close();
        sink.putMetrics((MetricsRecord)record);
    }

    @Test
    public void testClose() {
        GraphiteSink sink = new GraphiteSink();
        Writer mockWriter = (Writer)Mockito.mock(Writer.class);
        Whitebox.setInternalState((Object)sink, (String)"writer", (Object)mockWriter);
        try {
            sink.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            ((Writer)Mockito.verify((Object)mockWriter)).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

