/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.util.Shell;
import org.junit.Test;

public class TestPath
extends TestCase {
    @Test(timeout=30000L)
    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        this.toStringTest("/foo/bar#boo");
        this.toStringTest("foo/bar#boo");
        boolean emptyException = false;
        try {
            this.toStringTest("");
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        TestPath.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
            this.toStringTest("C:/foo/bar#boo");
            this.toStringTest("C:foo/bar#boo");
        }
    }

    private void toStringTest(String pathString) {
        TestPath.assertEquals((String)pathString, (String)new Path(pathString).toString());
    }

    @Test(timeout=30000L)
    public void testNormalize() throws URISyntaxException {
        TestPath.assertEquals((String)"", (String)new Path(".").toString());
        TestPath.assertEquals((String)"..", (String)new Path("..").toString());
        TestPath.assertEquals((String)"/", (String)new Path("/").toString());
        TestPath.assertEquals((String)"/", (String)new Path("//").toString());
        TestPath.assertEquals((String)"/", (String)new Path("///").toString());
        TestPath.assertEquals((String)"//foo/", (String)new Path("//foo/").toString());
        TestPath.assertEquals((String)"//foo/", (String)new Path("//foo//").toString());
        TestPath.assertEquals((String)"//foo/bar", (String)new Path("//foo//bar").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo//").toString());
        TestPath.assertEquals((String)"foo/bar", (String)new Path("foo//bar").toString());
        TestPath.assertEquals((String)"hdfs://foo/foo2/bar/baz/", (String)new Path(new URI("hdfs://foo//foo2///bar/baz///")).toString());
        if (Path.WINDOWS) {
            TestPath.assertEquals((String)"c:/a/b", (String)new Path("c:\\a\\b").toString());
        }
    }

    @Test(timeout=30000L)
    public void testIsAbsolute() {
        TestPath.assertTrue((boolean)new Path("/").isAbsolute());
        TestPath.assertTrue((boolean)new Path("/foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        TestPath.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            TestPath.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            TestPath.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    @Test(timeout=30000L)
    public void testParent() {
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        TestPath.assertEquals(null, (Object)new Path("/").getParent());
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    @Test(timeout=30000L)
    public void testChild() {
        TestPath.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        TestPath.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    @Test(timeout=30000L)
    public void testPathThreeArgContructor() {
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path(null, null, "foo"));
        TestPath.assertEquals((Object)new Path("scheme:///foo"), (Object)new Path("scheme", null, "/foo"));
        TestPath.assertEquals((Object)new Path("scheme://authority/foo"), (Object)new Path("scheme", "authority", "/foo"));
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "c:/foo/bar"));
            TestPath.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "/c:/foo/bar"));
        } else {
            TestPath.assertEquals((Object)new Path("./a:b"), (Object)new Path(null, null, "a:b"));
        }
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "c:/foo/bar")));
            TestPath.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "/c:/foo/bar")));
            TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", new Path(null, null, "bar")));
        } else {
            TestPath.assertEquals((Object)new Path("/foo/bar/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "a:b")));
            TestPath.assertEquals((Object)new Path("/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "/a:b")));
        }
    }

    @Test(timeout=30000L)
    public void testEquals() {
        TestPath.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    @Test(timeout=30000L)
    public void testDots() {
        TestPath.assertEquals((String)new Path("/foo/bar/baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar", ".").toString(), (String)"/foo/bar");
        TestPath.assertEquals((String)new Path("/foo/bar/../baz").toString(), (String)"/foo/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/./baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/../../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/.././../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("../../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path(".././../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path("./foo/bar/baz").toString(), (String)"foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/../../baz/boo").toString(), (String)"/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/").toString(), (String)"foo/bar");
        TestPath.assertEquals((String)new Path("foo/bar/../baz").toString(), (String)"foo/baz");
        TestPath.assertEquals((String)new Path("foo/bar/../../baz/boo").toString(), (String)"baz/boo");
        TestPath.assertEquals((String)new Path("/foo/bar", "baz/boo").toString(), (String)"/foo/bar/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/", "baz/bud").toString(), (String)"foo/bar/baz/bud");
        TestPath.assertEquals((String)new Path("/foo/bar", "../../boo/bud").toString(), (String)"/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar", "../../boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path(".", "boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz", "../../boo/bud").toString(), (String)"/foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../boo/bud").toString(), (String)"foo/boo/bud");
        TestPath.assertEquals((String)new Path("../../", "../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo", "../../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo/bar", "../boo/bud").toString(), (String)"../../foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../..").toString(), (String)"");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../../../..").toString(), (String)"../..");
    }

    @Test(timeout=5000L)
    public void testWindowsPaths() throws URISyntaxException, IOException {
        if (!Path.WINDOWS) {
            return;
        }
        TestPath.assertEquals((String)new Path("c:\\foo\\bar").toString(), (String)"c:/foo/bar");
        TestPath.assertEquals((String)new Path("c:/foo/bar").toString(), (String)"c:/foo/bar");
        TestPath.assertEquals((String)new Path("/c:/foo/bar").toString(), (String)"c:/foo/bar");
        TestPath.assertEquals((String)new Path("file://c:/foo/bar").toString(), (String)"file://c:/foo/bar");
    }

    @Test(timeout=5000L)
    public void testInvalidWindowsPaths() throws URISyntaxException, IOException {
        String[] invalidPaths;
        if (!Path.WINDOWS) {
            return;
        }
        for (String path : invalidPaths = new String[]{"hdfs:\\\\\\tmp"}) {
            try {
                Path item = new Path(path);
                TestPath.fail((String)("Did not throw for invalid path " + path));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    @Test(timeout=30000L)
    public void testChildParentResolution() throws URISyntaxException, IOException {
        Path parent = new Path("foo1://bar1/baz1");
        Path child = new Path("foo2://bar2/baz2");
        TestPath.assertEquals((Object)child, (Object)new Path(parent, child));
    }

    @Test(timeout=30000L)
    public void testScheme() throws IOException {
        TestPath.assertEquals((String)"foo:/bar", (String)new Path("foo:/", "/bar").toString());
        TestPath.assertEquals((String)"foo://bar/baz", (String)new Path("foo://bar/", "/baz").toString());
    }

    @Test(timeout=30000L)
    public void testURI() throws URISyntaxException, IOException {
        URI uri = new URI("file:///bar#baz");
        Path path = new Path(uri);
        TestPath.assertTrue((boolean)uri.equals(new URI(path.toString())));
        FileSystem fs = path.getFileSystem(new Configuration());
        TestPath.assertTrue((boolean)uri.equals(new URI(fs.makeQualified(path).toString())));
        URI uri2 = new URI("file:///bar/baz");
        TestPath.assertTrue((boolean)uri2.equals(new URI(fs.makeQualified(new Path(uri2)).toString())));
        TestPath.assertEquals((String)"foo://bar/baz#boo", (String)new Path("foo://bar/", new Path(new URI("/baz#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/baz/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("fud#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("/fud#boo"))).toString());
    }

    @Test(timeout=30000L)
    public void testPathToUriConversion() throws URISyntaxException, IOException {
        TestPath.assertEquals((Object)new URI(null, null, "/foo?bar", null, null), (Object)new Path("/foo?bar").toUri());
        TestPath.assertEquals((Object)new URI(null, null, "/foo\"bar", null, null), (Object)new Path("/foo\"bar").toUri());
        TestPath.assertEquals((Object)new URI(null, null, "/foo bar", null, null), (Object)new Path("/foo bar").toUri());
        TestPath.assertEquals((String)"/foo?bar", (String)new Path("http://localhost/foo?bar").toUri().getPath());
        TestPath.assertEquals((String)"/foo", (String)new URI("http://localhost/foo?bar").getPath());
        TestPath.assertEquals((String)new URI("/foo;bar").getPath(), (String)new Path("/foo;bar").toUri().getPath());
        TestPath.assertEquals((Object)new URI("/foo;bar"), (Object)new Path("/foo;bar").toUri());
        TestPath.assertEquals((Object)new URI("/foo+bar"), (Object)new Path("/foo+bar").toUri());
        TestPath.assertEquals((Object)new URI("/foo-bar"), (Object)new Path("/foo-bar").toUri());
        TestPath.assertEquals((Object)new URI("/foo=bar"), (Object)new Path("/foo=bar").toUri());
        TestPath.assertEquals((Object)new URI("/foo,bar"), (Object)new Path("/foo,bar").toUri());
    }

    @Test(timeout=30000L)
    public void testReservedCharacters() throws URISyntaxException, IOException {
        TestPath.assertEquals((String)"/foo%20bar", (String)new URI(null, null, "/foo bar", null, null).getRawPath());
        TestPath.assertEquals((String)"/foo bar", (String)new URI(null, null, "/foo bar", null, null).getPath());
        TestPath.assertEquals((String)"/foo%20bar", (String)new URI(null, null, "/foo bar", null, null).toString());
        TestPath.assertEquals((String)"/foo%20bar", (String)new Path("/foo bar").toUri().toString());
        TestPath.assertEquals((String)"/foo;bar", (String)new URI("/foo;bar").getPath());
        TestPath.assertEquals((String)"/foo;bar", (String)new URI("/foo;bar").getRawPath());
        TestPath.assertEquals((String)"/foo+bar", (String)new URI("/foo+bar").getPath());
        TestPath.assertEquals((String)"/foo+bar", (String)new URI("/foo+bar").getRawPath());
        TestPath.assertEquals((String)"/foo bar", (String)new Path("http://localhost/foo bar").toUri().getPath());
        TestPath.assertEquals((String)"/foo%20bar", (String)new Path("http://localhost/foo bar").toUri().toURL().getPath());
        TestPath.assertEquals((String)"/foo?bar", (String)new URI("http", "localhost", "/foo?bar", null, null).getPath());
        TestPath.assertEquals((String)"/foo%3Fbar", (String)new URI("http", "localhost", "/foo?bar", null, null).toURL().getPath());
    }

    @Test(timeout=30000L)
    public void testMakeQualified() throws URISyntaxException {
        URI defaultUri = new URI("hdfs://host1/dir1");
        URI wd = new URI("hdfs://host2/dir2");
        TestPath.assertEquals((Object)new Path("hdfs://host1/dir/file"), (Object)new Path("file").makeQualified(defaultUri, new Path("/dir")));
        TestPath.assertEquals((Object)new Path("hdfs://host2/dir2/file"), (Object)new Path("file").makeQualified(defaultUri, new Path(wd)));
    }

    @Test(timeout=30000L)
    public void testGetName() {
        TestPath.assertEquals((String)"", (String)new Path("/").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("foo").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("/foo").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("/foo/").getName());
        TestPath.assertEquals((String)"bar", (String)new Path("/foo/bar").getName());
        TestPath.assertEquals((String)"bar", (String)new Path("hdfs://host/foo/bar").getName());
    }

    @Test(timeout=30000L)
    public void testAvroReflect() throws Exception {
        AvroTestUtil.testReflect(new Path("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.fs.Path\"}");
    }

    @Test(timeout=30000L)
    public void testGlobEscapeStatus() throws Exception {
        int i;
        if (Shell.WINDOWS) {
            return;
        }
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        Path testRoot = lfs.makeQualified(new Path(System.getProperty("test.build.data", "test/build/data"), "testPathGlob"));
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        TestPath.assertTrue((boolean)lfs.isDirectory(testRoot));
        lfs.setWorkingDirectory(testRoot);
        Object[] paths = new Path[]{new Path(testRoot, "*/f"), new Path(testRoot, "d1/f"), new Path(testRoot, "d2/f")};
        Arrays.sort(paths);
        for (Object p : paths) {
            lfs.create((Path)p).close();
            TestPath.assertTrue((boolean)lfs.exists((Path)p));
        }
        Object[] stats = lfs.listStatus(new Path(testRoot, "*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*"));
        Arrays.sort(stats);
        TestPath.assertEquals((int)paths.length, (int)stats.length);
        for (i = 0; i < paths.length; ++i) {
            TestPath.assertEquals((Object)paths[i].getParent(), (Object)stats[i].getPath());
        }
        stats = lfs.globStatus(new Path(testRoot, "\\*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*/f"));
        TestPath.assertEquals((int)paths.length, (int)stats.length);
        for (i = 0; i < paths.length; ++i) {
            TestPath.assertEquals((Object)paths[i], (Object)stats[i].getPath());
        }
        stats = lfs.globStatus(new Path(testRoot, "\\*/f"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "\\*/*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
    }

    @Test(timeout=30000L)
    public void testMergePaths() {
        TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar")));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo/bar"), (Path)new Path("/baz")));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar/baz")));
        TestPath.assertEquals((Object)new Path(Shell.WINDOWS ? "/C:/foo/bar" : "/C:/foo/C:/bar"), (Object)Path.mergePaths((Path)new Path("/C:/foo"), (Path)new Path("/C:/bar")));
        TestPath.assertEquals((Object)new Path("viewfs:///foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs:///foo"), (Path)new Path("file:///bar")));
        TestPath.assertEquals((Object)new Path("viewfs://vfsauthority/foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs://vfsauthority/foo"), (Path)new Path("file://fileauthority/bar")));
    }
}

