/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import java.util.ArrayDeque;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.metrics.RollingWindowAverage;

@InterfaceAudience.Private
final class RollingWindowAverage {
    private final ArrayDeque<DataPoint> currentPoints = new ArrayDeque();
    private final long windowSizeMs;

    public RollingWindowAverage(long windowSizeMs) {
        this.windowSizeMs = windowSizeMs;
    }

    public synchronized void addPoint(long value) {
        this.currentPoints.offer(new DataPoint(new Date(), value));
        this.cleanupOldPoints();
    }

    public synchronized long getCurrentAverage() {
        this.cleanupOldPoints();
        if (this.currentPoints.isEmpty()) {
            return 0L;
        }
        long sum = 0L;
        for (DataPoint current : this.currentPoints) {
            sum += current.getValue();
        }
        return sum / (long)this.currentPoints.size();
    }

    private void cleanupOldPoints() {
        Date cutoffTime = new Date(new Date().getTime() - this.windowSizeMs);
        while (!this.currentPoints.isEmpty() && ((DataPoint)this.currentPoints.peekFirst()).getEventTime().before(cutoffTime)) {
            this.currentPoints.removeFirst();
        }
    }
}

