/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.KeyProvider;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.SimpleKeyProvider;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestWasbUriAndConfiguration {
    private static final int FILE_SIZE = 4096;
    private static final String PATH_DELIMITER = "/";
    protected String accountName;
    protected String accountKey;
    protected static Configuration conf = null;
    private AzureBlobStorageTestAccount testAccount;

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
        }
    }

    private boolean validateIOStreams(Path filePath) throws IOException {
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        return this.validateIOStreams((FileSystem)fs, filePath);
    }

    private boolean validateIOStreams(FileSystem fs, Path filePath) throws IOException {
        FSDataOutputStream outputStream = fs.create(filePath);
        outputStream.write(new byte[4096]);
        outputStream.close();
        return 4096 == this.readInputStream(fs, filePath);
    }

    private int readInputStream(Path filePath) throws IOException {
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        return this.readInputStream((FileSystem)fs, filePath);
    }

    private int readInputStream(FileSystem fs, Path filePath) throws IOException {
        FSDataInputStream inputStream = fs.open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        return count;
    }

    @Test
    public void testConnectUsingKey() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertTrue((boolean)this.validateIOStreams(new Path("/wasb_scheme")));
    }

    @Test
    public void testConnectUsingSAS() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas, AzureBlobStorageTestAccount.CreateOptions.CreateContainer));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertFalse((boolean)this.testAccount.getFileSystem().exists(new Path("/IDontExist")));
    }

    @Test
    public void testConnectUsingSASReadonly() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas, AzureBlobStorageTestAccount.CreateOptions.CreateContainer, AzureBlobStorageTestAccount.CreateOptions.Readonly));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        String blobKey = "blobForReadonly";
        CloudBlobContainer container = this.testAccount.getRealContainer();
        CloudBlockBlob blob = container.getBlockBlobReference("blobForReadonly");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{1, 2, 3});
        blob.upload((InputStream)inputStream, 3L);
        inputStream.close();
        Path filePath = new Path("/blobForReadonly");
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        Assert.assertTrue((boolean)fs.exists(filePath));
        byte[] obtained = new byte[3];
        FSDataInputStream obtainedInputStream = fs.open(filePath);
        obtainedInputStream.readFully(obtained);
        obtainedInputStream.close();
        Assert.assertEquals((long)3L, (long)obtained[2]);
    }

    @Test
    public void testConnectUsingAnonymous() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createAnonymous((String)"testWasb.txt", (int)4096);
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertEquals((long)4096L, (long)this.readInputStream(new Path("/testWasb.txt")));
    }

    @Test
    public void testConnectToEmulator() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createForEmulator();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertTrue((boolean)this.validateIOStreams(new Path("/testFile")));
    }

    @Test
    public void testConnectToFullyQualifiedAccountMock() throws Exception {
        Configuration conf = new Configuration();
        AzureBlobStorageTestAccount.setMockAccountKey((Configuration)conf, (String)"mockAccount.mock.authority.net");
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        MockStorageInterface mockStorage = new MockStorageInterface();
        store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
        NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);
        fs.initialize(new URI("wasb://mockContainer@mockAccount.mock.authority.net"), conf);
        fs.createNewFile(new Path("/x"));
        Assert.assertTrue((boolean)mockStorage.getBackingStore().exists("http://mockAccount.mock.authority.net/mockContainer/x"));
        fs.close();
    }

    public void testConnectToRoot() throws Exception {
        String blobPrefix = String.format("wasbtests-%s-%tQ-blob", System.getProperty("user.name"), new Date());
        String inblobName = blobPrefix + "_In" + ".txt";
        String outblobName = blobPrefix + "_Out" + ".txt";
        this.testAccount = AzureBlobStorageTestAccount.createRoot((String)inblobName, (int)4096);
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertEquals((long)4096L, (long)this.readInputStream(new Path("/" + inblobName)));
        try {
            NativeAzureFileSystem fs = this.testAccount.getFileSystem();
            Path outputPath = new Path("/" + outblobName);
            FSDataOutputStream outputStream = fs.create(outputPath);
            Assert.fail((String)"Expected an AzureException when writing to root folder.");
            outputStream.write(new byte[4096]);
            outputStream.close();
        }
        catch (AzureException e) {
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            String errMsg = String.format("Expected AzureException but got %s instead.", e);
            Assert.assertTrue((String)errMsg, (boolean)false);
        }
    }

    public void testConnectWithThrottling() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createThrottled();
        Assert.assertTrue((boolean)this.validateIOStreams(new Path("/wasb_scheme")));
    }

    private static void writeSingleByte(FileSystem fs, Path testFile, int toWrite) throws Exception {
        FSDataOutputStream outputStream = fs.create(testFile);
        outputStream.write(toWrite);
        outputStream.close();
    }

    private static void assertSingleByteValue(FileSystem fs, Path testFile, int expectedValue) throws Exception {
        FSDataInputStream inputStream = fs.open(testFile);
        int byteRead = inputStream.read();
        Assert.assertTrue((String)("File unexpectedly empty: " + testFile), (byteRead >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("File has more than a single byte: " + testFile), (inputStream.read() < 0 ? 1 : 0) != 0);
        inputStream.close();
        Assert.assertEquals((String)("Unxpected content in: " + testFile), (long)expectedValue, (long)byteRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleContainers() throws Exception {
        AzureBlobStorageTestAccount firstAccount = AzureBlobStorageTestAccount.create((String)"first");
        AzureBlobStorageTestAccount secondAccount = AzureBlobStorageTestAccount.create((String)"second");
        Assume.assumeNotNull((Object[])new Object[]{firstAccount});
        Assume.assumeNotNull((Object[])new Object[]{secondAccount});
        try {
            NativeAzureFileSystem firstFs = firstAccount.getFileSystem();
            NativeAzureFileSystem secondFs = secondAccount.getFileSystem();
            Path testFile = new Path("/testWasb");
            Assert.assertTrue((boolean)this.validateIOStreams((FileSystem)firstFs, testFile));
            Assert.assertTrue((boolean)this.validateIOStreams((FileSystem)secondFs, testFile));
            TestWasbUriAndConfiguration.writeSingleByte((FileSystem)firstFs, (Path)testFile, (int)5);
            TestWasbUriAndConfiguration.writeSingleByte((FileSystem)secondFs, (Path)testFile, (int)7);
            TestWasbUriAndConfiguration.assertSingleByteValue((FileSystem)firstFs, (Path)testFile, (int)5);
            TestWasbUriAndConfiguration.assertSingleByteValue((FileSystem)secondFs, (Path)testFile, (int)7);
        }
        finally {
            firstAccount.cleanup();
            secondAccount.cleanup();
        }
    }

    @Test
    public void testDefaultKeyProvider() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "testkey";
        conf.set("fs.azure.account.key." + account, key);
        String result = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
        Assert.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void testValidKeyProvider() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "testkey";
        conf.set("fs.azure.account.key." + account, key);
        conf.setClass("fs.azure.account.keyprovider." + account, SimpleKeyProvider.class, KeyProvider.class);
        String result = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
        Assert.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void testInvalidKeyProviderNonexistantClass() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        conf.set("fs.azure.account.keyprovider." + account, "org.apache.Nonexistant.Class");
        try {
            AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
            Assert.fail((String)"Nonexistant key provider class should have thrown a KeyProviderException");
        }
        catch (KeyProviderException keyProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidKeyProviderWrongClass() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        conf.set("fs.azure.account.keyprovider." + account, "java.lang.String");
        try {
            AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
            Assert.fail((String)"Key provider class that doesn't implement KeyProvider should have thrown a KeyProviderException");
        }
        catch (KeyProviderException keyProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testNoUriAuthority() throws Exception {
        String[] wasbAliases;
        for (String defaultScheme : wasbAliases = new String[]{"wasb", "wasbs"}) {
            for (String wantedScheme : wasbAliases) {
                this.testAccount = AzureBlobStorageTestAccount.createMock();
                Configuration conf = this.testAccount.getFileSystem().getConf();
                String authority = this.testAccount.getFileSystem().getUri().getAuthority();
                URI defaultUri = new URI(defaultScheme, authority, null, null, null);
                conf.set("fs.default.name", defaultUri.toString());
                conf.addResource("azure-test.xml");
                URI wantedUri = new URI(wantedScheme + ":///random/path");
                NativeAzureFileSystem obtained = (NativeAzureFileSystem)FileSystem.get((URI)wantedUri, (Configuration)conf);
                Assert.assertNotNull((Object)obtained);
                Assert.assertEquals((Object)new URI(wantedScheme, authority, null, null, null), (Object)obtained.getUri());
                Path qualified = obtained.makeQualified(new Path(wantedUri));
                Assert.assertEquals((Object)new URI(wantedScheme, authority, wantedUri.getPath(), null, null), (Object)qualified.toUri());
                this.testAccount.cleanup();
                FileSystem.closeAll();
            }
        }
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        Configuration conf = this.testAccount.getFileSystem().getConf();
        conf.set("fs.default.name", "file:///");
        try {
            FileSystem.get((URI)new URI("wasb:///random/path"), (Configuration)conf);
            Assert.fail((String)"Should've thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

