/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.ShellDecryptionKeyProvider;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Test;

public class TestShellDecryptionKeyProvider {
    public static final Log LOG = LogFactory.getLog(TestShellDecryptionKeyProvider.class);
    private static File TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), "TestShellDecryptionKeyProvider");

    @Test
    public void testScriptPathNotSpecified() throws Exception {
        if (!Shell.WINDOWS) {
            return;
        }
        ShellDecryptionKeyProvider provider = new ShellDecryptionKeyProvider();
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "key";
        conf.set("fs.azure.account.key." + account, key);
        try {
            provider.getStorageAccountKey(account, conf);
            Assert.fail((String)"fs.azure.shellkeyprovider.script is not specified, we should throw");
        }
        catch (KeyProviderException e) {
            LOG.info((Object)("Received an expected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testValidScript() throws Exception {
        if (!Shell.WINDOWS) {
            return;
        }
        String expectedResult = "decretedKey";
        File scriptFile = new File(TEST_ROOT_DIR, "testScript.cmd");
        FileUtils.writeStringToFile((File)scriptFile, (String)("@echo %1 " + expectedResult));
        ShellDecryptionKeyProvider provider = new ShellDecryptionKeyProvider();
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "key1";
        conf.set("fs.azure.account.key." + account, key);
        conf.set("fs.azure.shellkeyprovider.script", "cmd /c " + scriptFile.getAbsolutePath());
        String result = provider.getStorageAccountKey(account, conf);
        Assert.assertEquals((Object)(key + " " + expectedResult), (Object)result);
    }
}

