/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import com.microsoft.azure.storage.core.Base64;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemMetricsSystem;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;

public final class AzureBlobStorageTestAccount {
    private static final String ACCOUNT_KEY_PROPERTY_NAME = "fs.azure.account.key.";
    private static final String SAS_PROPERTY_NAME = "fs.azure.sas.";
    private static final String TEST_CONFIGURATION_FILE_NAME = "azure-test.xml";
    private static final String TEST_ACCOUNT_NAME_PROPERTY_NAME = "fs.azure.test.account.name";
    public static final String MOCK_ACCOUNT_NAME = "mockAccount.blob.core.windows.net";
    public static final String MOCK_CONTAINER_NAME = "mockContainer";
    public static final String WASB_AUTHORITY_DELIMITER = "@";
    public static final String WASB_SCHEME = "wasb";
    public static final String PATH_DELIMITER = "/";
    public static final String AZURE_ROOT_CONTAINER = "$root";
    public static final String MOCK_WASB_URI = "wasb://mockContainer@mockAccount.blob.core.windows.net/";
    private static final String USE_EMULATOR_PROPERTY_NAME = "fs.azure.test.emulator";
    private static final String KEY_DISABLE_THROTTLING = "fs.azure.disable.bandwidth.throttling";
    private static final String KEY_READ_TOLERATE_CONCURRENT_APPEND = "fs.azure.io.read.tolerate.concurrent.append";
    public static final String DEFAULT_PAGE_BLOB_DIRECTORY = "pageBlobs";
    public static final String DEFAULT_ATOMIC_RENAME_DIRECTORIES = "/atomicRenameDir1,/atomicRenameDir2";
    private CloudStorageAccount account;
    private CloudBlobContainer container;
    private CloudBlockBlob blob;
    private NativeAzureFileSystem fs;
    private AzureNativeFileSystemStore storage;
    private MockStorageInterface mockStorage;
    private String pageBlobDirectory;
    private static final ConcurrentLinkedQueue<MetricsRecord> allMetrics = new ConcurrentLinkedQueue();
    private static boolean metricsConfigSaved = false;

    private AzureBlobStorageTestAccount(NativeAzureFileSystem fs, CloudStorageAccount account, CloudBlobContainer container) {
        this.account = account;
        this.container = container;
        this.fs = fs;
    }

    private AzureBlobStorageTestAccount(AzureNativeFileSystemStore storage, CloudStorageAccount account, CloudBlobContainer container) {
        this.account = account;
        this.container = container;
        this.storage = storage;
    }

    private AzureBlobStorageTestAccount(NativeAzureFileSystem fs, CloudStorageAccount account, CloudBlockBlob blob) {
        this.account = account;
        this.blob = blob;
        this.fs = fs;
    }

    private AzureBlobStorageTestAccount(NativeAzureFileSystem fs, MockStorageInterface mockStorage) {
        this.fs = fs;
        this.mockStorage = mockStorage;
    }

    private static void addRecord(MetricsRecord record) {
        allMetrics.add(record);
    }

    public static String getMockContainerUri() {
        return String.format("http://%s/%s", MOCK_ACCOUNT_NAME, MOCK_CONTAINER_NAME);
    }

    public static String toMockUri(String path) {
        return String.format("http://%s/%s/%s", MOCK_ACCOUNT_NAME, MOCK_CONTAINER_NAME, path);
    }

    public static String toMockUri(Path path) {
        return AzureBlobStorageTestAccount.toMockUri(path.toUri().getRawPath().substring(1));
    }

    public static Path pageBlobPath() {
        return new Path("/pageBlobs");
    }

    public static Path pageBlobPath(String fileName) {
        return new Path(AzureBlobStorageTestAccount.pageBlobPath(), fileName);
    }

    public Number getLatestMetricValue(String metricName, Number defaultValue) throws IndexOutOfBoundsException {
        boolean found = false;
        Number ret = null;
        block0: for (MetricsRecord currentRecord : allMetrics) {
            if (!this.wasGeneratedByMe(currentRecord)) continue;
            for (AbstractMetric currentMetric : currentRecord.metrics()) {
                if (!currentMetric.name().equalsIgnoreCase(metricName)) continue;
                found = true;
                ret = currentMetric.value();
                continue block0;
            }
        }
        if (!found) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IndexOutOfBoundsException(metricName);
        }
        return ret;
    }

    private boolean wasGeneratedByMe(MetricsRecord currentRecord) {
        String myFsId = this.fs.getInstrumentation().getFileSystemInstanceId().toString();
        for (MetricsTag currentTag : currentRecord.tags()) {
            if (!currentTag.name().equalsIgnoreCase("wasbFileSystemId")) continue;
            return currentTag.value().equals(myFsId);
        }
        return false;
    }

    public CloudBlockBlob getBlobReference(String blobKey) throws Exception {
        return this.container.getBlockBlobReference(String.format(blobKey, new Object[0]));
    }

    public String acquireShortLease(String blobKey) throws Exception {
        return this.getBlobReference(blobKey).acquireLease(Integer.valueOf(60), null);
    }

    public void releaseLease(String leaseID, String blobKey) throws Exception {
        AccessCondition accessCondition = new AccessCondition();
        accessCondition.setLeaseID(leaseID);
        this.getBlobReference(blobKey).releaseLease(accessCondition);
    }

    private static void saveMetricsConfigFile() {
        if (!metricsConfigSaved) {
            new ConfigBuilder().add("azure-file-system.sink.azuretestcollector.class", (Object)StandardCollector.class.getName()).save("hadoop-metrics2-azure-file-system.properties");
            metricsConfigSaved = true;
        }
    }

    public static AzureBlobStorageTestAccount createMock() throws Exception {
        return AzureBlobStorageTestAccount.createMock(new Configuration());
    }

    public static AzureBlobStorageTestAccount createMock(Configuration conf) throws Exception {
        AzureBlobStorageTestAccount.saveMetricsConfigFile();
        AzureBlobStorageTestAccount.configurePageBlobDir(conf);
        AzureBlobStorageTestAccount.configureAtomicRenameDir(conf);
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        MockStorageInterface mockStorage = new MockStorageInterface();
        store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
        NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);
        AzureBlobStorageTestAccount.setMockAccountKey(conf);
        fs.initialize(new URI(MOCK_WASB_URI), conf);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(fs, mockStorage);
        return testAcct;
    }

    private static void configurePageBlobDir(Configuration conf) {
        if (conf.get("fs.azure.page.blob.dir") == null) {
            conf.set("fs.azure.page.blob.dir", "/pageBlobs");
        }
    }

    private static void configureAtomicRenameDir(Configuration conf) {
        if (conf.get("fs.azure.atomic.rename.dir") == null) {
            conf.set("fs.azure.atomic.rename.dir", DEFAULT_ATOMIC_RENAME_DIRECTORIES);
        }
    }

    public static AzureBlobStorageTestAccount createForEmulator() throws Exception {
        AzureBlobStorageTestAccount.saveMetricsConfigFile();
        NativeAzureFileSystem fs = null;
        CloudBlobContainer container = null;
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        if (!conf.getBoolean(USE_EMULATOR_PROPERTY_NAME, false)) {
            System.out.println("Skipping emulator Azure test because configuration doesn't indicate that it's running. Please see RunningLiveWasbTests.txt for guidance.");
            return null;
        }
        CloudStorageAccount account = CloudStorageAccount.getDevelopmentStorageAccount();
        fs = new NativeAzureFileSystem();
        String containerName = String.format("wasbtests-%s-%tQ", System.getProperty("user.name"), new Date());
        container = account.createCloudBlobClient().getContainerReference(containerName);
        container.create();
        URI accountUri = AzureBlobStorageTestAccount.createAccountUri("storageemulator", containerName);
        fs.initialize(accountUri, conf);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(fs, account, container);
        return testAcct;
    }

    public static AzureBlobStorageTestAccount createOutOfBandStore(int uploadBlockSize, int downloadBlockSize) throws Exception {
        AzureBlobStorageTestAccount.saveMetricsConfigFile();
        CloudBlobContainer container = null;
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        CloudStorageAccount account = AzureBlobStorageTestAccount.createTestAccount(conf);
        if (null == account) {
            return null;
        }
        String containerName = String.format("wasbtests-%s-%tQ", System.getProperty("user.name"), new Date());
        container = account.createCloudBlobClient().getContainerReference(containerName);
        container.create();
        String accountName = conf.get(TEST_ACCOUNT_NAME_PROPERTY_NAME);
        conf.setBoolean(KEY_DISABLE_THROTTLING, true);
        conf.setBoolean(KEY_READ_TOLERATE_CONCURRENT_APPEND, true);
        URI accountUri = AzureBlobStorageTestAccount.createAccountUri(accountName, containerName);
        AzureFileSystemMetricsSystem.fileSystemStarted();
        String sourceName = NativeAzureFileSystem.newMetricsSourceName();
        String sourceDesc = "Azure Storage Volume File System metrics";
        AzureFileSystemInstrumentation instrumentation = new AzureFileSystemInstrumentation(conf);
        AzureFileSystemMetricsSystem.registerSource((String)sourceName, (String)sourceDesc, (MetricsSource)instrumentation);
        AzureNativeFileSystemStore testStorage = new AzureNativeFileSystemStore();
        testStorage.initialize(accountUri, conf, instrumentation);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(testStorage, account, container);
        return testAcct;
    }

    public static void setMockAccountKey(Configuration conf) {
        AzureBlobStorageTestAccount.setMockAccountKey(conf, MOCK_ACCOUNT_NAME);
    }

    public static void setMockAccountKey(Configuration conf, String accountName) {
        conf.set(ACCOUNT_KEY_PROPERTY_NAME + accountName, Base64.encode((byte[])new byte[]{1, 2, 3}));
    }

    private static URI createAccountUri(String accountName) throws URISyntaxException {
        return new URI("wasb://" + accountName);
    }

    private static URI createAccountUri(String accountName, String containerName) throws URISyntaxException {
        return new URI("wasb://" + containerName + WASB_AUTHORITY_DELIMITER + accountName);
    }

    public static AzureBlobStorageTestAccount create() throws Exception {
        return AzureBlobStorageTestAccount.create("");
    }

    public static AzureBlobStorageTestAccount create(String containerNameSuffix) throws Exception {
        return AzureBlobStorageTestAccount.create(containerNameSuffix, EnumSet.of(CreateOptions.CreateContainer));
    }

    public static AzureBlobStorageTestAccount createThrottled() throws Exception {
        return AzureBlobStorageTestAccount.create("", EnumSet.of(CreateOptions.useThrottling, CreateOptions.CreateContainer));
    }

    public static AzureBlobStorageTestAccount create(Configuration conf) throws Exception {
        return AzureBlobStorageTestAccount.create("", EnumSet.of(CreateOptions.CreateContainer), conf);
    }

    static CloudStorageAccount createStorageAccount(String accountName, Configuration conf, boolean allowAnonymous) throws URISyntaxException, KeyProviderException {
        String accountKey = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)accountName, (Configuration)conf);
        Object credentials = accountKey == null && allowAnonymous ? StorageCredentialsAnonymous.ANONYMOUS : new StorageCredentialsAccountAndKey(accountName.split("\\.")[0], accountKey);
        if (credentials == null) {
            return null;
        }
        return new CloudStorageAccount(credentials);
    }

    public static Configuration createTestConfiguration() {
        return AzureBlobStorageTestAccount.createTestConfiguration(null);
    }

    private static Configuration createTestConfiguration(Configuration conf) {
        if (conf == null) {
            conf = new Configuration();
        }
        conf.addResource(TEST_CONFIGURATION_FILE_NAME);
        return conf;
    }

    public static CloudStorageAccount createTestAccount() throws URISyntaxException, KeyProviderException {
        return AzureBlobStorageTestAccount.createTestAccount(AzureBlobStorageTestAccount.createTestConfiguration());
    }

    static CloudStorageAccount createTestAccount(Configuration conf) throws URISyntaxException, KeyProviderException {
        String testAccountName = conf.get(TEST_ACCOUNT_NAME_PROPERTY_NAME);
        if (testAccountName == null) {
            System.out.println("Skipping live Azure test because of missing test account. Please see RunningLiveWasbTests.txt for guidance.");
            return null;
        }
        return AzureBlobStorageTestAccount.createStorageAccount(testAccountName, conf, false);
    }

    public static AzureBlobStorageTestAccount create(String containerNameSuffix, EnumSet<CreateOptions> createOptions) throws Exception {
        return AzureBlobStorageTestAccount.create(containerNameSuffix, createOptions, null);
    }

    public static AzureBlobStorageTestAccount create(String containerNameSuffix, EnumSet<CreateOptions> createOptions, Configuration initialConfiguration) throws Exception {
        AzureBlobStorageTestAccount.saveMetricsConfigFile();
        NativeAzureFileSystem fs = null;
        CloudBlobContainer container = null;
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration(initialConfiguration);
        AzureBlobStorageTestAccount.configurePageBlobDir(conf);
        AzureBlobStorageTestAccount.configureAtomicRenameDir(conf);
        CloudStorageAccount account = AzureBlobStorageTestAccount.createTestAccount(conf);
        if (account == null) {
            return null;
        }
        fs = new NativeAzureFileSystem();
        String containerName = String.format("wasbtests-%s-%tQ%s", System.getProperty("user.name"), new Date(), containerNameSuffix);
        container = account.createCloudBlobClient().getContainerReference(containerName);
        if (createOptions.contains((Object)CreateOptions.CreateContainer)) {
            container.create();
        }
        String accountName = conf.get(TEST_ACCOUNT_NAME_PROPERTY_NAME);
        if (createOptions.contains((Object)CreateOptions.UseSas)) {
            String sas = AzureBlobStorageTestAccount.generateSAS(container, createOptions.contains((Object)CreateOptions.Readonly));
            if (!createOptions.contains((Object)CreateOptions.CreateContainer)) {
                container.delete();
            }
            conf.set(ACCOUNT_KEY_PROPERTY_NAME + accountName, "");
            conf.set(SAS_PROPERTY_NAME + containerName + "." + accountName, sas);
        }
        if (createOptions.contains((Object)CreateOptions.useThrottling)) {
            conf.setBoolean(KEY_DISABLE_THROTTLING, false);
        } else {
            conf.setBoolean(KEY_DISABLE_THROTTLING, true);
        }
        URI accountUri = AzureBlobStorageTestAccount.createAccountUri(accountName, containerName);
        fs.initialize(accountUri, conf);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(fs, account, container);
        return testAcct;
    }

    private static String generateContainerName() throws Exception {
        String containerName = String.format("wasbtests-%s-%tQ", System.getProperty("user.name"), new Date());
        return containerName;
    }

    private static String generateSAS(CloudBlobContainer container, boolean readonly) throws Exception {
        container.createIfNotExists();
        SharedAccessBlobPolicy sasPolicy = new SharedAccessBlobPolicy();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date());
        sasPolicy.setSharedAccessStartTime(calendar.getTime());
        calendar.add(10, 10);
        sasPolicy.setSharedAccessExpiryTime(calendar.getTime());
        if (readonly) {
            sasPolicy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ, SharedAccessBlobPermissions.LIST));
        } else {
            sasPolicy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ, SharedAccessBlobPermissions.WRITE, SharedAccessBlobPermissions.LIST));
        }
        BlobContainerPermissions containerPermissions = new BlobContainerPermissions();
        containerPermissions.setPublicAccess(BlobContainerPublicAccessType.OFF);
        container.uploadPermissions(containerPermissions);
        String sas = container.generateSharedAccessSignature(sasPolicy, null);
        Thread.sleep(1500L);
        return sas;
    }

    public static void primePublicContainer(CloudBlobClient blobClient, String accountName, String containerName, String blobName, int fileSize) throws Exception {
        CloudBlobContainer container = blobClient.getContainerReference(containerName);
        container.createIfNotExists();
        SharedAccessBlobPolicy sasPolicy = new SharedAccessBlobPolicy();
        sasPolicy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ, SharedAccessBlobPermissions.WRITE, SharedAccessBlobPermissions.LIST, SharedAccessBlobPermissions.DELETE));
        BlobContainerPermissions containerPermissions = new BlobContainerPermissions();
        containerPermissions.setPublicAccess(BlobContainerPublicAccessType.CONTAINER);
        containerPermissions.getSharedAccessPolicies().put("testwasbpolicy", sasPolicy);
        container.uploadPermissions(containerPermissions);
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        BlobOutputStream outputStream = blob.openOutputStream();
        outputStream.write(new byte[fileSize]);
        outputStream.close();
    }

    public static AzureBlobStorageTestAccount createAnonymous(String blobName, int fileSize) throws Exception {
        NativeAzureFileSystem fs = null;
        CloudBlobContainer container = null;
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        Configuration noTestAccountConf = new Configuration();
        CloudStorageAccount account = AzureBlobStorageTestAccount.createTestAccount(conf);
        if (account == null) {
            return null;
        }
        CloudBlobClient blobClient = account.createCloudBlobClient();
        String accountName = conf.get(TEST_ACCOUNT_NAME_PROPERTY_NAME);
        String containerName = AzureBlobStorageTestAccount.generateContainerName();
        AzureBlobStorageTestAccount.primePublicContainer(blobClient, accountName, containerName, blobName, fileSize);
        container = blobClient.getContainerReference(containerName);
        if (null == container || !container.exists()) {
            String errMsg = String.format("Container '%s' expected but not found while creating SAS account.", new Object[0]);
            throw new Exception(errMsg);
        }
        URI accountUri = AzureBlobStorageTestAccount.createAccountUri(accountName, containerName);
        fs = new NativeAzureFileSystem();
        fs.initialize(accountUri, noTestAccountConf);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(fs, account, container);
        return testAcct;
    }

    private static CloudBlockBlob primeRootContainer(CloudBlobClient blobClient, String accountName, String blobName, int fileSize) throws Exception {
        CloudBlobContainer container = blobClient.getContainerReference("https://" + accountName + PATH_DELIMITER + AZURE_ROOT_CONTAINER);
        container.createIfNotExists();
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        BlobOutputStream outputStream = blob.openOutputStream();
        outputStream.write(new byte[fileSize]);
        outputStream.close();
        return blob;
    }

    public static AzureBlobStorageTestAccount createRoot(String blobName, int fileSize) throws Exception {
        NativeAzureFileSystem fs = null;
        CloudBlobContainer container = null;
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        CloudStorageAccount account = AzureBlobStorageTestAccount.createTestAccount(conf);
        if (account == null) {
            return null;
        }
        CloudBlobClient blobClient = account.createCloudBlobClient();
        String accountName = conf.get(TEST_ACCOUNT_NAME_PROPERTY_NAME);
        CloudBlockBlob blobRoot = AzureBlobStorageTestAccount.primeRootContainer(blobClient, accountName, blobName, fileSize);
        container = blobClient.getContainerReference(AZURE_ROOT_CONTAINER);
        if (null == container || !container.exists()) {
            String errMsg = String.format("Container '%s' expected but not found while creating SAS account.", new Object[0]);
            throw new Exception(errMsg);
        }
        URI accountUri = AzureBlobStorageTestAccount.createAccountUri(accountName);
        fs = new NativeAzureFileSystem();
        fs.initialize(accountUri, conf);
        AzureBlobStorageTestAccount testAcct = new AzureBlobStorageTestAccount(fs, account, blobRoot);
        return testAcct;
    }

    public void closeFileSystem() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    public void cleanup() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.container != null) {
            this.container.deleteIfExists();
            this.container = null;
        }
        if (this.blob != null) {
            this.blob.delete();
            this.blob = null;
        }
    }

    public NativeAzureFileSystem getFileSystem() {
        return this.fs;
    }

    public AzureNativeFileSystemStore getStore() {
        return this.storage;
    }

    public CloudBlobContainer getRealContainer() {
        return this.container;
    }

    public CloudStorageAccount getRealAccount() {
        return this.account;
    }

    public MockStorageInterface getMockStorage() {
        return this.mockStorage;
    }

    public void setPageBlobDirectory(String directory) {
        this.pageBlobDirectory = directory;
    }

    public String getPageBlobDirectory() {
        return this.pageBlobDirectory;
    }

    public static class StandardCollector
    implements MetricsSink {
        public void init(SubsetConfiguration conf) {
        }

        public void putMetrics(MetricsRecord record) {
            AzureBlobStorageTestAccount.addRecord(record);
        }

        public void flush() {
        }
    }

    public static enum CreateOptions {
        UseSas,
        Readonly,
        CreateContainer,
        useThrottling;

    }
}

