/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestOutOfBandAzureBlobOperationsLive {
    private FileSystem fs;
    private AzureBlobStorageTestAccount testAccount;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
            this.fs = null;
        }
    }

    @Test
    public void outOfBandFolder_uncleMkdirs() throws Exception {
        String workingDir = "user/" + UserGroupInformation.getCurrentUser().getShortUserName() + "/";
        CloudBlockBlob blob = this.testAccount.getBlobReference(workingDir + "testFolder1/a/input/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Assert.assertTrue((boolean)this.fs.exists(new Path("testFolder1/a/input/file")));
        Path targetFolder = new Path("testFolder1/a/output");
        Assert.assertTrue((boolean)this.fs.mkdirs(targetFolder));
    }

    @Test
    public void outOfBandFolder_parentDelete() throws Exception {
        String workingDir = "user/" + UserGroupInformation.getCurrentUser().getShortUserName() + "/";
        CloudBlockBlob blob = this.testAccount.getBlobReference(workingDir + "testFolder2/a/input/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Assert.assertTrue((boolean)this.fs.exists(new Path("testFolder2/a/input/file")));
        Path targetFolder = new Path("testFolder2/a/input");
        Assert.assertTrue((boolean)this.fs.delete(targetFolder, true));
    }

    @Test
    public void outOfBandFolder_rootFileDelete() throws Exception {
        CloudBlockBlob blob = this.testAccount.getBlobReference("fileY");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Assert.assertTrue((boolean)this.fs.exists(new Path("/fileY")));
        Assert.assertTrue((boolean)this.fs.delete(new Path("/fileY"), true));
    }

    @Test
    public void outOfBandFolder_firstLevelFolderDelete() throws Exception {
        CloudBlockBlob blob = this.testAccount.getBlobReference("folderW/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Assert.assertTrue((boolean)this.fs.exists(new Path("/folderW")));
        Assert.assertTrue((boolean)this.fs.exists(new Path("/folderW/file")));
        Assert.assertTrue((boolean)this.fs.delete(new Path("/folderW"), true));
    }

    @Test
    public void outOfBandFolder_siblingCreate() throws Exception {
        String workingDir = "user/" + UserGroupInformation.getCurrentUser().getShortUserName() + "/";
        CloudBlockBlob blob = this.testAccount.getBlobReference(workingDir + "testFolder3/a/input/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Assert.assertTrue((boolean)this.fs.exists(new Path("testFolder3/a/input/file")));
        Path targetFile = new Path("testFolder3/a/input/file2");
        FSDataOutputStream s2 = this.fs.create(targetFile);
        s2.close();
    }

    @Test
    public void outOfBandFolder_create_rootDir() throws Exception {
        Path targetFile = new Path("/newInRoot");
        FSDataOutputStream s2 = this.fs.create(targetFile);
        s2.close();
    }

    @Test
    public void outOfBandFolder_rename() throws Exception {
        String workingDir = "user/" + UserGroupInformation.getCurrentUser().getShortUserName() + "/";
        CloudBlockBlob blob = this.testAccount.getBlobReference(workingDir + "testFolder4/a/input/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Path srcFilePath = new Path("testFolder4/a/input/file");
        Assert.assertTrue((boolean)this.fs.exists(srcFilePath));
        Path destFilePath = new Path("testFolder4/a/input/file2");
        this.fs.rename(srcFilePath, destFilePath);
    }

    @Test
    public void outOfBandSingleFile_rename() throws Exception {
        String workingDir = "user/" + UserGroupInformation.getCurrentUser().getShortUserName() + "/";
        CloudBlockBlob blob = this.testAccount.getBlobReference(workingDir + "testFolder5/a/input/file");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Path srcFilePath = new Path("testFolder5/a/input/file");
        Assert.assertTrue((boolean)this.fs.exists(srcFilePath));
        Path destFilePath = new Path("testFolder5/file2");
        this.fs.rename(srcFilePath, destFilePath);
    }

    @Test
    public void outOfBandFolder_rename_rootLevelFiles() throws Exception {
        CloudBlockBlob blob = this.testAccount.getBlobReference("fileX");
        BlobOutputStream s = blob.openOutputStream();
        s.close();
        Path srcFilePath = new Path("/fileX");
        Assert.assertTrue((boolean)this.fs.exists(srcFilePath));
        Path destFilePath = new Path("/fileXrename");
        this.fs.rename(srcFilePath, destFilePath);
    }
}

