/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.PageBlobOutputStream;
import org.apache.hadoop.fs.azure.StorageInterface;

final class PageBlobOutputStream
extends OutputStream
implements Syncable {
    private static final int MAX_RAW_BYTES_PER_REQUEST = 0x400000;
    private static final int MAX_PAGES_IN_REQUEST = 8192;
    private static final int MAX_DATA_BYTES_PER_REQUEST = 4177410;
    private final StorageInterface.CloudPageBlobWrapper blob;
    private final OperationContext opContext;
    private volatile IOException lastError;
    private long currentBlobSize;
    private long currentBlobOffset;
    private byte[] previousLastPageDataWritten = new byte[0];
    private ByteArrayOutputStream outBuffer;
    private final LinkedBlockingQueue<Runnable> ioQueue;
    private final ThreadPoolExecutor ioThreadPool;
    private WriteRequest lastQueuedTask;
    public static final Log LOG = LogFactory.getLog(AzureNativeFileSystemStore.class);
    public static final long PAGE_BLOB_MIN_SIZE = 0x8000000L;
    public static final long PAGE_BLOB_DEFAULT_EXTENSION_SIZE = 0x8000000L;
    private long configuredPageBlobExtensionSize;

    public PageBlobOutputStream(StorageInterface.CloudPageBlobWrapper blob, OperationContext opContext, Configuration conf) throws StorageException {
        this.blob = blob;
        this.outBuffer = new ByteArrayOutputStream();
        this.opContext = opContext;
        this.lastQueuedTask = null;
        this.ioQueue = new LinkedBlockingQueue();
        this.ioThreadPool = new ThreadPoolExecutor(1, 1, 2L, TimeUnit.SECONDS, this.ioQueue);
        long pageBlobConfigSize = conf.getLong("fs.azure.page.blob.size", 0L);
        LOG.debug((Object)("Read value of fs.azure.page.blob.size as " + pageBlobConfigSize + " from configuration (0 if not present)."));
        long pageBlobSize = Math.max(0x8000000L, pageBlobConfigSize);
        if (pageBlobSize % 512L != 0L) {
            pageBlobSize += 512L - pageBlobSize % 512L;
        }
        blob.create(pageBlobSize, new BlobRequestOptions(), opContext);
        this.currentBlobSize = pageBlobSize;
        this.configuredPageBlobExtensionSize = conf.getLong("fs.azure.page.blob.extension.size", 0L);
        if (this.configuredPageBlobExtensionSize < 0x8000000L) {
            this.configuredPageBlobExtensionSize = 0x8000000L;
        }
        if (this.configuredPageBlobExtensionSize % 512L != 0L) {
            this.configuredPageBlobExtensionSize += 512L - this.configuredPageBlobExtensionSize % 512L;
        }
    }

    private void checkStreamState() throws IOException {
        if (this.lastError != null) {
            throw this.lastError;
        }
    }

    @Override
    public void close() throws IOException {
        LOG.debug((Object)"Closing page blob output stream.");
        this.flush();
        this.checkStreamState();
        this.ioThreadPool.shutdown();
        try {
            LOG.debug((Object)this.ioThreadPool.toString());
            if (!this.ioThreadPool.awaitTermination(10L, TimeUnit.MINUTES)) {
                LOG.debug((Object)"Timed out after 10 minutes waiting for IO requests to finish");
                this.logAllStackTraces();
                LOG.debug((Object)this.ioThreadPool.toString());
                throw new IOException("Timed out waiting for IO requests to finish");
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Caught InterruptedException");
            Thread.currentThread().interrupt();
        }
        this.lastError = new IOException("Stream is already closed.");
    }

    private void logAllStackTraces() {
        Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
        for (Thread key : liveThreads.keySet()) {
            LOG.debug((Object)("Thread " + key.getName()));
            StackTraceElement[] trace = liveThreads.get(key);
            for (int j = 0; j < trace.length; ++j) {
                LOG.debug((Object)("\tat " + trace[j]));
            }
        }
    }

    private synchronized void flushIOBuffers() {
        if (this.outBuffer.size() == 0) {
            return;
        }
        this.lastQueuedTask = new WriteRequest(this, this.outBuffer.toByteArray());
        this.ioThreadPool.execute((Runnable)this.lastQueuedTask);
        this.outBuffer = new ByteArrayOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conditionalExtendFile() {
        long MAX_PAGE_BLOB_SIZE = 0x10000000000L;
        if (this.currentBlobSize == 0x10000000000L) {
            return;
        }
        if (this.currentBlobSize - this.currentBlobOffset <= 0x400000L) {
            CloudPageBlob cloudPageBlob = (CloudPageBlob)this.blob.getBlob();
            long newSize = this.currentBlobSize + this.configuredPageBlobExtensionSize;
            if (newSize > 0x10000000000L) {
                newSize = 0x10000000000L;
            }
            int MAX_RETRIES = 3;
            int retries = 1;
            boolean resizeDone = false;
            while (!resizeDone && retries <= 3) {
                try {
                    cloudPageBlob.resize(newSize);
                    resizeDone = true;
                    this.currentBlobSize = newSize;
                }
                catch (StorageException e) {
                    LOG.warn((Object)("Failed to extend size of " + cloudPageBlob.getUri()));
                    try {
                        Thread.sleep(2000 * retries * retries);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    ++retries;
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkStreamState();
        this.flushIOBuffers();
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInternal(data, offset, length);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    private synchronized void writeInternal(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            this.checkStreamState();
            int availableBufferBytes = 4177410 - this.outBuffer.size();
            int nextWrite = Math.min(availableBufferBytes, length);
            this.outBuffer.write(data, offset, nextWrite);
            offset += nextWrite;
            length -= nextWrite;
            if (this.outBuffer.size() > 4177410) {
                throw new RuntimeException("Internal error: maximum write size " + Integer.toString(4177410) + "exceeded.");
            }
            if (this.outBuffer.size() != 4177410) continue;
            this.flushIOBuffers();
        }
    }

    public synchronized void hsync() throws IOException {
        LOG.debug((Object)"Entering PageBlobOutputStream#hsync().");
        long start = System.currentTimeMillis();
        this.flush();
        LOG.debug((Object)this.ioThreadPool.toString());
        try {
            if (this.lastQueuedTask != null) {
                this.lastQueuedTask.waitTillDone();
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        LOG.debug((Object)("Leaving PageBlobOutputStream#hsync(). Total hsync duration = " + (System.currentTimeMillis() - start) + " msec."));
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    @Deprecated
    public void sync() throws IOException {
        this.hflush();
    }

    @VisibleForTesting
    void killIoThreads() {
        this.ioThreadPool.shutdownNow();
    }

    static /* synthetic */ IOException access$000(PageBlobOutputStream x0) {
        return x0.lastError;
    }

    static /* synthetic */ byte[] access$100(PageBlobOutputStream x0) {
        return x0.previousLastPageDataWritten;
    }

    static /* synthetic */ long access$214(PageBlobOutputStream x0, long x1) {
        return x0.currentBlobOffset += x1;
    }

    static /* synthetic */ byte[] access$102(PageBlobOutputStream x0, byte[] x1) {
        x0.previousLastPageDataWritten = x1;
        return x1;
    }

    static /* synthetic */ long access$222(PageBlobOutputStream x0, long x1) {
        return x0.currentBlobOffset -= x1;
    }

    static /* synthetic */ void access$300(PageBlobOutputStream x0) {
        x0.conditionalExtendFile();
    }

    static /* synthetic */ long access$200(PageBlobOutputStream x0) {
        return x0.currentBlobOffset;
    }

    static /* synthetic */ OperationContext access$400(PageBlobOutputStream x0) {
        return x0.opContext;
    }

    static /* synthetic */ StorageInterface.CloudPageBlobWrapper access$500(PageBlobOutputStream x0) {
        return x0.blob;
    }

    static /* synthetic */ IOException access$002(PageBlobOutputStream x0, IOException x1) {
        x0.lastError = x1;
        return x0.lastError;
    }
}

